package com.skellybuilds.servermodmenu.mixin;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.skellybuilds.servermodmenu.ModMenu.*;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_9112;


@Mixin(class_412.class)
public abstract class MixinConnectScreen {
	@Shadow
	@Mutable // allows modifying private final fields if needed
	private class_2561 status;



	@Inject(
		method = "connect(Lnet/minecraft/client/MinecraftClient;Lnet/minecraft/client/network/ServerAddress;Lnet/minecraft/client/network/ServerInfo;Lnet/minecraft/client/network/CookieStorage;)V",
		at = @At("HEAD")
	)
	private void beforeLogin(class_310 client, class_639 address, class_642 info, @Nullable class_9112 cookieStorage, CallbackInfo ci) {
		// Update the text
		String ip = info.field_3761.split(":")[0];

		if(MainNetwork.isSocketValid(ip)) {
			this.status = class_2561.method_43470("Sending mod data...");

			sendmodstoserver(ip, client);

			// When done, you can change it again
			this.status = class_2561.method_43471("connect.connecting");
		}
	}
}

