package com.skellybuilds.servermodmenu.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.text.*;
import java.util.List;
import java.util.Random;

@Environment(EnvType.CLIENT)
public class DrawingUtil {
	private static final class_310 CLIENT = class_310.method_1551();

	public static void drawRandomVersionBackground(Mod mod, class_332 DrawContext, int x, int y, int width, int height) {
		int seed = mod.getName().hashCode() + mod.getVersion().hashCode();
		Random random = new Random(seed);
		int color = 0xFF000000 | class_3532.method_15369(random.nextFloat(1f), random.nextFloat(0.7f, 0.8f), 0.9f);
		if (!ModMenuConfig.RANDOM_JAVA_COLORS.getValue()) {
			color = 0xFFDD5656;
		}
//		RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
		DrawContext.method_25294(x, y, x + width, y + height, color);
	}

	public static void drawRandomVersionBackgroundS(SMod mod, class_332 DrawContext, int x, int y, int width, int height) {
		int seed = mod.meta.name.hashCode() + mod.getVersion().hashCode();
		Random random = new Random(seed);
		int color = 0xFF000000 | class_3532.method_15369(random.nextFloat(1f), random.nextFloat(0.7f, 0.8f), 0.9f);
		if (!ModMenuConfig.RANDOM_JAVA_COLORS.getValue()) {
			color = 0xFFDD5656;
		}
//		RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
		DrawContext.method_25294(x, y, x + width, y + height, color);
	}

	public static void drawWrappedString(class_332 DrawContext, String string, int x, int y, int wrapWidth, int lines, int color) {
		while (string != null && string.endsWith("\n")) {
			string = string.substring(0, string.length() - 1);
		}
		List<class_5348> strings = CLIENT.field_1772.method_27527().method_27495(class_2561.method_43470(string), wrapWidth, class_2583.field_24360);
		for (int i = 0; i < strings.size(); i++) {
			if (i >= lines) {
				break;
			}
			class_5348 renderable = strings.get(i);
			if (i == lines - 1 && strings.size() > lines) {
				renderable = class_5348.method_29433(strings.get(i), class_5348.method_29430("..."));
			}
			class_5481 line = class_2477.method_10517().method_30934(renderable);
			int x1 = x;
			if (CLIENT.field_1772.method_1726()) {
				int width = CLIENT.field_1772.method_30880(line);
				x1 += (float) (wrapWidth - width);
			}
			DrawContext.method_51430(CLIENT.field_1772, line, x1, y + i * CLIENT.field_1772.field_2000, color, false);
		}
	}

	public static void drawBadge(class_332 DrawContext, int x, int y, int tagWidth, class_5481 text, int outlineColor, int fillColor, int textColor) {
		DrawContext.method_25294(x + 1, y - 1, x + tagWidth, y, outlineColor);
		DrawContext.method_25294(x, y, x + 1, y + CLIENT.field_1772.field_2000, outlineColor);
		DrawContext.method_25294(x + 1, y + 1 + CLIENT.field_1772.field_2000 - 1, x + tagWidth, y + CLIENT.field_1772.field_2000 + 1, outlineColor);
		DrawContext.method_25294( x + tagWidth, y, x + tagWidth + 1, y + CLIENT.field_1772.field_2000, outlineColor);
		DrawContext.method_25294( x + 1, y, x + tagWidth, y + CLIENT.field_1772.field_2000, fillColor);
		DrawContext.method_51430(CLIENT.field_1772, text, (int) (x + 1 + (tagWidth - CLIENT.field_1772.method_30880(text)) / (float) 2), y + 1, textColor, false);
	}
}
