package com.skellybuilds.servermodmenu.util.mod;

import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.util.DrawingUtil;
import java.util.Set;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class ModBadgeRenderer {
	protected int startX, startY, badgeX, badgeY, badgeMax;
	protected Mod mod;
	protected SMod smod;
	protected boolean useSMOD;
	protected class_310 client;
	protected final ModsScreen screen;

	public ModBadgeRenderer(int startX, int startY, int endX, SMod mod, ModsScreen screen) {
		this.startX = startX;
		this.startY = startY;
		this.badgeMax = endX;
		this.smod = mod;
		useSMOD = true;
		this.screen = screen;
		this.client = class_310.method_1551();
	}

	public ModBadgeRenderer(int startX, int startY, int endX, Mod mod, ModsScreen screen) {
		this.startX = startX;
		this.startY = startY;
		this.badgeMax = endX;
		this.mod = mod;
		this.screen = screen;
		this.client = class_310.method_1551();
	}

	public void draw(class_332 DrawContext, int mouseX, int mouseY) {
		this.badgeX = startX;
		this.badgeY = startY;
		Set<Mod.Badge> badges = mod.getBadges();
		badges.forEach(badge -> drawBadge(DrawContext, badge, mouseX, mouseY));
	}

	public void drawBadge(class_332 DrawContext, Mod.Badge badge, int mouseX, int mouseY) {
		this.drawBadge(DrawContext, badge.getText().method_30937(), badge.getOutlineColor(), badge.getFillColor(), mouseX, mouseY);
	}

	public void drawBadge(class_332 DrawContext, class_5481 text, int outlineColor, int fillColor, int mouseX, int mouseY) {
		int width = client.field_1772.method_30880(text) + 6;
		if (badgeX + width < badgeMax) {
			DrawingUtil.drawBadge(DrawContext, badgeX, badgeY, width, text, outlineColor, fillColor, 0xCACACA);
			badgeX += width + 3;
		}
	}

	public Mod getMod() {
		return mod;
	}
	public SMod getSMod() {
		return smod;
	}
}
