package com.skellybuilds.servermodmenu.util.mod;

import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.ModMenu;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_3545;

public class ModSearch {

	public static boolean validSearchQuery(String query) {
		return query != null && !query.isEmpty();
	}

	public static List<Mod> search(ModsScreen screen, String query, List<Mod> candidates) {
		if (!validSearchQuery(query)) {
			return candidates;
		}



		return candidates.stream()
				.map(modContainer -> new class_3545<>(modContainer, passesFilters(screen, modContainer, query.toLowerCase(Locale.ROOT))))
				.filter(pair -> pair.method_15441() > 0)
				.sorted((a, b) -> b.method_15441() - a.method_15441())
				.map(class_3545::method_15442)
				.collect(Collectors.toList());
	}

	public static List<SMod> searchS(ModsScreen screen, String query, List<SMod> candidates) {
		if (!validSearchQuery(query)) {
			return candidates;
		}
		return candidates.stream()
			.map(modContainer -> new class_3545<>(modContainer, passesFilters(screen, modContainer, query.toLowerCase(Locale.ROOT))))
			.filter(pair -> pair.method_15441() > 0)
			.sorted((a, b) -> b.method_15441() - a.method_15441())
			.map(class_3545::method_15442)
			.collect(Collectors.toList());
	}

	private static int passesFilters(ModsScreen screen, SMod mod, String query) {
		String modId = mod.getId();
		String modName = mod.meta.name;
		String modTranslatedName = mod.meta.name;
		String modDescription = mod.meta.baseDesc;
		String modTranslatedDescription = mod.meta.baseDesc;
		String modServer = mod.server;
		//String modSummary = mod.getSummary();

		String library = class_1074.method_4662("modmenu.searchTerms.library");
		String patchwork = class_1074.method_4662("modmenu.searchTerms.patchwork");
		String modpack = class_1074.method_4662("modmenu.searchTerms.modpack");
		String deprecated = class_1074.method_4662("modmenu.searchTerms.deprecated");
		String clientside = class_1074.method_4662("modmenu.searchTerms.clientside");
		String configurable = class_1074.method_4662("modmenu.searchTerms.configurable");
		String hasUpdate = class_1074.method_4662("modmenu.searchTerms.hasUpdate");

		// Some basic search, could do with something more advanced but this will do for now
		if (modName.toLowerCase(Locale.ROOT).contains(query) // Search default mod name
				|| modTranslatedName.toLowerCase(Locale.ROOT).contains(query) // Search localized mod name
				|| modId.toLowerCase(Locale.ROOT).contains(query) // Search mod ID
		) {
			if(!Objects.equals(ModMenu.SMODS.get(modServer).get(mod.getId()).server, modServer))
				return 0; // if the server
			return query.length() >= 3 ? 2 : 1;
		}

		if (modDescription.toLowerCase(Locale.ROOT).contains(query) // Search default mod description
				|| modTranslatedDescription.toLowerCase(Locale.ROOT).contains(query) // Search localized mod description
				|| authorMatches(mod, query) // Search via author

		) {
			return 1;
		}

		// Allow parent to pass filter if a child passes

		return 0;
	}

	private static int passesFilters(ModsScreen screen, Mod mod, String query) {
		String modId = mod.getId();
		String modName = mod.getName();
		String modTranslatedName = mod.getTranslatedName();
		String modDescription = mod.getDescription();
		String modTranslatedDescription = mod.getTranslatedDescription();
		String modSummary = mod.getSummary();

		String library = class_1074.method_4662("modmenu.searchTerms.library");
		String patchwork = class_1074.method_4662("modmenu.searchTerms.patchwork");
		String modpack = class_1074.method_4662("modmenu.searchTerms.modpack");
		String deprecated = class_1074.method_4662("modmenu.searchTerms.deprecated");
		String clientside = class_1074.method_4662("modmenu.searchTerms.clientside");
		String configurable = class_1074.method_4662("modmenu.searchTerms.configurable");
		String hasUpdate = class_1074.method_4662("modmenu.searchTerms.hasUpdate");

		// Libraries are currently hidden, ignore them entirely
		if (mod.isHidden() || !ModMenuConfig.SHOW_LIBRARIES.getValue() && mod.getBadges().contains(Mod.Badge.LIBRARY)) {
			return 0;
		}

		// Some basic search, could do with something more advanced but this will do for now
		if (modName.toLowerCase(Locale.ROOT).contains(query) // Search default mod name
			|| modTranslatedName.toLowerCase(Locale.ROOT).contains(query) // Search localized mod name
			|| modId.toLowerCase(Locale.ROOT).contains(query) // Search mod ID
		) {
			return query.length() >= 3 ? 2 : 1;
		}

		if (modDescription.toLowerCase(Locale.ROOT).contains(query) // Search default mod description
			|| modTranslatedDescription.toLowerCase(Locale.ROOT).contains(query) // Search localized mod description
			|| modSummary.toLowerCase(Locale.ROOT).contains(query) // Search mod summary
			|| authorMatches(mod, query) // Search via author
			|| library.contains(query) && mod.getBadges().contains(Mod.Badge.LIBRARY) // Search for lib mods
			|| patchwork.contains(query) && mod.getBadges().contains(Mod.Badge.PATCHWORK_FORGE) // Search for patchwork mods
			|| modpack.contains(query) && mod.getBadges().contains(Mod.Badge.MODPACK) // Search for modpack mods
			|| deprecated.contains(query) && mod.getBadges().contains(Mod.Badge.DEPRECATED) // Search for deprecated mods
			|| clientside.contains(query) && mod.getBadges().contains(Mod.Badge.CLIENT) // Search for clientside mods
			|| configurable.contains(query) && screen.getModHasConfigScreen().get(modId) // Search for mods that can be configured
			|| hasUpdate.contains(query) && mod.getModrinthData() != null // Search for mods that have updates
		) {
			return 1;
		}

		// Allow parent to pass filter if a child passes
		if (ModMenu.PARENT_MAP.keySet().contains(mod)) {
			for (Mod child : ModMenu.PARENT_MAP.get(mod)) {
				int result = passesFilters(screen, child, query);

				if (result > 0) {
					return result;
				}
			}
		}
		return 0;
	}

	private static boolean authorMatches(Mod mod, String query) {
		return mod.getAuthors().stream()
				.map(s -> s.toLowerCase(Locale.ROOT))
				.anyMatch(s -> s.contains(query.toLowerCase(Locale.ROOT)));
	}

	private static boolean authorMatches(SMod mod, String query) {
		return Arrays.stream(mod.meta.authors)
			.map(s -> s.toLowerCase(Locale.ROOT))
			.anyMatch(s -> s.contains(query.toLowerCase(Locale.ROOT)));
	}

}
