package com.skellybuilds.servermodmenu.util.mod.fabric;

import com.skellybuilds.servermodmenu.ModMenu;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FabricIconHandler implements Closeable {
	private static final Logger LOGGER = LoggerFactory.getLogger("Mod Menu | FabricIconHandler");

	private final Map<Path, class_1043> modIconCache = new HashMap<>();

	public class_1043 createIcon(ModContainer iconSource, String iconPath) {
		try {
			Path path = iconSource.getPath(iconPath);
			class_1043 cachedIcon = getCachedModIcon(path);
			if (cachedIcon != null) {
				return cachedIcon;
			}
			cachedIcon = getCachedModIcon(path);
			if (cachedIcon != null) {
				return cachedIcon;
			}
			try (InputStream inputStream = Files.newInputStream(path)) {
				class_1011 image = class_1011.method_4309(Objects.requireNonNull(inputStream));
				Validate.validState(image.method_4323() == image.method_4307(), "Must be square icon");
				class_1043 tex = new class_1043(() -> class_2960.method_60655(ModMenu.MOD_ID, path.toString()).toString(), image);
				cacheModIcon(path, tex);
				return tex;
			}

		} catch (IllegalStateException e) {
			if (e.getMessage().equals("Must be square icon")) {
				LOGGER.error("Mod icon must be a square for icon source {}: {}", iconSource.getMetadata().getId(), iconPath, e);
			}

			return null;
		} catch (Throwable t) {
			if (!iconPath.equals("assets/" + iconSource.getMetadata().getId() + "/icon.png")) {
				LOGGER.error("Invalid mod icon for icon source {}: {}", iconSource.getMetadata().getId(), iconPath, t);
			}
			return null;
		}
	}

	@Override
	public void close() {
		for (class_1043 tex : modIconCache.values()) {
			tex.close();
		}
	}

	class_1043 getCachedModIcon(Path path) {
		return modIconCache.get(path);
	}

	void cacheModIcon(Path path, class_1043 tex) {
		modIconCache.put(path, tex);
	}
}
