/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.skellybuilds.servermodmenu.api.ConfigScreenFactory;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.config.ModMenuConfigManager;
import com.skellybuilds.servermodmenu.db.ModAdapter;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.event.ModMenuEventHandler;
import com.skellybuilds.servermodmenu.gui.EntryButton;
import com.skellybuilds.servermodmenu.util.ModrinthUtil;
import com.skellybuilds.servermodmenu.util.Networking;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import java.net.InetSocketAddress;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1076;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6368;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "servermodmenu";
    public static final String GITHUB_REF = "SkellyBuilds/ServerModMenu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Server Mod Menu");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public static final Gson GSON_MINIFIED = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final List<String> idsDLD = new ArrayList<String>();
    public static final Map<String, EntryButton> buttonEntries = new HashMap<String, EntryButton>();
    public static final Map<String, Map<String, SMod>> SMODS = new HashMap<String, Map<String, SMod>>();
    public static Map<String, SMod> SMODSA = new HashMap<String, SMod>();
    public static final Map<String, Mod> MODS = new HashMap<String, Mod>();
    public static final Map<String, Mod> ROOT_MODS = new HashMap<String, Mod>();
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP = LinkedListMultimap.create();
    public static final Networking MainNetwork = new Networking();
    private static Map<String, ConfigScreenFactory<?>> configScreenFactories = new HashMap();
    private static List<Map<String, ConfigScreenFactory<?>>> delayedScreenFactoryProviders = new ArrayList();
    public static boolean isAllDFB = false;
    private static int cachedDisplayedModCount = -1;
    public static boolean runningQuilt = FabricLoader.getInstance().isModLoaded("quilt_loader");
    public static boolean devEnvironment = FabricLoader.getInstance().isDevelopmentEnvironment();
    boolean event = false;
    private static String prevLoc;

    public static class_437 getConfigScreen(String modid, class_437 menuScreen) {
        if (!delayedScreenFactoryProviders.isEmpty()) {
            delayedScreenFactoryProviders.forEach(map -> map.forEach(configScreenFactories::putIfAbsent));
            delayedScreenFactoryProviders.clear();
        }
        if (ModMenuConfig.HIDDEN_CONFIGS.getValue().contains(modid)) {
            return null;
        }
        ConfigScreenFactory<?> factory = configScreenFactories.get(modid);
        if (factory != null) {
            return factory.create(menuScreen);
        }
        return null;
    }

    private static void detectLangEvent(class_641 serverList, class_310 client) {
        class_1076 languageManager = client.method_1526();
        String currentLanguage = languageManager.method_4669();
        if (!Objects.equals(currentLanguage, prevLoc)) {
            ModMenu.sendlocaletonetwork(serverList, client);
        } else {
            try {
                Thread.sleep(1250L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted: {}", (Object)e.toString());
            }
        }
    }

    public static void sendlocaletonetwork(class_641 serverList, class_310 client) {
        serverList.method_2981();
        for (int i = 0; i < serverList.method_2984(); ++i) {
            String currentLanguageC;
            Networking.ServerAddress parsedAd;
            Optional<InetSocketAddress> optAddress;
            class_642 serverInfo = serverList.method_2982(i);
            if (serverInfo.field_3761.contains(":")) {
                serverInfo.field_3761 = serverInfo.field_3761.substring(0, serverInfo.field_3761.indexOf(":"));
            }
            if (!(optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd = Networking.ServerAddress.parse(serverInfo.field_3761)).map(class_6368::method_36902)).isPresent()) continue;
            InetSocketAddress inetSocketAddress = optAddress.get();
            String testS = inetSocketAddress.getAddress().getHostAddress();
            class_1076 languageManager = client.method_1526();
            prevLoc = currentLanguageC = languageManager.method_4669();
            MainNetwork.connect(testS, inetSocketAddress.getPort());
            MainNetwork.send(testS, "addploc|" + client.method_1548().method_1676() + "|" + currentLanguageC);
        }
    }

    public static void sendmodstoserver(String ip, class_310 client) {
        Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(ip);
        Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
        if (optAddress.isPresent()) {
            InetSocketAddress inetSocketAddress = optAddress.get();
            ArrayList<String> stringArray = new ArrayList<String>();
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                stringArray.add(mod.getMetadata().getId());
            }
            String testS = inetSocketAddress.getAddress().getHostAddress();
            String data = "{\"playerN\":" + client.method_1548().method_1676() + ", \"data\":" + ((Object)stringArray).toString() + "}";
            MainNetwork.connect(testS, inetSocketAddress.getPort());
            MainNetwork.send(testS, "addpmods|" + data);
        } else {
            ArrayList<String> stringArray = new ArrayList<String>();
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                stringArray.add(mod.getMetadata().getId());
            }
            String data = "{\"playerN\":" + client.method_1548().method_1676() + ", \"data\":" + ((Object)stringArray).toString() + "}";
            MainNetwork.connect(ip, 0);
            MainNetwork.send(ip, "addpmods|" + data);
        }
    }

    public static void sendmodstonetwork(class_641 serverList, class_310 client) {
        serverList.method_2981();
        for (int i = 0; i < serverList.method_2984(); ++i) {
            Networking.ServerAddress parsedAd;
            Optional<InetSocketAddress> optAddress;
            class_642 serverInfo = serverList.method_2982(i);
            if (serverInfo.field_3761.contains(":")) {
                serverInfo.field_3761 = serverInfo.field_3761.substring(0, serverInfo.field_3761.indexOf(":"));
            }
            if ((optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd = Networking.ServerAddress.parse(serverInfo.field_3761)).map(class_6368::method_36902)).isPresent()) {
                InetSocketAddress inetSocketAddress = optAddress.get();
                ArrayList stringArray = new ArrayList();
                for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                    stringArray.add(mod.getMetadata().getId());
                }
                String testS = inetSocketAddress.getAddress().getHostAddress();
                String data = "{\"playerN\":" + client.method_1548().method_1676() + ", \"data\":" + ((Object)stringArray).toString() + "}";
                MainNetwork.connect(testS, inetSocketAddress.getPort());
                MainNetwork.send(testS, "addpmods|" + data);
                continue;
            }
            ArrayList<String> stringArray = new ArrayList<String>();
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                stringArray.add(mod.getMetadata().getId());
            }
            String data = "{\"playerN\":" + client.method_1548().method_1676() + ", \"data\":" + ((Object)stringArray).toString() + "}";
            MainNetwork.connect(serverInfo.field_3761, 27752);
            MainNetwork.send(serverInfo.field_3761, "addpmods|" + data);
        }
    }

    public static void ConnectAndDetectPort(String serverIP, Networking network) {
        Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(serverIP);
        Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
        if (optAddress.isPresent()) {
            InetSocketAddress inetSocketAddress = optAddress.get();
            network.connect(optAddress.get().getAddress().getHostAddress(), inetSocketAddress.getPort());
        } else {
            network.connect(optAddress.get().getAddress().getHostAddress(), 27752);
        }
    }

    public static void LoadServerListConnections(class_641 list, Networking network) {
        SMod[][] ModsA = new SMod[][]{new SMod[0]};
        SMODS.clear();
        list.method_2981();
        for (int i = 0; i < list.method_2984(); ++i) {
            class_642 serverInfo = list.method_2982(i);
            network.connect(serverInfo.field_3761, 0);
            if (!network.isSocketValid(serverInfo.field_3761)) continue;
            try {
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(SMod.class, (Object)new ModAdapter());
                Gson gson = gsonBuilder.create();
                String str = MainNetwork.requestNResponse(serverInfo.field_3761, "getall|" + class_310.method_1551().method_1548().method_1676());
                ModsA[0] = (SMod[])gson.fromJson(str, SMod[].class);
                LOGGER.info(Arrays.toString(ModsA[0]));
                boolean sinit = false;
                if (ModsA[0].length < 1) {
                    SMODS.computeIfAbsent(serverInfo.field_3761, k -> new HashMap());
                }
                for (SMod smod : ModsA[0]) {
                    if (!sinit) {
                        SMODS.computeIfAbsent(serverInfo.field_3761, k -> new HashMap());
                        SMODSA = new HashMap<String, SMod>();
                        sinit = true;
                    }
                    smod.server = serverInfo.field_3761;
                    SMODS.get(serverInfo.field_3761).put(smod.getId(), smod);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void LoadServer(String ip, Networking network) {
        SMod[][] ModsA = new SMod[][]{new SMod[0]};
        Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(ip);
        Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
        if (optAddress.isPresent()) {
            InetSocketAddress inetSocketAddress = optAddress.get();
            network.connect(optAddress.get().getAddress().getHostAddress(), inetSocketAddress.getPort());
        } else {
            network.connect(optAddress.get().getAddress().getHostAddress(), 27752);
        }
        if (network.isSocketValid(optAddress.get().getAddress().getHostAddress())) {
            return;
        }
        try {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(SMod.class, (Object)new ModAdapter());
            Gson gson = gsonBuilder.create();
            String str = MainNetwork.requestNResponse(optAddress.get().getAddress().getHostAddress(), "getall|" + class_310.method_1551().method_1548().method_1676());
            ModsA[0] = (SMod[])gson.fromJson(str, SMod[].class);
            LOGGER.info(Arrays.toString(ModsA[0]));
            boolean sinit = false;
            if (ModsA[0].length < 1) {
                SMODS.computeIfAbsent(optAddress.get().getAddress().getHostAddress(), k -> new HashMap());
            }
            for (SMod smod : ModsA[0]) {
                if (!sinit) {
                    SMODS.computeIfAbsent(optAddress.get().getAddress().getHostAddress(), k -> new HashMap());
                    SMODSA = new HashMap<String, SMod>();
                    sinit = true;
                }
                smod.server = optAddress.get().getAddress().getHostAddress();
                SMODS.get(optAddress.get().getAddress().getHostAddress()).put(smod.getId(), smod);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void onInitializeClient() {
        class_310 client = class_310.method_1551();
        class_641 serverList = new class_641(client);
        ClientTickEvents.END_CLIENT_TICK.register(client2 -> {
            new Thread(() -> {
                if (client2 != null) {
                    ModMenu.detectLangEvent(serverList, client2);
                }
            }).start();
            if (!this.event && client2 != null && client2.method_1526() != null) {
                ModMenu.sendlocaletonetwork(serverList, client2);
                this.event = true;
            }
        });
        ModMenu.LoadServerListConnections(serverList, MainNetwork);
        ModMenuConfigManager.initializeConfig();
        HashSet modpackMods = new HashSet();
        ModrinthUtil.checkForUpdates();
        HashMap dummyParents = new HashMap();
        AtomicBoolean doitOnce = new AtomicBoolean(false);
        ModMenuEventHandler.register();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static boolean areModUpdatesAvailable() {
        if (!ModMenuConfig.UPDATE_CHECKER.getValue()) {
            return false;
        }
        for (Mod mod : MODS.values()) {
            if (mod.isHidden() || !ModMenuConfig.SHOW_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || mod.getModrinthData() == null && !mod.getChildHasUpdate()) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> !(!ModMenuConfig.COUNT_CHILDREN.getValue() && mod.getParent() != null || !ModMenuConfig.COUNT_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !ModMenuConfig.COUNT_HIDDEN_MODS.getValue() && mod.isHidden())).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static class_2561 createModsButtonText(boolean title) {
        boolean isIcon;
        ModMenuConfig.TitleMenuButtonStyle titleStyle = ModMenuConfig.MODS_BUTTON_STYLE.getValue();
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
        boolean bl = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : (isIcon = gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON);
        boolean isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.REPLACE_BUGS;
        class_5250 modsText = class_2561.method_43471((String)"servermodmenu.title");
        if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && !isIcon) {
            String count = ModMenu.getDisplayedModCount();
            if (isShort) {
                modsText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43469((String)"modmenu.loaded.short", (Object[])new Object[]{count}));
            } else {
                Object key;
                String specificKey = "modmenu.loaded." + count;
                Object object = key = class_1074.method_4663((String)specificKey) ? specificKey : "modmenu.loaded";
                if (ModMenuConfig.EASTER_EGGS.getValue() && class_1074.method_4663((String)(specificKey + ".secret"))) {
                    key = specificKey + ".secret";
                }
                modsText.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{count}));
            }
        }
        return modsText;
    }
}

