/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.gui.widget;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.gui.widget.entries.ModListEntry;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8219;

public class DescriptionListWidget
extends class_350<DescriptionEntry> {
    private static final class_2561 HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.hasUpdate");
    private static final class_2561 EXPERIMENTAL_TEXT = class_2561.method_43471((String)"modmenu.experimental").method_27692(class_124.field_1065);
    private static final class_2561 MODRINTH_TEXT = class_2561.method_43471((String)"modmenu.modrinth");
    private static final class_2561 CHILD_HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.childHasUpdate");
    private static final class_2561 LINKS_TEXT = class_2561.method_43471((String)"modmenu.links");
    private static final class_2561 SOURCE_TEXT = class_2561.method_43471((String)"modmenu.source").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 LICENSE_TEXT = class_2561.method_43471((String)"modmenu.license");
    private static final class_2561 VIEW_CREDITS_TEXT = class_2561.method_43471((String)"modmenu.viewCredits").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 CREDITS_TEXT = class_2561.method_43471((String)"modmenu.credits");
    private final ModsScreen parent;
    private final class_327 textRenderer;
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(class_310 client, int width, int height, int y, int itemHeight, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.textRenderer = client.field_1772;
    }

    public DescriptionEntry getSelectedOrNull() {
        return null;
    }

    public int method_25322() {
        return this.field_22758 - 10;
    }

    protected int method_65507() {
        return this.field_22758 - 6 + this.method_46426();
    }

    public void method_47399(class_6382 builder) {
        Mod mod = this.parent.getSelectedEntry().getMod();
        if (mod == null) {
            return;
        }
        builder.method_37033(class_6381.field_33788, mod.getTranslatedName() + " " + mod.getPrefixedVersion());
    }

    private void rebuildUI() {
        block30: {
            int indent;
            int wrapWidth;
            DescriptionEntry emptyEntry;
            block31: {
                block32: {
                    SMod smod;
                    block33: {
                        ModListEntry selectedEntry = this.parent.getSelectedEntry();
                        if (selectedEntry == null) {
                            return;
                        }
                        if (selectedEntry == this.lastSelected) break block30;
                        this.lastSelected = selectedEntry;
                        this.method_25339();
                        this.method_44382(-1.7976931348623157E308);
                        if (this.lastSelected == null) break block30;
                        emptyEntry = new DescriptionEntry(class_5481.field_26385);
                        wrapWidth = this.method_25322() - 5;
                        if (!this.lastSelected.useSMOD()) break block31;
                        smod = this.lastSelected.getSMod();
                        if (this.lastSelected.renderSvnNO) break block32;
                        String description = smod.meta.baseDesc;
                        if (!description.isEmpty()) {
                            for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)description.replaceAll("\n", "\n\n")), wrapWidth)) {
                                this.method_25396().add(new DescriptionEntry(line));
                            }
                        }
                        Map<String, String> links = smod.meta.links.getLinks();
                        String sourceLink = smod.meta.links.getLink("sources");
                        if (links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue()) break block30;
                        if (!Objects.equals(links.get("modmenu.links"), "{}")) {
                            this.method_25396().add(emptyEntry);
                            for (Object line : this.textRenderer.method_1728((class_5348)LINKS_TEXT, wrapWidth)) {
                                this.method_25396().add(new DescriptionEntry((class_5481)line));
                            }
                            if (sourceLink != null) {
                                int indent2 = 8;
                                for (Object line : this.textRenderer.method_1728((class_5348)SOURCE_TEXT, wrapWidth - 16)) {
                                    this.method_25396().add(new LinkEntry((class_5481)line, sourceLink, indent2));
                                    indent2 = 16;
                                }
                            }
                            links.forEach((key, value) -> {
                                int indent = 8;
                                Gson gson = new Gson();
                                JsonObject jsonObject = (JsonObject)gson.fromJson(value, JsonObject.class);
                                for (Map.Entry entry : jsonObject.entrySet()) {
                                    for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43471((String)((String)entry.getKey())).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
                                        this.method_25396().add(new LinkEntry(line, ((JsonElement)entry.getValue()).getAsString(), indent));
                                        indent = 16;
                                    }
                                }
                            });
                        }
                        if (ModMenuConfig.HIDE_MOD_CREDITS.getValue()) break block30;
                        if (!"minecraft".equals(smod.getId())) break block33;
                        this.method_25396().add(emptyEntry);
                        for (Object line : this.textRenderer.method_1728((class_5348)VIEW_CREDITS_TEXT, wrapWidth)) {
                            this.method_25396().add(new MojangCreditsEntry((class_5481)line));
                        }
                        break block30;
                    }
                    if ("java".equals(smod.getId())) break block30;
                    String[] mergedArray = new String[smod.meta.authors.length + smod.meta.contributers.length];
                    System.arraycopy(smod.meta.authors, 0, mergedArray, 0, smod.meta.authors.length);
                    System.arraycopy(smod.meta.contributers, 0, mergedArray, smod.meta.authors.length, smod.meta.contributers.length);
                    List<String> credits = Arrays.asList(mergedArray);
                    if (!credits.isEmpty()) {
                        this.method_25396().add(emptyEntry);
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)CREDITS_TEXT, wrapWidth)) {
                            this.method_25396().add(new DescriptionEntry(line));
                        }
                        for (String credit : credits) {
                            int indent3 = 8;
                            for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)credit), wrapWidth - 16)) {
                                this.method_25396().add(new DescriptionEntry(line, indent3));
                                indent3 = 16;
                            }
                        }
                    }
                    break block30;
                }
                return;
            }
            Mod mod = this.lastSelected.getMod();
            String description = mod.getTranslatedDescription();
            if (!description.isEmpty()) {
                for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)description.replaceAll("\n", "\n\n")), wrapWidth)) {
                    this.method_25396().add(new DescriptionEntry(line));
                }
            }
            Map<String, String> links = mod.getLinks();
            String sourceLink = mod.getSource();
            if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                this.method_25396().add(emptyEntry);
                for (Object line : this.textRenderer.method_1728((class_5348)LINKS_TEXT, wrapWidth)) {
                    this.method_25396().add(new DescriptionEntry((class_5481)line));
                }
                if (sourceLink != null) {
                    int indent4 = 8;
                    for (class_5481 line2 : this.textRenderer.method_1728((class_5348)SOURCE_TEXT, wrapWidth - 16)) {
                        this.method_25396().add(new LinkEntry(line2, sourceLink, indent4));
                        indent4 = 16;
                    }
                }
                links.forEach((key, value) -> {
                    int indent = 8;
                    for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43471((String)key).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
                        this.method_25396().add(new LinkEntry(line, (String)value, indent));
                        indent = 16;
                    }
                });
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    Object line;
                    this.method_25396().add(emptyEntry);
                    for (class_5481 line2 : this.textRenderer.method_1728((class_5348)LICENSE_TEXT, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry(line2));
                    }
                    line = licenses.iterator();
                    while (line.hasNext()) {
                        String license = (String)line.next();
                        indent = 8;
                        for (class_5481 line3 : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)license), wrapWidth - 16)) {
                            this.method_25396().add(new DescriptionEntry(line3, indent));
                            indent = 16;
                        }
                    }
                }
            }
            if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                List<String> credits;
                if ("minecraft".equals(mod.getId())) {
                    this.method_25396().add(emptyEntry);
                    for (Object line : this.textRenderer.method_1728((class_5348)VIEW_CREDITS_TEXT, wrapWidth)) {
                        this.method_25396().add(new MojangCreditsEntry((class_5481)line));
                    }
                } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                    this.method_25396().add(emptyEntry);
                    for (class_5481 line2 : this.textRenderer.method_1728((class_5348)CREDITS_TEXT, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry(line2));
                    }
                    for (String credit : credits) {
                        indent = 8;
                        for (class_5481 line3 : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)credit), wrapWidth - 16)) {
                            this.method_25396().add(new DescriptionEntry(line3, indent));
                            indent = 16;
                        }
                    }
                }
            }
        }
    }

    public void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.parent.getSelectedEntry() != this.lastSelected) {
            this.rebuildUI();
        }
        this.method_49603(drawContext);
        super.method_25311(drawContext, mouseX, mouseY, delta);
        drawContext.method_44380();
    }

    protected class DescriptionEntry
    extends class_4265.class_4266<DescriptionEntry> {
        protected class_5481 text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(class_5481 text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(class_5481 text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void method_25343(class_332 DrawContext, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            DrawContext.method_35720(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, -5592406);
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(class_5481 text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(class_5481 text, String link) {
            this(text, link, 0);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new class_407(open -> {
                    if (open) {
                        class_156.method_668().method_670(this.link);
                    }
                    DescriptionListWidget.this.field_22740.method_1507((class_437)DescriptionListWidget.this.parent);
                    DescriptionListWidget.this.parent.modList.setSelected(DescriptionListWidget.this.lastSelected);
                }, this.link, false));
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(class_5481 text) {
            super(text);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new MinecraftCredits(this));
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        class MinecraftCredits
        extends class_8219 {
            public MinecraftCredits(MojangCreditsEntry this$1) {
                super((class_437)this$1.DescriptionListWidget.this.parent);
            }
        }
    }
}

