/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.gui.widget;

import com.skellybuilds.servermodmenu.ModMenu;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.gui.widget.entries.ChildEntry;
import com.skellybuilds.servermodmenu.gui.widget.entries.IndependentEntry;
import com.skellybuilds.servermodmenu.gui.widget.entries.ModListEntry;
import com.skellybuilds.servermodmenu.gui.widget.entries.ParentEntry;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import com.skellybuilds.servermodmenu.util.mod.ModSearch;
import com.skellybuilds.servermodmenu.util.mod.fabric.FabricIconHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;

public class ModListWidget
extends class_4280<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    public List<Mod> mods = null;
    public List<SMod> smods = null;
    public boolean useSMod = false;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private final Map<String, SMod> SaddedMods = new HashMap<String, SMod>();
    private String selectedModId = null;
    private boolean scrolling;
    private final FabricIconHandler iconHandler = new FabricIconHandler();
    private boolean isInit = false;
    private double scrollAm;
    private int origT;

    public ModListWidget(class_310 client, int width, int height, int y, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y, entryHeight);
        this.parent = parent;
        if (list != null) {
            if (list.useSMod) {
                this.useSMod = true;
                this.smods = list.smods;
            } else {
                this.mods = list.mods;
            }
        }
        this.filter(searchTerm, false);
    }

    public boolean method_25370() {
        return this.parent.method_25399() == this;
    }

    public void select(String id, String server) {
        this.method_25396().forEach(entryM -> {
            if (Objects.equals(entryM.smod.getId(), id)) {
                if (entryM.useSMOD()) {
                    if (Objects.equals(entryM.serverName, server)) {
                        this.setSelected((ModListEntry)((Object)entryM));
                        if (entryM.renderSvnNO) {
                            return;
                        }
                        this.field_22740.method_44713().method_70816((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{entryM.smod.meta.name}));
                    }
                } else if (Objects.equals(entryM.serverName, server)) {
                    this.setSelected((ModListEntry)((Object)entryM));
                    this.field_22740.method_44713().method_70816((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{entryM.mod.getTranslatedName()}));
                }
            }
        });
    }

    public void setSelected(ModListEntry entry) {
        if (entry == null) {
            return;
        }
        super.method_25313((class_350.class_351)entry);
        if (entry.useSMOD()) {
            this.selectedModId = entry.getSMod().getId();
            this.parent.updateSelectedEntry((ModListEntry)this.method_25334());
        } else {
            this.selectedModId = entry.getMod().getId();
            this.parent.updateSelectedEntry((ModListEntry)this.method_25334());
        }
    }

    protected boolean method_25332(int index) {
        ModListEntry selected = (ModListEntry)this.method_25334();
        if (selected != null) {
            if (selected.useSMOD()) {
                if (!Objects.equals(selected.getSMod().server, ((ModListEntry)this.method_25326((int)index)).getSMod().server)) {
                    return false;
                }
                return selected.getSMod().getId().equals(((ModListEntry)this.method_25326(index)).getSMod().getId());
            }
            if (!Objects.equals(selected.serverName, ((ModListEntry)this.method_25326((int)index)).serverName)) {
                return false;
            }
            return selected.getMod().getId().equals(((ModListEntry)this.method_25326(index)).getMod().getId());
        }
        return false;
    }

    public int addEntry(ModListEntry entry) {
        if (entry.useSMOD()) {
            if (this.SaddedMods.get(entry.serverName) == entry.smod) {
                return 0;
            }
            this.SaddedMods.put(entry.serverName, entry.smod);
            int i = super.method_25321((class_350.class_351)entry);
            if (entry.getSMod().getId().equals(this.selectedModId)) {
                this.setSelected(entry);
            }
            return i;
        }
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.method_25321((class_350.class_351)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        if (entry.useSMOD()) {
            this.SaddedMods.remove(entry.serverName, entry.smod);
        } else {
            this.addedMods.remove(entry.mod);
        }
        return super.method_25330((class_350.class_351)entry);
    }

    protected void removeAllEntries() {
        this.method_25396().forEach(x$0 -> super.method_25330(x$0));
    }

    protected ModListEntry remove(int index) {
        if (((ModListEntry)this.method_25326(index)).useSMOD()) {
            this.addedMods.remove(((ModListEntry)this.method_25326((int)index)).smod);
        } else {
            this.addedMods.remove(((ModListEntry)this.method_25326((int)index)).mod);
        }
        return (ModListEntry)super.method_25338(index);
    }

    public void reloadFilters() {
        this.isInit = false;
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.isInit = false;
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains((Object)Mod.Badge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.method_25339();
        this.SaddedMods.clear();
        this.addedMods.clear();
        this.removeAllEntries();
        if (this.useSMod) {
            if (ModMenu.SMODSA.isEmpty()) {
                HashMap modsMA = new HashMap();
                ModMenu.SMODS.forEach((svn, mod) -> {
                    for (Map.Entry entry : mod.entrySet()) {
                        String id = (String)entry.getKey();
                        SMod mods2 = (SMod)entry.getValue();
                        modsMA.put(id, mods2);
                    }
                });
            } else {
                Map<String, SMod> modsMA = ModMenu.SMODSA;
            }
            AtomicBoolean addMoreY = new AtomicBoolean(false);
            ModMenu.SMODS.forEach((serverName, modsM) -> {
                HashSet mods = new HashSet(modsM.values());
                this.smods = null;
                if (this.smods == null || refresh) {
                    this.smods = new ArrayList<SMod>();
                    this.smods.addAll(mods);
                    this.smods.sort(ModMenuConfig.SSORTING.getValue().getComparator());
                }
                List<SMod> matched = ModSearch.searchS(this.parent, searchTerm, this.smods);
                AtomicBoolean isHidden = new AtomicBoolean(false);
                boolean isF = true;
                for (SMod mod : matched) {
                    ModMenuConfig.HIDDEN_SERVERS.getValue().forEach(name -> {
                        if (Objects.equals(name, serverName) && !ModMenuConfig.SHOWHIDDENSERVERS.getValue()) {
                            isHidden.set(true);
                        }
                    });
                    if (matched.isEmpty() && (isHidden.get() && ModMenuConfig.SHOWHIDDENSERVERS.getValue() || !isHidden.get())) {
                        this.addEntry(new IndependentEntry(new SMod("d", "d", null, false, false), this, (String)serverName, true, true, addMoreY.get()));
                    }
                    if (isHidden.get() && ModMenuConfig.SHOWHIDDENSERVERS.getValue() || !isHidden.get()) {
                        this.addEntry(new IndependentEntry(mod, this, (String)serverName, isF, false, addMoreY.get()));
                    }
                    if ((!isHidden.get() || !ModMenuConfig.SHOWHIDDENSERVERS.getValue()) && isHidden.get()) continue;
                    isF = false;
                }
                addMoreY.set(true);
                if (this.method_25396().size() > 1) {
                    this.setSelected((ModListEntry)this.method_25326(0));
                } else {
                    this.setSelected(null);
                }
            });
            this.parent.calcServersSize();
            this.isInit = true;
        } else {
            ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
                Map<String, Boolean> modHasConfigScreen;
                Boolean hasConfig;
                if (ModMenuConfig.CONFIG_MODE.getValue() && !(hasConfig = (modHasConfigScreen = this.parent.getModHasConfigScreen()).get(mod.getId())).booleanValue()) {
                    return false;
                }
                return !mod.isHidden();
            }).collect(Collectors.toSet()));
            if (DEBUG) {
                mods = new ArrayList(mods);
            }
            if (this.mods == null || refresh) {
                this.mods = new ArrayList<Mod>();
                this.mods.addAll(mods);
                this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
            }
            List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
            for (Mod mod2 : matched) {
                String modId = mod2.getId();
                if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
                if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                    List children = ModMenu.PARENT_MAP.get((Object)mod2);
                    children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                    ParentEntry parent = new ParentEntry(mod2, children, this);
                    this.addEntry(parent);
                    if (!this.parent.showModChildren.contains(modId)) continue;
                    List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                    for (Mod child : validChildren) {
                        this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                    }
                    continue;
                }
                this.addEntry(new IndependentEntry(mod2, this));
            }
            if (this.parent.getSelectedEntry() != null && !this.method_25396().isEmpty() || this.method_25334() != null && ((ModListEntry)this.method_25334()).getMod() != this.parent.getSelectedEntry().getMod()) {
                for (ModListEntry entry : this.method_25396()) {
                    if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                    this.setSelected(entry);
                }
            } else if (this.method_25334() == null && !this.method_25396().isEmpty() && this.method_25326(0) != null) {
                this.setSelected((ModListEntry)this.method_25326(0));
            }
        }
    }

    protected void method_25311(class_332 DrawContext, int mouseX, int mouseY, float delta) {
        int entryCount = this.method_25340();
        if (this.isInit) {
            for (int index = 0; index < entryCount; ++index) {
                if (this.method_25396().isEmpty() || index > this.method_25396().size()) {
                    return;
                }
                ModListEntry entry = (ModListEntry)this.method_25326(index);
                int entryTop = this.method_25337(index) + 12;
                int entryHeight = this.field_22741 - 4;
                int rowWidth = this.method_25322();
                int entryLeft = this.method_25342();
                if (entry.moreY) {
                    // empty if block
                }
                if (this.method_25332(index) && !entry.renderSvnNO) {
                    int entryContentLeft = entryLeft + entry.getXOffset() - 2;
                    int entryContentWidth = rowWidth - entry.getXOffset() + 4;
                    this.drawSelectionHighlight(DrawContext, entryContentLeft, entryTop, entryContentWidth, entryHeight, this.method_25370() ? -1 : -8355712, -16777216);
                }
                entryLeft = this.method_25342();
                entry.method_25343(DrawContext, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
            }
        }
    }

    public void ensureVisible(ModListEntry entry) {
        super.method_25328((class_350.class_351)entry);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.method_25334() != null) {
            return ((ModListEntry)this.method_25334()).method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.method_46427())) - this.field_22748 + (int)this.method_44387() - 4;
        int index = int_5 / this.field_22741;
        return x < (double)this.method_65507() && x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (ModListEntry)((Object)this.method_25396().get(index)) : null;
    }

    public int method_25322() {
        return this.field_22758 - (Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.method_46426() + 6;
    }

    public int method_25368() {
        return this.field_22758;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.method_25396()) {
            if (c.useSMOD()) {
                if (!set.contains(c.getSMod().getId())) continue;
                ++count;
                continue;
            }
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    protected void drawSelectionHighlight(class_332 context, int x, int y, int width, int height, int borderColor, int fillColor) {
        context.method_25294(x, y - 2, x + width, y + height + 2, borderColor);
        context.method_25294(x + 1, y - 1, x + width - 1, y + height + 1, fillColor);
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

