/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.skellybuilds.servermodmenu.ModMenu;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.IDN;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_6368;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Networking {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Server Mod Menu");
    private final ConcurrentMap<String, ServerConnection> connections = new ConcurrentHashMap<String, ServerConnection>();
    public Map<String, Thread> downloadThreads = new HashMap<String, Thread>();
    public Map<String, String> networkErrors = new HashMap<String, String>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final long DEFAULT_REQUEST_TIMEOUT_MS = 5000L;
    final ReentrantLock exclusiveLock = new ReentrantLock();

    public void connect(String ip, int port) {
        String key;
        ServerConnection conn;
        if (port == 0) {
            port = 27752;
        }
        if ((conn = (ServerConnection)this.connections.get(key = Networking.normalizeIp(ip = this.GetIPData(ip)))) != null && conn.isHealthy()) {
            LOGGER.info("Already connected to {}", (Object)key);
            return;
        }
        try {
            Socket socket = new Socket();
            socket.setTcpNoDelay(true);
            socket.connect(new InetSocketAddress(key, port), 3000);
            ServerConnection sc = new ServerConnection(key, port, socket);
            ServerConnection prev = this.connections.put(key, sc);
            if (prev != null) {
                prev.close();
            }
            sc.start();
            LOGGER.info("Connected to {}:{}", (Object)key, (Object)port);
        }
        catch (IOException e) {
            LOGGER.error("Could not connect to {}:{} - {}", new Object[]{key, port, e.getMessage()});
        }
    }

    private String GetIPData(String ipD) {
        String ip = "";
        ServerAddress parsedAd = ServerAddress.parse(ipD);
        Optional<InetSocketAddress> optAddress = AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
        if (optAddress.isPresent()) {
            InetSocketAddress inetSocketAddress = optAddress.get();
            ip = optAddress.get().getAddress().getHostAddress();
        }
        return ip;
    }

    public boolean isSocketValid(String ip) {
        String key = Networking.normalizeIp(ip = this.GetIPData(ip));
        ServerConnection c = (ServerConnection)this.connections.get(key);
        return c != null && c.isHealthy();
    }

    public boolean send(String ip, String data) {
        ServerConnection c = (ServerConnection)this.connections.get(Networking.normalizeIp(ip = this.GetIPData(ip)));
        if (c == null || !c.isHealthy()) {
            return false;
        }
        c.enqueueOutgoing(data);
        try {
            c.pollIncoming(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public String request(String ip, String data, long timeoutMs) {
        ServerConnection c = (ServerConnection)this.connections.get(Networking.normalizeIp(ip = this.GetIPData(ip)));
        if (c == null || !c.isHealthy()) {
            return null;
        }
        try {
            c.enqueueOutgoing(data);
            return c.pollIncoming(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public String request(String ip, String data) {
        return this.request(ip, data, 5000L);
    }

    public void onMessage(BiConsumer<String, String> handler) {
        this.connections.values().forEach(conn -> conn.setMessageHandler(handler));
    }

    public boolean downloadFile(String ip, String filename, Path dest, long timeoutMs) {
        ServerConnection c = (ServerConnection)this.connections.get(Networking.normalizeIp(ip = this.GetIPData(ip)));
        if (c == null || !c.isHealthy()) {
            return false;
        }
        try {
            return c.downloadFile(filename, dest, timeoutMs);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Download failed for {}:{} -> {}", new Object[]{ip, filename, e.getMessage()});
            return false;
        }
    }

    public void clearAll(String ip) {
        ServerConnection c = (ServerConnection)this.connections.get(Networking.normalizeIp(ip = this.GetIPData(ip)));
        if (c == null || !c.isHealthy()) {
            return;
        }
        c.clearAll();
    }

    public boolean downloadFile(String ip, String filename, Path dest) {
        return this.downloadFile(ip, filename, dest, TimeUnit.SECONDS.toMillis(60L));
    }

    public void disconnect(String ip) {
        String key = Networking.normalizeIp(ip);
        ServerConnection sc = (ServerConnection)this.connections.remove(key);
        if (sc != null) {
            sc.close();
        }
    }

    public void shutdown() {
        this.connections.values().forEach(ServerConnection::close);
        this.connections.clear();
        this.scheduler.shutdownNow();
    }

    private static String normalizeIp(String ip) {
        if (ip == null) {
            return "";
        }
        if (ip.contains(":")) {
            return ip.substring(0, ip.indexOf(":"));
        }
        return ip;
    }

    public String requestNResponse(String ip, String data) {
        String res = this.request(ip = this.GetIPData(ip), data, 5000L);
        if (res == null) {
            return "EXCEPTION";
        }
        return res;
    }

    public boolean isDthreadsDone() {
        return !this.downloadThreads.isEmpty();
    }

    public boolean isDthreadDone(String ip, String id) {
        return this.downloadThreads.get(ip + id) == null;
    }

    public void requestNDownload(String ip, String id) {
        if (ModMenu.idsDLD.contains(id) || Networking.isModAlreadyPresent(id)) {
            LOGGER.info("Mod {} already present", (Object)id);
            return;
        }
        Thread downloadThread = new Thread(() -> {
            try {
                Path modFile;
                boolean ok;
                if (id.contains("fabric-api") || id.contains("fabricloader") || id.contains("minecraft")) {
                    return;
                }
                while (!this.exclusiveLock.tryLock()) {
                }
                int port = 27752;
                this.connect(ip, port);
                this.clearAll(ip);
                String fileN = this.requestNResponse(ip, "getmod|" + id);
                if (fileN == null) {
                    LOGGER.error("Mod {} does not exist or skipped.", (Object)id);
                    this.networkErrors.put(ip + id, "ERR");
                    this.exclusiveLock.unlock();
                    return;
                }
                Path modsFolder = Paths.get("./mods", new String[0]);
                if (!Files.exists(modsFolder, new LinkOption[0])) {
                    Files.createDirectories(modsFolder, new FileAttribute[0]);
                }
                if (!(ok = this.downloadFile(ip, fileN, modFile = modsFolder.resolve(fileN), TimeUnit.SECONDS.toMillis(60L)))) {
                    LOGGER.error("Failed to download {}", (Object)fileN);
                    this.networkErrors.put(ip + id, "ERR");
                    this.exclusiveLock.unlock();
                    return;
                }
                this.checkAndDownloadDependencies(ip, modFile);
                ModMenu.idsDLD.add(id);
                boolean allHidden = ModMenu.buttonEntries.values().stream().allMatch(b -> !b.visible);
                if (allHidden) {
                    ModMenu.isAllDFB = true;
                }
                LOGGER.info("Mod downloaded successfully: {}", (Object)fileN);
                this.networkErrors.put(ip + id, "OK");
            }
            catch (Exception e) {
                LOGGER.error("Failed to download mod {}: {}", new Object[]{id, e.getMessage(), e});
                this.networkErrors.put(ip + id, "ERR");
                this.exclusiveLock.unlock();
            }
            this.downloadThreads.remove(ip + id);
            this.exclusiveLock.unlock();
        }, "[ServerModMenu] Download Manager - " + ip + " " + id);
        this.downloadThreads.put(ip + id, downloadThread);
        downloadThread.setDaemon(true);
        downloadThread.start();
    }

    private void checkAndDownloadDependencies(String ip, Path modFilePath) {
        Thread td = new Thread(() -> {
            block19: {
                try (JarFile jarFile = new JarFile(modFilePath.toFile());){
                    ZipEntry entry = jarFile.getEntry("fabric.mod.json");
                    if (entry == null) break block19;
                    try (InputStream inputStream = jarFile.getInputStream(entry);){
                        JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
                        if (jsonObject.has("depends")) {
                            JsonObject dependencies = jsonObject.getAsJsonObject("depends");
                            for (String dep : dependencies.keySet()) {
                                String depVersion;
                                JsonElement versionElement = dependencies.get(dep);
                                if (versionElement.isJsonArray()) {
                                    StringBuilder versionBuilder = new StringBuilder();
                                    for (JsonElement element : versionElement.getAsJsonArray()) {
                                        if (!versionBuilder.isEmpty()) {
                                            versionBuilder.append(", ");
                                        }
                                        versionBuilder.append(element.getAsString());
                                    }
                                    depVersion = versionBuilder.toString();
                                } else {
                                    depVersion = versionElement.getAsString();
                                }
                                LOGGER.info("Dependency found: {} version: {}", (Object)dep, (Object)depVersion);
                                if (Networking.isModAlreadyPresent(dep) || Objects.equals(dep, "fabricloader")) continue;
                                this.requestNDownload(ip, dep);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read mod dependencies: {}", (Object)e.getMessage());
                }
            }
        });
        td.setDaemon(true);
        td.start();
        while (td.getState() == Thread.State.RUNNABLE) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public static boolean isModAlreadyPresent(String modName) {
        Optional modContainerOptional = FabricLoader.getInstance().getModContainer(modName);
        if (modContainerOptional.isEmpty()) {
            return ModMenu.idsDLD.contains(modName);
        }
        return true;
    }

    static int portOrDefault(String port) {
        try {
            return Integer.parseInt(port.trim());
        }
        catch (Exception var2) {
            return 27752;
        }
    }

    private static class ServerConnection {
        final String ip;
        final int port;
        Socket socket;
        volatile boolean running = false;
        final BlockingQueue<String> outgoing = new LinkedBlockingQueue<String>();
        final BlockingQueue<String> incoming = new LinkedBlockingQueue<String>();
        Thread senderThread;
        Thread listenerThread;
        volatile BiConsumer<String, String> messageHandler = null;
        AtomicBoolean pauseListener = new AtomicBoolean(false);
        ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream();

        ServerConnection(String ip, int port, Socket socket) throws IOException {
            this.ip = ip;
            this.port = port;
            this.socket = socket;
        }

        boolean isHealthy() {
            return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
        }

        void start() throws IOException {
            if (!this.isHealthy()) {
                throw new IOException("Socket not connected");
            }
            this.running = true;
            this.pauseListener.set(false);
            this.senderThread = new Thread(this::runSender, "[Net-Sender] " + this.ip);
            this.senderThread.setDaemon(true);
            this.senderThread.start();
            this.listenerThread = new Thread(this::runListener, "[Net-Listener] " + this.ip);
            this.listenerThread.setDaemon(true);
            this.listenerThread.start();
        }

        void setMessageHandler(BiConsumer<String, String> handler) {
            this.messageHandler = handler;
        }

        void enqueueOutgoing(String s) {
            this.outgoing.offer(s);
        }

        void clearAll() {
            this.incoming.clear();
            this.lineBuffer.reset();
        }

        String pollIncoming(long timeout, TimeUnit unit) throws InterruptedException {
            String data = this.incoming.poll(timeout, unit);
            return data == null ? "TIMEOUT" : data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runSender() {
            try (PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);){
                while (this.running && !this.socket.isClosed()) {
                    try {
                        String msg = this.outgoing.take();
                        out.println(msg);
                        out.flush();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Sender thread for {} stopped: {}", (Object)this.ip, (Object)e.getMessage());
            }
            finally {
                this.running = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runListener() {
            try {
                InputStream in = this.socket.getInputStream();
                byte[] buf = new byte[8192];
                while (this.running) {
                    int read;
                    if (this.pauseListener.get() || (read = in.read(buf)) == -1) continue;
                    for (int i = 0; i < read; ++i) {
                        byte b = buf[i];
                        if (b == 10) {
                            String line = this.lineBuffer.toString(StandardCharsets.UTF_8);
                            if (line.endsWith("\r")) {
                                line = line.substring(0, line.length() - 1);
                            }
                            this.incoming.offer(line);
                            if (this.messageHandler != null) {
                                this.messageHandler.accept(this.ip, line);
                            }
                            this.lineBuffer.reset();
                            continue;
                        }
                        this.lineBuffer.write(b);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Listener thread for {} stopped: {}", (Object)this.ip, (Object)e.getMessage());
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                this.running = false;
            }
        }

        boolean downloadFile(String filename, Path dest, long timeoutMs) throws IOException, InterruptedException {
            this.pauseListener.set(true);
            PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
            InputStream in = this.socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            out.println("download|" + filename);
            out.flush();
            String header = this.pollIncoming(timeoutMs, TimeUnit.MICROSECONDS);
            if (!header.startsWith("filesize|")) {
                throw new IOException("Invalid download header: " + header);
            }
            long fileSize = Long.parseLong(header.split("\\|")[1]);
            PrintWriter writer = new PrintWriter(this.socket.getOutputStream(), true);
            writer.println("OKAY");
            writer.flush();
            try (FileOutputStream fos = new FileOutputStream(dest.toFile());){
                byte[] buf = new byte[8192];
                boolean read = false;
                long downloaded = 0L;
                long lastPercent = -1L;
                while (downloaded < fileSize) {
                    int read2 = in.read(buf);
                    if (read2 == -1) {
                        throw new IOException("Unexpected EOF before receiving full file");
                    }
                    fos.write(buf, 0, read2);
                    long percent = (downloaded += (long)read2) * 100L / fileSize;
                    if (percent == lastPercent) continue;
                    LOGGER.info("Progress: " + percent + "%");
                    lastPercent = percent;
                }
            }
            this.pauseListener.set(false);
            try {
                ZipFile z = new ZipFile(dest.toFile());
                z.close();
            }
            catch (ZipException ze) {
                LOGGER.error("Downloaded file is not a valid zip: {}", (Object)ze.getMessage());
                Files.deleteIfExists(dest);
                return false;
            }
            return true;
        }

        void close() {
            this.running = false;
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final class ServerAddress {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final HostAndPort hostAndPort;
        private static final ServerAddress INVALID = new ServerAddress(HostAndPort.fromParts((String)"server.invalid", (int)25565));

        public ServerAddress(String host, int port) {
            this(HostAndPort.fromParts((String)host, (int)port));
        }

        private ServerAddress(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public String getAddress() {
            try {
                return IDN.toASCII(this.hostAndPort.getHost());
            }
            catch (IllegalArgumentException var2) {
                return "";
            }
        }

        public int getPort() {
            return this.hostAndPort.getPort();
        }

        public static ServerAddress parse(String address) {
            if (address == null) {
                return INVALID;
            }
            try {
                HostAndPort hostAndPort = HostAndPort.fromString((String)address).withDefaultPort(27752);
                return hostAndPort.getHost().isEmpty() ? INVALID : new ServerAddress(hostAndPort);
            }
            catch (IllegalArgumentException var2) {
                IllegalArgumentException illegalArgumentException = var2;
                LOGGER.info("Failed to parse URL {}", (Object)address, (Object)illegalArgumentException);
                return INVALID;
            }
        }

        public static boolean isValid(String address) {
            try {
                HostAndPort hostAndPort = HostAndPort.fromString((String)address);
                String string = hostAndPort.getHost();
                if (!string.isEmpty()) {
                    IDN.toASCII(string);
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return false;
        }

        static int portOrDefault(String port) {
            try {
                return Integer.parseInt(port.trim());
            }
            catch (Exception var2) {
                return 27752;
            }
        }

        public String toString() {
            return this.hostAndPort.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ServerAddress && this.hostAndPort.equals((Object)((ServerAddress)o).hostAndPort);
        }

        public int hashCode() {
            return this.hostAndPort.hashCode();
        }
    }

    public static class AllowedAddressResolver {
        public static final AllowedAddressResolver DEFAULT = new AllowedAddressResolver(AddressResolver.DEFAULT, RedirectResolver.createSrv());
        private final AddressResolver addressResolver;
        private final RedirectResolver redirectResolver;

        @VisibleForTesting
        AllowedAddressResolver(AddressResolver addressResolver, RedirectResolver redirectResolver) {
            this.addressResolver = addressResolver;
            this.redirectResolver = redirectResolver;
        }

        public Optional<class_6368> resolve(ServerAddress address) {
            Optional<class_6368> optional = this.addressResolver.resolve(address);
            if (optional.isPresent()) {
                Optional<ServerAddress> optional2 = this.redirectResolver.lookupRedirect(address);
                if (optional2.isPresent()) {
                    optional = this.addressResolver.resolve(optional2.get());
                }
                return optional;
            }
            return Optional.empty();
        }
    }

    public static interface RedirectResolver {
        public static final Logger LOGGER = LogUtils.getLogger();
        public static final RedirectResolver INVALID = address -> Optional.empty();

        public Optional<ServerAddress> lookupRedirect(ServerAddress var1);

        public static RedirectResolver createSrv() {
            InitialDirContext dirContext;
            try {
                String string = "com.sun.jndi.dns.DnsContextFactory";
                Class.forName("com.sun.jndi.dns.DnsContextFactory");
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                hashtable.put("java.naming.provider.url", "dns:");
                hashtable.put("com.sun.jndi.dns.timeout.retries", "1");
                dirContext = new InitialDirContext(hashtable);
            }
            catch (Throwable var3) {
                Throwable throwable = var3;
                LOGGER.error("Failed to initialize SRV redirect resolved, some servers might not work", throwable);
                return INVALID;
            }
            return address -> {
                if (address.getPort() == 27752) {
                    try {
                        Attributes attributes = dirContext.getAttributes("_scmc._tcp." + address.getAddress(), new String[]{"SRV"});
                        Attribute attribute = attributes.get("srv");
                        if (attribute != null) {
                            String[] strings = attribute.get().toString().split(" ", 4);
                            return Optional.of(new ServerAddress(strings[3], Networking.portOrDefault(strings[2])));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return Optional.empty();
            };
        }
    }

    public static interface AddressResolver {
        public static final Logger LOGGER = LogUtils.getLogger();
        public static final AddressResolver DEFAULT = address -> {
            try {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                return Optional.of(class_6368.method_36899((InetSocketAddress)new InetSocketAddress(inetAddress, address.getPort())));
            }
            catch (UnknownHostException var2) {
                UnknownHostException unknownHostException = var2;
                LOGGER.debug("Couldn't resolve server {} address", (Object)address.getAddress(), (Object)unknownHostException);
                return Optional.empty();
            }
        };

        public Optional<class_6368> resolve(ServerAddress var1);
    }
}

