package com.skellybuilds.servermodmenu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.skellybuilds.servermodmenu.api.ConfigScreenFactory;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.config.ModMenuConfigManager;
import com.skellybuilds.servermodmenu.db.ModAdapter;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.event.ModMenuEventHandler;
import com.skellybuilds.servermodmenu.gui.EntryButton;
import com.skellybuilds.servermodmenu.util.ModrinthUtil;
import com.skellybuilds.servermodmenu.util.Networking;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1076;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6368;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.client.network.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetSocketAddress;
import java.text.NumberFormat;
import java.util.*;

public class ModMenu implements ClientModInitializer {
	public static final String MOD_ID = "servermodmenu";
	public static final String GITHUB_REF = "SkellyBuilds/ServerModMenu";
	public static final Logger LOGGER = LoggerFactory.getLogger("Server Mod Menu");
	public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
	public static final Gson GSON_MINIFIED = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
	public static final List<String> idsDLD = new ArrayList<>();
	public static final Map<String, EntryButton> buttonEntries = new HashMap<>();
//	public static final Map<String, Networking.SocketStatusLoop> socketLoops = new HashMap<>();
	public static final Map<String, Map<String, SMod>> SMODS = new HashMap<>(); // Server Name - Mod Map
	public static Map<String, SMod> SMODSA = new HashMap<>();
	public static final Map<String, Mod> MODS = new HashMap<>();
	public static final Map<String, Mod> ROOT_MODS = new HashMap<>();
	public static final LinkedListMultimap<Mod, Mod> PARENT_MAP = LinkedListMultimap.create();
	public final static Networking MainNetwork = new Networking();
	private static Map<String, ConfigScreenFactory<?>> configScreenFactories = new HashMap<>();
	private static List<Map<String, ConfigScreenFactory<?>>> delayedScreenFactoryProviders = new ArrayList<>();
	public static boolean isAllDFB = false;
	private static int cachedDisplayedModCount = -1;
	public static boolean runningQuilt = FabricLoader.getInstance().isModLoaded("quilt_loader");
	public static boolean devEnvironment = FabricLoader.getInstance().isDevelopmentEnvironment();
	boolean event = false;
	private static String prevLoc;

	public static class_437 getConfigScreen(String modid, class_437 menuScreen) {
		if (!delayedScreenFactoryProviders.isEmpty()) {
			delayedScreenFactoryProviders.forEach(map -> map.forEach(configScreenFactories::putIfAbsent));
			delayedScreenFactoryProviders.clear();
		}
		if (ModMenuConfig.HIDDEN_CONFIGS.getValue().contains(modid)) {
			return null;
		}
		ConfigScreenFactory<?> factory = configScreenFactories.get(modid);
		if (factory != null) {
			return factory.create(menuScreen);
		}
		return null;
	}

	private static void detectLangEvent(class_641 serverList, class_310 client){
		class_1076 languageManager = client.method_1526();

		// Get the current language definition
		String currentLanguage = languageManager.method_4669();

		if(!Objects.equals(currentLanguage, prevLoc)){
			sendlocaletonetwork(serverList, client);
		} else {
			try {
				Thread.sleep(1250);
			} catch (InterruptedException e) {
				LOGGER.error("Interrupted: {}", e.toString());
			}
		}

	}

	public static void sendlocaletonetwork(class_641 serverList, class_310 client){
		serverList.method_2981();
		for (int i = 0; i < serverList.method_2984(); i++) {
			class_642 serverInfo = serverList.method_2982(i);

			if(serverInfo.field_3761.contains(":")){
				serverInfo.field_3761 = serverInfo.field_3761.substring(0, serverInfo.field_3761.indexOf(":"));
			}

			Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(serverInfo.field_3761);

			Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
			if(optAddress.isPresent()) {
				final InetSocketAddress inetSocketAddress = (InetSocketAddress) optAddress.get();

				String testS = inetSocketAddress.getAddress().getHostAddress();
				// Access the LanguageManager
				class_1076 languageManager = client.method_1526();

				// Get the current language definition
				String currentLanguageC = languageManager.method_4669();

				prevLoc = currentLanguageC;

				MainNetwork.connect(testS, inetSocketAddress.getPort());

				MainNetwork.send(testS, "addploc|"+client.method_1548().method_1676() + "|" +currentLanguageC);
			}
		}
	}

	public static void sendmodstonetwork(class_641 serverList, class_310 client){
		serverList.method_2981();
		for (int i = 0; i < serverList.method_2984(); i++) {
			class_642 serverInfo = serverList.method_2982(i);

			if(serverInfo.field_3761.contains(":")){
				serverInfo.field_3761 = serverInfo.field_3761.substring(0, serverInfo.field_3761.indexOf(":"));
			}

			Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(serverInfo.field_3761);

			Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
			if(optAddress.isPresent()) {
				final InetSocketAddress inetSocketAddress = (InetSocketAddress) optAddress.get();

				List<String> stringArray = new ArrayList<>();
				for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
					stringArray.add(mod.getMetadata().getId());
				}

				String testS = inetSocketAddress.getAddress().getHostAddress();

				String data = "{\"playerN\":" + client.method_1548().method_1676() + ", \"data\":" + stringArray.toString() + "}";
				MainNetwork.connect(testS, inetSocketAddress.getPort());

				MainNetwork.send(testS, "addpmods|" + data);


			} else {
				List<String> stringArray = new ArrayList<>();
				for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
					stringArray.add(mod.getMetadata().getId());
				}

				String data = "{\"playerN\":" + client.method_1548().method_1676() + ", \"data\":" + stringArray.toString() + "}";
				MainNetwork.connect(serverInfo.field_3761, 27752);
				MainNetwork.send(serverInfo.field_3761, "addpmods|" + data);
			}
		}


	}


	public static void ConnectAndDetectPort(String serverIP, Networking network){
			Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(serverIP);

			Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
			if(optAddress.isPresent()) {
				final InetSocketAddress inetSocketAddress = (InetSocketAddress) optAddress.get();
				network.connect(optAddress.get().getAddress().getHostAddress(), inetSocketAddress.getPort());

			} else {
				network.connect(optAddress.get().getAddress().getHostAddress(), 27752);
			}
	}

	public static void LoadServerListConnections(class_641 list, Networking network){
		final SMod[][] ModsA = {{}};
		ModMenu.SMODS.clear();
		list.method_2981();
		for (int i = 0; i < list.method_2984(); i++) {
			class_642 serverInfo = list.method_2982(i);

			Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(serverInfo.field_3761);

			Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
			if (optAddress.isPresent()) {
				final InetSocketAddress inetSocketAddress = (InetSocketAddress) optAddress.get();
				network.connect(optAddress.get().getAddress().getHostAddress(), inetSocketAddress.getPort());

			} else {
				network.connect(optAddress.get().getAddress().getHostAddress(), 27752);
			}

			if(!network.isSocketValid(optAddress.get().getAddress().getHostAddress())) continue;
			try {
				GsonBuilder gsonBuilder = new GsonBuilder();
				gsonBuilder.registerTypeAdapter(SMod.class, new ModAdapter());
				Gson gson = gsonBuilder.create();
				String str = MainNetwork.requestNResponse(optAddress.get().getAddress().getHostAddress(), "getall|" + class_310.method_1551().method_1548().method_1676());
				ModsA[0] = gson.fromJson(str, SMod[].class);
				LOGGER.info(Arrays.toString(ModsA[0]));
				boolean sinit = false;
				if (ModsA[0].length < 1) {
					ModMenu.SMODS.computeIfAbsent(optAddress.get().getAddress().getHostAddress(), k -> new HashMap<>());
				}
				for (SMod smod : ModsA[0]) {
					if (!sinit) {
						ModMenu.SMODS.computeIfAbsent(optAddress.get().getAddress().getHostAddress(), k -> new HashMap<>());
						ModMenu.SMODSA = new HashMap<>();
						sinit = true;
					}

					smod.server = optAddress.get().getAddress().getHostAddress();
					ModMenu.SMODS.get(optAddress.get().getAddress().getHostAddress()).put(smod.getId(), smod);
				}
			} catch (Exception e) {
				continue;
			}


		}
	}

	public static void LoadServer(String ip, Networking network){
	final SMod[][] ModsA = {{}};
		Networking.ServerAddress parsedAd = Networking.ServerAddress.parse(ip);

		Optional<InetSocketAddress> optAddress = Networking.AllowedAddressResolver.DEFAULT.resolve(parsedAd).map(class_6368::method_36902);
		if (optAddress.isPresent()) {
			final InetSocketAddress inetSocketAddress = (InetSocketAddress) optAddress.get();
			network.connect(optAddress.get().getAddress().getHostAddress(), inetSocketAddress.getPort());

		} else {
			network.connect(optAddress.get().getAddress().getHostAddress(), 27752);
		}

		if(network.isSocketValid(optAddress.get().getAddress().getHostAddress())) return;
		try {
			GsonBuilder gsonBuilder = new GsonBuilder();
			gsonBuilder.registerTypeAdapter(SMod.class, new ModAdapter());
			Gson gson = gsonBuilder.create();
			String str = MainNetwork.requestNResponse(optAddress.get().getAddress().getHostAddress(), "getall|" + class_310.method_1551().method_1548().method_1676());
			ModsA[0] = gson.fromJson(str, SMod[].class);
			LOGGER.info(Arrays.toString(ModsA[0]));
			boolean sinit = false;
			if (ModsA[0].length < 1) {
				ModMenu.SMODS.computeIfAbsent(optAddress.get().getAddress().getHostAddress(), k -> new HashMap<>());
			}
			for (SMod smod : ModsA[0]) {
				if (!sinit) {
					ModMenu.SMODS.computeIfAbsent(optAddress.get().getAddress().getHostAddress(), k -> new HashMap<>());
					ModMenu.SMODSA = new HashMap<>();
					sinit = true;
				}

				smod.server = optAddress.get().getAddress().getHostAddress();
				ModMenu.SMODS.get(optAddress.get().getAddress().getHostAddress()).put(smod.getId(), smod);
			}
		} catch (Exception e) {
			return;
		}
	}

	@Override
	public void onInitializeClient() {
		class_310 client = class_310.method_1551();
		class_641 serverList = new class_641(client);

		ClientTickEvents.END_CLIENT_TICK.register(client2 -> {
			new Thread(() -> { if(client2 != null)detectLangEvent(serverList, client2); }).start();
			if(!event) {
				if (client2 != null && client2.method_1526() != null) {
					sendlocaletonetwork(serverList, client2);
					event = true;
				}
			}
		});

		LoadServerListConnections(serverList, MainNetwork);

		ModMenuConfigManager.initializeConfig();
		Set<String> modpackMods = new HashSet<>();

		// uh get server list and see if the server has any stuf
//		FabricLoader.getInstance().getEntrypointContainers("modmenu", ModMenuApi.class).forEach(entrypoint -> {
//			ModMetadata metadata = entrypoint.getProvider().getMetadata();
//			String modId = metadata.getId();
//			try {
//				ModMenuApi api = entrypoint.getEntrypoint();
//				configScreenFactories.put(modId, api.getModConfigScreenFactory());
//				delayedScreenFactoryProviders.add(api.getProvidedConfigScreenFactories());
//				api.attachModpackBadges(modpackMods::add);
//			} catch (Throwable e) {
//				LOGGER.error("Mod {} provides a broken implementation of ModMenuApi", modId, e);
//			}
//		});




		// Fill mods map
//		for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
//			Mod mod;
//
//			if (runningQuilt) {
//				mod = new QuiltMod(modContainer, modpackMods);
//			} else {
		//		mod = new FabricMod(modContainer, modpackMods);
//			}
//
//			MODS.put(mod.getId(), mod);
//		}

		ModrinthUtil.checkForUpdates();

		Map<String, Mod> dummyParents = new HashMap<>();

//		// Initialize parent map
//		for (Mod mod : MODS.values()) {
//			String parentId = mod.getParent();
//			if (parentId != null) {
//				Mod parent = MODS.getOrDefault(parentId, dummyParents.get(parentId));
//				if (parent == null) {
//					if (mod instanceof FabricMod) {
//						parent = new FabricDummyParentMod((FabricMod) mod, parentId);
//						dummyParents.put(parentId, parent);
//					}
//				}
//				PARENT_MAP.put(parent, mod);
//			} else {
//				ROOT_MODS.put(mod.getId(), mod);
//			}
//		}
//		MODS.putAll(dummyParents);

		sendmodstonetwork(serverList, client);
		ModMenuEventHandler.register();
	}

	public static void clearModCountCache() {
		cachedDisplayedModCount = -1;
	}

	public static boolean areModUpdatesAvailable() {
		if (!ModMenuConfig.UPDATE_CHECKER.getValue()) {
			return false;
		}

		for (Mod mod : MODS.values()) {
			if (mod.isHidden()) {
				continue;
			}

			if (!ModMenuConfig.SHOW_LIBRARIES.getValue() && mod.getBadges().contains(Mod.Badge.LIBRARY)) {
				continue;
			}

			if (mod.getModrinthData() != null || mod.getChildHasUpdate()) {
				return true; // At least one currently visible mod has an update
			}
		}

		return false;
	}

	public static String getDisplayedModCount() {
		if (cachedDisplayedModCount == -1) {
			// listen, if you have >= 2^32 mods then that's on you
			cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod ->
					(ModMenuConfig.COUNT_CHILDREN.getValue() || mod.getParent() == null) &&
							(ModMenuConfig.COUNT_LIBRARIES.getValue() || !mod.getBadges().contains(Mod.Badge.LIBRARY)) &&
							(ModMenuConfig.COUNT_HIDDEN_MODS.getValue() || !mod.isHidden())
			).count());
		}
		return NumberFormat.getInstance().format(cachedDisplayedModCount);
	}

	public static class_2561 createModsButtonText(boolean title) {
		var titleStyle = ModMenuConfig.MODS_BUTTON_STYLE.getValue();
		var gameMenuStyle = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
		var isIcon = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON;
		var isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.REPLACE_BUGS;
		class_5250 modsText = class_2561.method_43471("servermodmenu.title");
		if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && !isIcon) {
			String count = ModMenu.getDisplayedModCount();
			if (isShort) {
				modsText.method_10852(class_2561.method_43470(" ")).method_10852(class_2561.method_43469("modmenu.loaded.short", count));
			} else {
				String specificKey = "modmenu.loaded." + count;
				String key = class_1074.method_4663(specificKey) ? specificKey : "modmenu.loaded";
				if (ModMenuConfig.EASTER_EGGS.getValue() && class_1074.method_4663(specificKey + ".secret")) {
					key = specificKey + ".secret";
				}
				modsText.method_10852(class_2561.method_43470(" ")).method_10852(class_2561.method_43469(key, count));
			}
		}
		return modsText;
	}
}
