package com.skellybuilds.servermodmenu.config.option;

import com.skellybuilds.servermodmenu.util.TranslationUtil;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class BooleanConfigOption implements OptionConvertable {
	private final String key, translationKey;
	private final boolean defaultValue;
	private final class_2561 enabledText;
	private final class_2561 disabledText;

	public BooleanConfigOption(String key, boolean defaultValue, String enabledKey, String disabledKey) {
		ConfigOptionStorage.setBoolean(key, defaultValue);
		this.key = key;
		this.translationKey = TranslationUtil.translationKeyOf("option", key);
		this.defaultValue = defaultValue;
		this.enabledText = class_2561.method_43471(translationKey + "." + enabledKey);
		this.disabledText = class_2561.method_43471(translationKey + "." + disabledKey);
	}

	public BooleanConfigOption(String key, boolean defaultValue) {
		this(key, defaultValue, "true", "false");
	}

	public String getKey() {
		return key;
	}

	public boolean getValue() {
		return ConfigOptionStorage.getBoolean(key);
	}

	public void setValue(boolean value) {
		ConfigOptionStorage.setBoolean(key, value);
	}

	public void toggleValue() {
		ConfigOptionStorage.toggleBoolean(key);
	}

	public boolean getDefaultValue() {
		return defaultValue;
	}

	public class_2561 getButtonText() {
		return class_5244.method_32700(class_2561.method_43471(translationKey), getValue() ? enabledText : disabledText);
	}

	@Override
	public class_7172<Boolean> asOption() {
		if (enabledText != null && disabledText != null) {
			return new class_7172<>(translationKey, class_7172.method_42399(),
					(text, value) -> value ? enabledText : disabledText, class_7172.field_38278, getValue(),
					newValue -> ConfigOptionStorage.setBoolean(key, newValue));
		}
		return class_7172.method_41751(translationKey, getValue(), (value) -> ConfigOptionStorage.setBoolean(key, value));
	}
}
