package com.skellybuilds.servermodmenu.config.option;

import com.skellybuilds.servermodmenu.util.TranslationUtil;

import java.util.Set;
import net.minecraft.class_2561;

public class StringSetConfigOption {
	private final String key, translationKey;
	private final Set<String> defaultValue;

	public StringSetConfigOption(String key, Set<String> defaultValue) {
		super();
		ConfigOptionStorage.setStringSet(key, defaultValue);
		this.key = key;
		this.translationKey = TranslationUtil.translationKeyOf("option", key);
		this.defaultValue = defaultValue;
	}

	public String getKey() {
		return key;
	}

	public Set<String> getValue() {
		return ConfigOptionStorage.getStringSet(key);
	}

	public void setValue(Set<String> value) {
		ConfigOptionStorage.setStringSet(key, value);
	}

	public class_2561 getMessage() {
		return class_2561.method_43471(translationKey);
	}

	public Set<String> getDefaultValue() {
		return defaultValue;
	}
}
