package com.skellybuilds.servermodmenu.event;

import com.skellybuilds.servermodmenu.api.ModMenuApi;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.gui.widget.ModMenuButtonWidget;
//import com.skellybuilds.servermodmenu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.skellybuilds.servermodmenu.ModMenu;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.util.ModrinthUtil;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_7417;
import net.minecraft.class_8021;
import java.util.List;

public class ModMenuEventHandler {
	public static final class_2960 FABRIC_ICON_BUTTON_LOCATION = class_2960.method_60655(ModMenu.MOD_ID, "textures/gui/mods_button.png");
	private static class_304 MENU_KEY_BIND;

	public static void register() {
		MENU_KEY_BIND = KeyBindingHelper.registerKeyBinding(new class_304(
				"key.servermodmenu.open_menu",
				class_3675.class_307.field_1668,
				class_3675.field_16237.method_1444(),
				"key.categories.misc"
		));
		ClientTickEvents.END_CLIENT_TICK.register(ModMenuEventHandler::onClientEndTick);

		ScreenEvents.AFTER_INIT.register(ModMenuEventHandler::afterScreenInit);
	}

	public static void afterScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
		if (screen instanceof class_442) {
			afterTitleScreenInit(screen);
		}
	}

	private static void afterTitleScreenInit(class_437 screen) {
		final List<class_339> buttons = Screens.getButtons(screen);
		if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue()) {
			int modsButtonIndex = -1;
			final int spacing = 24;
			int buttonsY = screen.field_22790 / 4 + 48;
			for (int i = 0; i < buttons.size(); i++) {
				class_339 widget = buttons.get(i);
				if (widget instanceof class_4185 button) {
					if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
						if (button.field_22764) {
							shiftButtons(button, modsButtonIndex == -1, spacing);
							if (modsButtonIndex == -1) {
								buttonsY = button.method_46427();
							}
						}
					}
					if (buttonHasText(button, "menu.online")) {
						if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.REPLACE_REALMS) {
							buttons.set(i, new ModMenuButtonWidget(button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), ModMenuApi.createModsButtonText(), screen));
						} else {
							if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
								button.method_25358(98);
							}
							modsButtonIndex = i + 1;
							if (button.field_22764) {
								buttonsY = button.method_46427();
							}
						}
					}
				}

			}
			if (modsButtonIndex != -1) {
				if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
					buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 - 100, buttonsY + spacing, 200, 20, ModMenuApi.createModsButtonText(), screen));
				} else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
					buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 + 2, buttonsY, 98, 20, ModMenuApi.createModsButtonText(), screen));
				} //else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
//					buttons.add(modsButtonIndex, new UpdateCheckerTexturedButtonWidget(screen.width / 2 + 104, buttonsY, 20, 20, 0, 0, 20, FABRIC_ICON_BUTTON_LOCATION, 32, 64, button -> MinecraftClient.getInstance().setScreen(new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
//				}
			}
		}
		ModrinthUtil.triggerV2DeprecatedToast();
	}

	private static void onClientEndTick(class_310 client) {
		while (MENU_KEY_BIND.method_1436()) {
			client.method_1507(new ModsScreen(client.field_1755));
		}
	}

	public static boolean buttonHasText(class_8021 widget, String translationKey) {
		if (widget instanceof class_4185 button) {
			class_2561 text = button.method_25369();
			class_7417 textContent = text.method_10851();
			return textContent instanceof class_2588 && ((class_2588) textContent).method_11022().equals(translationKey);
		}
		return false;
	}

	public static void shiftButtons(class_8021 widget, boolean shiftUp, int spacing) {
		if (shiftUp) {
			widget.method_46419(widget.method_46427() - spacing / 2);
		} else if (!(widget instanceof class_339 button && button.method_25369().equals(class_2561.method_43471("title.credits")))) {
			widget.method_46419(widget.method_46427() + spacing / 2);
		}
	}
}
