package com.skellybuilds.servermodmenu.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;

public class EntryButton {
	private final class_2960 Texture;
	private final Consumer<EntryButton> callback;
	public int ButtonX = 0;
	public int ButtonY = 0;
	protected int ButtonSX = 20;
	protected int ButtonSY = 20;
	public boolean active = true;
	public boolean visible = true;
	private boolean pauseRender = false;
	private final Logger LOGGER = LoggerFactory.getLogger("Server Mod Menu");
	public class_1144 SOUNDMANAGER = class_310.method_1551().method_1483();;
	public EntryButton(class_2960 text, Consumer<EntryButton> cb){
		this.Texture = text;
		this.callback = cb;
	}

	public EntryButton(class_2960 text, Consumer<EntryButton> cb, int X, int Y, int XS, int XY){
		this.Texture = text;
		this.callback = cb;
		this.ButtonX = X;
		this.ButtonY = Y;
		this.ButtonSX = XS;
		this.ButtonSY = XY;
	}

	public void render(class_332 dc, int mouseX, int mouseY){
		if (pauseRender || !visible) {
			return;
		}

		if (active) {
			if (!hoverHandler(mouseX, mouseY)) {
				dc.method_25290(class_10799.field_56883,
					Texture,
					ButtonX, ButtonY,
					0, 0,
					ButtonSX, ButtonSY,
					32, 64
				);
			} else {
				dc.method_25290(
					class_10799.field_56883,
					Texture,
					ButtonX, ButtonY,
					0, 21,
					ButtonSX, ButtonSY,
					32, 64
				);
			}
		} else {
			dc.method_25290(
				class_10799.field_56883,
				Texture,
				ButtonX, ButtonY,
				0, 42,
				ButtonSX, ButtonSY,
				32, 64
			);
		}


	}

	private boolean hoverHandler(int mouseX, int mouseY){
		return mouseX >= ButtonX && mouseX < ButtonX + ButtonSX
			&& mouseY >= ButtonY && mouseY < ButtonY + ButtonSY;
	}

	public void handleOnClickEvent(int mouseX, int mouseY){
		if(hoverHandler(mouseX, mouseY) && active) {
			SOUNDMANAGER.method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));

			callback.accept(this);
		}
	}

	public void setActive(boolean a){
		this.active = a;
	}
	public void setVisible(boolean v){
		this.visible = v;
	}
	public void setX(int X){
		this.ButtonX =X;
	}
	public void setY(int Y){
		this.ButtonY = Y;
	}
	public void setSX(int X){
		this.ButtonSX =X;
	}
	public void setSY(int Y){
		this.ButtonSY = Y;
	}
}
