package com.skellybuilds.servermodmenu.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.db.SMod;
import com.skellybuilds.servermodmenu.gui.widget.entries.ChildEntry;
import com.skellybuilds.servermodmenu.gui.widget.entries.IndependentEntry;
import com.skellybuilds.servermodmenu.gui.widget.entries.ModListEntry;
import com.skellybuilds.servermodmenu.gui.widget.entries.ParentEntry;
import com.skellybuilds.servermodmenu.ModMenu;
import com.skellybuilds.servermodmenu.gui.ModsScreen;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import com.skellybuilds.servermodmenu.util.mod.fabric.FabricIconHandler;
import com.skellybuilds.servermodmenu.util.mod.ModSearch;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_8012;

public class ModListWidget extends class_4280<ModListEntry> implements AutoCloseable {
	public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
	private final ModsScreen parent;
	public List<Mod> mods = null;
	public List<SMod> smods = null;
	public boolean useSMod = false;
	private final Set<Mod> addedMods = new HashSet<>();
	// <Server Name, ServerMod> - for the highlighted text string to top
	private final Map<String, SMod> SaddedMods = new HashMap<>();
	private String selectedModId = null;
	private boolean scrolling;
	private final FabricIconHandler iconHandler = new FabricIconHandler();
	private boolean isInit = false;
	private double scrollAm;
	private int origT;

	public ModListWidget(class_310 client, int width, int height, int y, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
		super(client, width, height, y, entryHeight);
		this.parent = parent;
		if(list != null) {
			if (list.useSMod) {
			this.useSMod = true;
			this.smods = list.smods;
			}
				else this.mods = list.mods;


		}
		this.filter(searchTerm, false);
//		setScrollAmount(parent.getScrollPercent() * Math.max(0, this.getMaxPosition() - (this.getBottom() - this.getTop() - 4)));
	}


	@Override
	public boolean method_25370() {
		return parent.method_25399() == this;
	}

	public void select(String id, String server) {
		method_25396().forEach((entryM) -> {
			if(Objects.equals(entryM.smod.getId(), id)){
				if(entryM.useSMOD()){
					if(Objects.equals(entryM.serverName, server)){
						this.setSelected(entryM);
						if(entryM.renderSvnNO) return;
						this.field_22740.method_44713().method_70816(class_2561.method_43469("narrator.select", entryM.smod.meta.name));
					}
				} else {
					if(Objects.equals(entryM.serverName, server)){
					this.setSelected(entryM);
					this.field_22740.method_44713().method_70816(class_2561.method_43469("narrator.select", entryM.mod.getTranslatedName()));
				}

				}
			}
		});

	}

	@Override
	public void setSelected(ModListEntry entry) {
		if(entry == null)return;
		super.method_25313(entry);
		if(entry.useSMOD()){
			selectedModId = entry.getSMod().getId();
			parent.updateSelectedEntry(method_25334());
		} else {
			selectedModId = entry.getMod().getId();
			parent.updateSelectedEntry(method_25334());
		}
	}

	@Override
	protected boolean method_25332(int index) {
		ModListEntry selected = method_25334();
		//assert selected != null; why the fuck am i asserting?
		if(selected != null) {
			if (selected.useSMOD()) {
				if(!Objects.equals(selected.getSMod().server, method_25326(index).getSMod().server))return false;
				return selected.getSMod().getId().equals(method_25326(index).getSMod().getId());
			} else {
				if(!Objects.equals(selected.serverName, method_25326(index).serverName)) return false;
				return selected.getMod().getId().equals(method_25326(index).getMod().getId());
			}
		} else return false;

//		return false;
		}

	@Override
	public int addEntry(ModListEntry entry) {
		if(entry.useSMOD()){
			if (SaddedMods.get(entry.serverName) == entry.smod) {
				return 0;
			}
			SaddedMods.put(entry.serverName, entry.smod);
			int i = super.method_25321(entry);
			if (entry.getSMod().getId().equals(selectedModId)) {
				setSelected(entry);
			}
			return i;
		} else {
			if (addedMods.contains(entry.mod)) {
				return 0;
			}
			addedMods.add(entry.mod);
			int i = super.method_25321(entry);
			if (entry.getMod().getId().equals(selectedModId)) {
				setSelected(entry);
			}
			return i;
		}
	}

	@Override
	protected boolean removeEntry(ModListEntry entry) {
		if(entry.useSMOD()){
			SaddedMods.remove(entry.serverName, entry.smod);
		} else {
			addedMods.remove(entry.mod);
		}
		return super.method_25330(entry);
	}

	protected void removeAllEntries(){
		method_25396().forEach(super::method_25330);
	}

	@Override
	protected ModListEntry method_25338(int index) {
		if(method_25326(index).useSMOD()) addedMods.remove(method_25326(index).smod);
		else addedMods.remove(method_25326(index).mod);

		return super.method_25338(index);
	}

	public void reloadFilters() {
		isInit = false;
		filter(parent.getSearchInput(), true, false);
	}


	public void filter(String searchTerm, boolean refresh) {
		isInit = false;
		filter(searchTerm, refresh, true);
	}

	private boolean hasVisibleChildMods(Mod parent) {
		List<Mod> children = ModMenu.PARENT_MAP.get(parent);
		boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();

		return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains(Mod.Badge.LIBRARY));
	}

	private void filter(String searchTerm, boolean refresh, boolean search) {
		this.method_25339();
		SaddedMods.clear();
		addedMods.clear();
		this.removeAllEntries();

		if (useSMod) {


			Map<String, SMod> modsMA;

			if(ModMenu.SMODSA.isEmpty()) {
				modsMA = new HashMap<>();

				ModMenu.SMODS.forEach((svn, mod) -> {
					for (Map.Entry<String, SMod> entry : mod.entrySet()) {
						String id = entry.getKey();
						SMod mods2 = entry.getValue();
						modsMA.put(id, mods2);
					}
				});
			} else modsMA = ModMenu.SMODSA;

			AtomicBoolean addMoreY = new AtomicBoolean(false);
			ModMenu.SMODS.forEach((serverName, modsM) -> {
				Collection<SMod> mods = new HashSet<>(modsM.values());
				this.smods = null;

				if (this.smods == null || refresh) {
					this.smods = new ArrayList<>();
					this.smods.addAll(mods);
					this.smods.sort(ModMenuConfig.SSORTING.getValue().getComparator());
				}

				List<SMod> matched = ModSearch.searchS(parent, searchTerm, this.smods);

				AtomicBoolean isHidden = new AtomicBoolean(false);
				boolean isF = true;
				for (SMod mod : matched) {



						ModMenuConfig.HIDDEN_SERVERS.getValue().forEach((name) -> {
							if(Objects.equals(name, serverName)){
								if(!ModMenuConfig.SHOWHIDDENSERVERS.getValue()){
									isHidden.set(true);
								}
							}
						});


				if(matched.isEmpty()){
					if(isHidden.get() && ModMenuConfig.SHOWHIDDENSERVERS.getValue() || !isHidden.get()) {
						this.addEntry(new IndependentEntry(new SMod("d", "d", null, false, false), this, serverName, true, true, addMoreY.get()));
					}
				}




					if(isHidden.get() && ModMenuConfig.SHOWHIDDENSERVERS.getValue() || !isHidden.get()) {
						this.addEntry(new IndependentEntry(mod, this, serverName, isF, false, addMoreY.get()));

					}

					if(isHidden.get() && ModMenuConfig.SHOWHIDDENSERVERS.getValue() || !isHidden.get()){
						isF = false;
					}
				}

				addMoreY.set(true);



				if(method_25396().size() > 1) {
					setSelected(method_25326(0));
				} else {
					setSelected(null);
				}


			});

//			if(children().size() > 2){
//				if(addMoreY.get()){
//					int wa2 = children().stream().filter((ra) -> ra.isFirst).toList().size()-1;
//
//					this.top = this.top - 6 * wa2;
//				}
//			}

//			if (getScrollAmount() > Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4))) {
//				setScrollAmount(Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4)));
//			}
			parent.calcServersSize();

			isInit = true;

		} else {
			Collection<Mod> mods = ModMenu.MODS.values().stream().filter(mod -> {
				if (ModMenuConfig.CONFIG_MODE.getValue()) {
					Map<String, Boolean> modHasConfigScreen = parent.getModHasConfigScreen();
					var hasConfig = modHasConfigScreen.get(mod.getId());
					if (!hasConfig) {
						return false;
					}
				}

				return !mod.isHidden();
			}).collect(Collectors.toSet());

			if (DEBUG) {
				mods = new ArrayList<>(mods);
//			mods.addAll(TestModContainer.getTestModContainers());
			}

			if (this.mods == null || refresh) {
				this.mods = new ArrayList<>();
				this.mods.addAll(mods);
				this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
			}

			List<Mod> matched = ModSearch.search(parent, searchTerm, this.mods);

			for (Mod mod : matched) {
				String modId = mod.getId();

				//Hide parent lib mods when the config is set to hide
				if (mod.getBadges().contains(Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue()) {
					continue;
				}

				if (!ModMenu.PARENT_MAP.values().contains(mod)) {
					if (ModMenu.PARENT_MAP.keySet().contains(mod) && hasVisibleChildMods(mod)) {
						//Add parent mods when not searching
						List<Mod> children = ModMenu.PARENT_MAP.get(mod);
						children.sort(ModMenuConfig.SORTING.getValue().getComparator());
						ParentEntry parent = new ParentEntry(mod, children, this);
						this.addEntry(parent);
						//Add children if they are meant to be shown
						if (this.parent.showModChildren.contains(modId)) {
							List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
							for (Mod child : validChildren) {
								this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
							}
						}
					} else {
						//A mod with no children
						this.addEntry(new IndependentEntry(mod, this));
					}
				}
			}

			if (parent.getSelectedEntry() != null && !method_25396().isEmpty() || this.method_25334() != null && method_25334().getMod() != parent.getSelectedEntry().getMod()) {
				for (ModListEntry entry : method_25396()) {
					if (entry.getMod().equals(parent.getSelectedEntry().getMod())) {
						setSelected(entry);
					}
				}
			} else {
				if (method_25334() == null && !method_25396().isEmpty() && method_25326(0) != null) {
					setSelected(method_25326(0));
				}
			}

//			if (getScrollAmount() > Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4))) {
//				setScrollAmount(Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4)));
//			}
		}
	}


	@Override
	protected void method_25311(class_332 DrawContext, int mouseX, int mouseY, float delta) {
		int entryCount = this.method_25340();


if(isInit) {
	for (int index = 0; index < entryCount; ++index) {

		if(this.method_25396().isEmpty() || index > this.method_25396().size()){
			return; // isInit and entry count can be unreliable when reloading servers.
			// This will reduce the likely chances of crashing on reload render
		}

		ModListEntry entry = this.method_25326(index);


		int entryTop = this.method_25337(index) + 12;
		//int entryBottom = entry.isFirst ? this.getRowTop(index) + this.itemHeight + 8 : this.getRowTop(index) + this.itemHeight ;

		//if(entry.moreY) entryTop = entryTop + 17;


		int entryHeight = this.field_22741 - 4;

		int rowWidth = this.method_25322();
		int entryLeft = this.method_25342();
		if(entry.moreY){
		//	rowWidth = rowWidth + 8;
		}
		if (this.method_25332(index) && !entry.renderSvnNO) {
			int entryContentLeft = entryLeft + entry.getXOffset() - 2;
			int entryContentWidth = rowWidth - entry.getXOffset() + 4;
			this.drawSelectionHighlight(
				DrawContext,
				entryContentLeft,
				entryTop,
				entryContentWidth,
				entryHeight,
				this.method_25370() ? class_8012.field_42973 : class_8012.field_44941, class_8012.field_42974
			);
		}

		entryLeft = this.method_25342();
		entry.method_25343(DrawContext, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals(this.getEntryAtPos(mouseX, mouseY), entry), delta);

	}
}
	}


	public void ensureVisible(ModListEntry entry) {
		super.method_25328(entry);
	}

//	@Override
//	protected void updateScrollingState(double double_1, double double_2, int int_1) {
//		super.updateScrollingState(double_1, double_2, int_1);
//		this.scrolling = int_1 == 0 && double_1 >= (double) this.getScrollbarPositionX() && double_1 < (double) (this.getScrollbarPositionX() + 6);
//	}

//	@Override
//	public boolean mouseClicked(double double_1, double double_2, int int_1) {
//		this.updateScrollingState(double_1, double_2, int_1);
//		if (!this.isMouseOver(double_1, double_2)) {
//			return false;
//		} else {
//			ModListEntry entry = this.getEntryAtPos(double_1, double_2);
//			if (entry != null) {
//				if (entry.mouseClicked(double_1, double_2, int_1)) {
//					this.setFocused(entry);
//					this.setDragging(true);
//					return true;
//				}
//			} else if (int_1 == 0) {
//				this.clickedHeader((int) (double_1 - (double) (this.left + this.width / 2 - this.getRowWidth() / 2)), (int) (double_2 - (double) this.top) + (int) this.getScrollAmount() - 4);
//				return true;
//			}
//
//			return this.scrolling;
//		}
//	}

	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (keyCode == GLFW.GLFW_KEY_UP || keyCode == GLFW.GLFW_KEY_DOWN) {
			return super.method_25404(keyCode, scanCode, modifiers);
		}
		if (method_25334() != null) {
			return method_25334().method_25404(keyCode, scanCode, modifiers);
		}
		return false;
	}

	public final ModListEntry getEntryAtPos(double x, double y) {
		int int_5 = class_3532.method_15357(y - (double) this.method_46427()) - this.field_22748 + (int) this.method_44387() - 4;
		int index = int_5 / this.field_22741;
		return x < (double) this.method_65507() && x >= (double) method_25342() && x <= (double) (method_25342() + method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? this.method_25396().get(index) : null;
	}

//	@Override
//	protected int getScrollbarPositionX() {
//		return this.width - 6;
//	}

	@Override
	public int method_25322() {
		return this.field_22758 - (Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)) > 0 ? 18 : 12);
	}

	@Override
	public int method_25342() {
		return method_46426() + 6;
	}

	public int method_25368() {
		return field_22758;
	}

//	public int getTop() {
//		return this.getTop();
//	}

	public ModsScreen getParent() {
		return parent;
	}

//	@Override
//	protected int getMaxPosition() {
//		return super.getMaxPosition() + 4;
//	}

	public int getDisplayedCountFor(Set<String> set) {
		int count = 0;
		for (ModListEntry c : method_25396()) {
			if(c.useSMOD()){
				if (set.contains(c.getSMod().getId())) {
					count++;
				}
			} else {
			 	if (set.contains(c.getMod().getId())) {
					count++;
				}
			}
		}
		return count;
	}

	protected void drawSelectionHighlight(class_332 context, int x, int y, int width, int height, int borderColor, int fillColor) {
		context.method_25294(x, y - 2, x + width, y + height + 2, borderColor);
		context.method_25294(x + 1, y - 1, x + width - 1, y + height + 1, fillColor);
	}

	@Override
	public void close() {
		iconHandler.close();
	}

	public FabricIconHandler getFabricIconHandler() {
		return iconHandler;
	}
}
