/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.config.option;

import com.skellybuilds.servermodmenu.config.option.ConfigOptionStorage;
import com.skellybuilds.servermodmenu.config.option.OptionConvertable;
import com.skellybuilds.servermodmenu.util.TranslationUtil;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class BooleanConfigOption
implements OptionConvertable {
    private final String key;
    private final String translationKey;
    private final boolean defaultValue;
    private final class_2561 enabledText;
    private final class_2561 disabledText;

    public BooleanConfigOption(String key, boolean defaultValue, String enabledKey, String disabledKey) {
        ConfigOptionStorage.setBoolean(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.defaultValue = defaultValue;
        this.enabledText = class_2561.method_43471((String)(this.translationKey + "." + enabledKey));
        this.disabledText = class_2561.method_43471((String)(this.translationKey + "." + disabledKey));
    }

    public BooleanConfigOption(String key, boolean defaultValue) {
        this(key, defaultValue, "true", "false");
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigOptionStorage.getBoolean(this.key);
    }

    public void setValue(boolean value) {
        ConfigOptionStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigOptionStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public class_2561 getButtonText() {
        return class_5244.method_32700((class_2561)class_2561.method_43471((String)this.translationKey), (class_2561)(this.getValue() ? this.enabledText : this.disabledText));
    }

    public class_7172<Boolean> asOption() {
        if (this.enabledText != null && this.disabledText != null) {
            return new class_7172(this.translationKey, class_7172.method_42399(), (text, value) -> value != false ? this.enabledText : this.disabledText, (class_7172.class_7178)class_7172.field_38278, (Object)this.getValue(), newValue -> ConfigOptionStorage.setBoolean(this.key, newValue));
        }
        return class_7172.method_41751((String)this.translationKey, (boolean)this.getValue(), value -> ConfigOptionStorage.setBoolean(this.key, value));
    }
}

