/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.util.mod;

import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.util.mod.ModrinthData;
import com.skellybuilds.servermodmenu.util.mod.fabric.FabricIconHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1043;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Mod {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    default public String getTranslatedName() {
        String translationKey = "modmenu.nameTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_NAMES.getValue()) && class_1074.method_4663((String)translationKey)) {
            return class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        }
        return this.getName();
    }

    @NotNull
    public class_1043 getIcon(FabricIconHandler var1, int var2);

    @NotNull
    default public String getSummary() {
        return this.getTranslatedSummary();
    }

    @NotNull
    default public String getTranslatedSummary() {
        String translationKey = "modmenu.summaryTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_DESCRIPTIONS.getValue()) && class_1074.method_4663((String)translationKey)) {
            return class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        }
        return this.getTranslatedDescription();
    }

    @NotNull
    public String getDescription();

    @NotNull
    default public String getTranslatedDescription() {
        String translatableDescriptionKey = "modmenu.descriptionTranslation." + this.getId();
        if ((this.getId().equals("minecraft") || this.getId().equals("java") || ModMenuConfig.TRANSLATE_DESCRIPTIONS.getValue()) && class_1074.method_4663((String)translatableDescriptionKey)) {
            return class_1074.method_4662((String)translatableDescriptionKey, (Object[])new Object[0]);
        }
        return this.getDescription();
    }

    @NotNull
    public String getVersion();

    @NotNull
    public String getPrefixedVersion();

    @NotNull
    public List<String> getAuthors();

    @NotNull
    public List<String> getContributors();

    @NotNull
    public List<String> getCredits();

    @NotNull
    public Set<Badge> getBadges();

    @Nullable
    public String getWebsite();

    @Nullable
    public String getIssueTracker();

    @Nullable
    public String getSource();

    @Nullable
    public String getParent();

    @NotNull
    public Set<String> getLicense();

    @NotNull
    public Map<String, String> getLinks();

    public boolean isReal();

    @Nullable
    public ModrinthData getModrinthData();

    public boolean allowsUpdateChecks();

    @Nullable
    default public String getSha512Hash() throws IOException {
        return null;
    }

    public void setModrinthData(ModrinthData var1);

    public void setChildHasUpdate();

    public boolean getChildHasUpdate();

    public boolean isHidden();

    public static enum Badge {
        LIBRARY("modmenu.badge.library", -15698860, -16172759, "library"),
        CLIENT("modmenu.badge.clientsideOnly", -13939844, -15848875, null),
        DEPRECATED("modmenu.badge.deprecated", -8121306, -11334633, "deprecated"),
        PATCHWORK_FORGE("modmenu.badge.forge", -14734014, -15722719, null),
        MODPACK("modmenu.badge.modpack", -8770692, -11465388, null),
        MINECRAFT("modmenu.badge.minecraft", -9474966, -13553617, null);

        private final class_2561 text;
        private final int outlineColor;
        private final int fillColor;
        private final String key;
        private static final Map<String, Badge> KEY_MAP;

        private Badge(String translationKey, int outlineColor, int fillColor, String key) {
            this.text = class_2561.method_43471((String)translationKey);
            this.outlineColor = outlineColor;
            this.fillColor = fillColor;
            this.key = key;
        }

        public class_2561 getText() {
            return this.text;
        }

        public int getOutlineColor() {
            return this.outlineColor;
        }

        public int getFillColor() {
            return this.fillColor;
        }

        public static Set<Badge> convert(Set<String> badgeKeys) {
            return badgeKeys.stream().map(KEY_MAP::get).collect(Collectors.toSet());
        }

        static {
            KEY_MAP = new HashMap<String, Badge>();
            Arrays.stream(Badge.values()).forEach(badge -> KEY_MAP.put(badge.key, (Badge)((Object)badge)));
        }
    }
}

