/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.util.mod.fabric;

import com.skellybuilds.servermodmenu.ModMenu;
import com.skellybuilds.servermodmenu.config.ModMenuConfig;
import com.skellybuilds.servermodmenu.util.mod.Mod;
import com.skellybuilds.servermodmenu.util.mod.ModrinthData;
import com.skellybuilds.servermodmenu.util.mod.fabric.FabricIconHandler;
import com.skellybuilds.servermodmenu.util.mod.fabric.FabricMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1043;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricDummyParentMod
implements Mod {
    private final String id;
    private final FabricMod host;
    private boolean childHasUpdate;

    public FabricDummyParentMod(FabricMod host, String id) {
        this.host = host;
        this.id = id;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        FabricMod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        if (parentData != null) {
            return parentData.getName().orElse("");
        }
        if (this.id.equals("fabric-api")) {
            return "Fabric API";
        }
        return this.id;
    }

    @Override
    @NotNull
    public class_1043 getIcon(FabricIconHandler iconHandler, int i) {
        String iconSourceId = this.host.getId();
        FabricMod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        String iconPath = null;
        if (parentData != null) {
            iconPath = parentData.getIcon().orElse(null);
        }
        if ("inherit".equals(iconPath)) {
            return this.host.getIcon(iconHandler, i);
        }
        if (iconPath == null) {
            iconSourceId = "servermodmenu";
            iconPath = this.id.equals("fabric-api") ? "assets/servermodmenu/fabric.png" : "assets/servermodmenu/unknown_parent.png";
        }
        String finalIconSourceId = iconSourceId;
        ModContainer iconSource = (ModContainer)FabricLoader.getInstance().getModContainer(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id " + finalIconSourceId));
        return Objects.requireNonNull(iconHandler.createIcon(iconSource, iconPath), "Mod icon for " + this.getId() + " is null somehow (should be filled with default in this case)");
    }

    @Override
    @NotNull
    public String getDescription() {
        FabricMod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        if (parentData != null) {
            return parentData.getDescription().orElse("");
        }
        return "";
    }

    @Override
    @NotNull
    public String getVersion() {
        return "";
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        return "";
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        return new ArrayList<String>();
    }

    @Override
    @NotNull
    public List<String> getContributors() {
        return new ArrayList<String>();
    }

    @Override
    @NotNull
    public List<String> getCredits() {
        return new ArrayList<String>();
    }

    @Override
    @NotNull
    public Set<Mod.Badge> getBadges() {
        FabricMod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        if (parentData != null) {
            return parentData.getBadges();
        }
        HashSet<Mod.Badge> badges = new HashSet<Mod.Badge>();
        if (this.id.equals("fabric-api")) {
            badges.add(Mod.Badge.LIBRARY);
        }
        boolean modpackChildren = true;
        for (Mod mod : ModMenu.PARENT_MAP.get((Object)this)) {
            if (mod.getBadges().contains((Object)Mod.Badge.MODPACK)) continue;
            modpackChildren = false;
        }
        if (modpackChildren) {
            badges.add(Mod.Badge.MODPACK);
        }
        return badges;
    }

    @Override
    @Nullable
    public String getWebsite() {
        return null;
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return null;
    }

    @Override
    @Nullable
    public String getSource() {
        return null;
    }

    @Override
    @Nullable
    public String getParent() {
        return null;
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        return new HashSet<String>();
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return new HashMap<String, String>();
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    @Nullable
    public ModrinthData getModrinthData() {
        return null;
    }

    @Override
    public void setModrinthData(ModrinthData modrinthData) {
    }

    @Override
    public boolean allowsUpdateChecks() {
        return false;
    }

    @Override
    public boolean getChildHasUpdate() {
        return this.childHasUpdate;
    }

    @Override
    public void setChildHasUpdate() {
        this.childHasUpdate = true;
    }

    @Override
    public boolean isHidden() {
        return ModMenuConfig.HIDDEN_MODS.getValue().contains(this.getId());
    }
}

