/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.servermodmenu.util.mod.fabric;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricIconHandler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | FabricIconHandler");
    private final Map<Path, class_1043> modIconCache = new HashMap<Path, class_1043>();

    public class_1043 createIcon(ModContainer iconSource, String iconPath) {
        class_1043 class_10432;
        block13: {
            Path path = iconSource.getPath(iconPath);
            class_1043 cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                class_1011 image = class_1011.method_4309((InputStream)Objects.requireNonNull(inputStream));
                Validate.validState((image.method_4323() == image.method_4307() ? 1 : 0) != 0, (String)"Must be square icon", (Object[])new Object[0]);
                class_1043 tex = new class_1043(() -> class_2960.method_60655((String)"servermodmenu", (String)path.toString()).toString(), image);
                this.cacheModIcon(path, tex);
                class_10432 = tex;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("Must be square icon")) {
                        LOGGER.error("Mod icon must be a square for icon source {}: {}", new Object[]{iconSource.getMetadata().getId(), iconPath, e});
                    }
                    return null;
                }
                catch (Throwable t) {
                    if (!iconPath.equals("assets/" + iconSource.getMetadata().getId() + "/icon.png")) {
                        LOGGER.error("Invalid mod icon for icon source {}: {}", new Object[]{iconSource.getMetadata().getId(), iconPath, t});
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return class_10432;
    }

    @Override
    public void close() {
        for (class_1043 tex : this.modIconCache.values()) {
            tex.close();
        }
    }

    class_1043 getCachedModIcon(Path path) {
        return this.modIconCache.get(path);
    }

    void cacheModIcon(Path path, class_1043 tex) {
        this.modIconCache.put(path, tex);
    }
}

