/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.api.impl;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.krripe.shadowchat.api.ChatChannel;
import org.krripe.shadowchat.api.ChatPreEvent;
import org.krripe.shadowchat.api.ShadowChatAPI;
import org.krripe.shadowchat.api.ShadowChatListener;
import org.krripe.shadowchat.manager.BadWordManager;
import org.krripe.shadowchat.manager.ChatFormatManager;
import org.krripe.shadowchat.manager.LogManager;
import org.krripe.shadowchat.manager.NameTagManager;
import org.krripe.shadowchat.manager.NicknameManager;
import org.krripe.shadowchat.manager.SpamManager;
import org.krripe.shadowchat.manager.TabListManager;
import org.krripe.shadowchat.manager.WeightManager;
import org.krripe.shadowchat.utils.CustomColorParser;
import org.krripe.shadowchat.utils.FormatPermissionFilter;
import org.krripe.shadowchat.utils.PermissionsSystem;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J!\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\"\u0010#J!\u0010%\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b%\u0010#J\u0017\u0010&\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b(\u0010\u001eJ\u0017\u0010*\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010,\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b,\u0010#J)\u0010.\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b.\u0010/J!\u00100\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b0\u00101J'\u00103\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u0002052\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u0010:\u001a\u00020\u001c2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010<\u001a\u00020\u001c2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b<\u0010;J\u0017\u0010>\u001a\u00020=2\u0006\u0010-\u001a\u00020=H\u0016\u00a2\u0006\u0004\b>\u0010?J\u001f\u0010B\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bB\u0010#J-\u0010F\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u000f2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000f0C2\u0006\u0010E\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bF\u0010GJ'\u0010H\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bH\u0010IJ\u001f\u0010J\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bJ\u0010#J\u001f\u0010K\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bK\u0010#J\u001f\u0010L\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bL\u0010#J\u0017\u0010O\u001a\u00020\u001c2\u0006\u0010N\u001a\u00020MH\u0016\u00a2\u0006\u0004\bO\u0010PJ\u0017\u0010R\u001a\u00020\u001c2\u0006\u0010Q\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bR\u0010SJ'\u0010T\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bT\u0010UR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010V\u001a\u0004\bW\u0010XR\u001a\u0010Z\u001a\b\u0012\u0004\u0012\u0002080Y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bZ\u0010[R \u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020M0\\8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010^\u00a8\u0006_"}, d2={"Lorg/krripe/shadowchat/api/impl/DefaultShadowChatAPI;", "Lorg/krripe/shadowchat/api/ShadowChatAPI;", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lnet/minecraft/server/MinecraftServer;)V", "", "raw", "Lnet/minecraft/class_2561;", "parseColors", "(Ljava/lang/String;)Lnet/minecraft/class_2561;", "Lnet/minecraft/class_2168;", "source", "parseWithPlaceholders", "(Lnet/minecraft/class_2168;Ljava/lang/String;)Lnet/minecraft/class_2561;", "Lnet/minecraft/class_3222;", "player", "rawMessage", "formatPlayerChat", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Lnet/minecraft/class_2561;", "getNicknameRaw", "(Lnet/minecraft/class_3222;)Ljava/lang/String;", "getNicknameDisplay", "(Lnet/minecraft/class_3222;)Lnet/minecraft/class_2561;", "nicknameRaw", "", "setNickname", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "", "refreshTabFor", "(Lnet/minecraft/class_3222;)V", "refreshTabAll", "()V", "prefix", "setNametagPrefix", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2561;)V", "suffix", "setNametagSuffix", "isSpamming", "(Lnet/minecraft/class_3222;)Z", "warnSpam", "text", "broadcastSystem", "(Lnet/minecraft/class_2561;)V", "sendStyledTo", "ctx", "sendRawTo", "(Lnet/minecraft/class_3222;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "sendRawToAll", "(Ljava/lang/String;Lnet/minecraft/class_2168;)V", "bypassFilters", "sendChatFrom", "(Lnet/minecraft/class_3222;Ljava/lang/String;Z)Z", "Leu/pb4/placeholders/api/PlaceholderContext;", "placeholderContextOf", "(Lnet/minecraft/class_3222;)Leu/pb4/placeholders/api/PlaceholderContext;", "Lorg/krripe/shadowchat/api/ShadowChatListener;", "listener", "addListener", "(Lorg/krripe/shadowchat/api/ShadowChatListener;)V", "removeListener", "Lorg/krripe/shadowchat/api/ChatPreEvent;", "fireChatPre", "(Lorg/krripe/shadowchat/api/ChatPreEvent;)Lorg/krripe/shadowchat/api/ChatPreEvent;", "sender", "formatted", "fireChatPost", "", "targets", "content", "firePrivateMessage", "(Lnet/minecraft/class_3222;Ljava/util/List;Ljava/lang/String;)V", "fireBroadcast", "(Lnet/minecraft/class_2168;Ljava/lang/String;Lnet/minecraft/class_2561;)V", "fireJoin", "fireLeave", "fireDeath", "Lorg/krripe/shadowchat/api/ChatChannel;", "channel", "registerChannel", "(Lorg/krripe/shadowchat/api/ChatChannel;)V", "id", "unregisterChannel", "(Ljava/lang/String;)V", "sendToChannel", "(Ljava/lang/String;Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/util/concurrent/ConcurrentHashMap;", "channels", "Ljava/util/concurrent/ConcurrentHashMap;", "ShadowChat"})
@SourceDebugExtension(value={"SMAP\nDefaultShadowChatAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultShadowChatAPI.kt\norg/krripe/shadowchat/api/impl/DefaultShadowChatAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1869#2,2:166\n1869#2,2:168\n1869#2,2:170\n1869#2,2:172\n1869#2,2:174\n1869#2,2:176\n1869#2,2:178\n1869#2,2:180\n1869#2,2:182\n*S KotlinDebug\n*F\n+ 1 DefaultShadowChatAPI.kt\norg/krripe/shadowchat/api/impl/DefaultShadowChatAPI\n*L\n36#1:166,2\n40#1:168,2\n109#1:170,2\n116#1:172,2\n122#1:174,2\n128#1:176,2\n134#1:178,2\n140#1:180,2\n146#1:182,2\n*E\n"})
public final class DefaultShadowChatAPI
implements ShadowChatAPI {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final CopyOnWriteArrayList<ShadowChatListener> listeners;
    @NotNull
    private final ConcurrentHashMap<String, ChatChannel> channels;

    public DefaultShadowChatAPI(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.listeners = new CopyOnWriteArrayList();
        this.channels = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    @NotNull
    public class_2561 parseColors(@NotNull String raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        return (class_2561)CustomColorParser.processAllFormats$default(CustomColorParser.INSTANCE, raw, null, 2, null);
    }

    @Override
    @NotNull
    public class_2561 parseWithPlaceholders(@NotNull class_2168 source, @NotNull String raw) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        class_5250 colored = CustomColorParser.processAllFormats$default(CustomColorParser.INSTANCE, raw, null, 2, null);
        class_2561 class_25612 = Placeholders.parseText((class_2561)((class_2561)colored), (PlaceholderContext)PlaceholderContext.of((class_2168)source));
        Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"parseText(...)");
        return class_25612;
    }

    @Override
    @NotNull
    public class_2561 formatPlayerChat(@NotNull class_3222 player, @NotNull String rawMessage) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
        return ChatFormatManager.INSTANCE.getChatMessage(player, rawMessage);
    }

    @Override
    @Nullable
    public String getNicknameRaw(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return NicknameManager.INSTANCE.getRaw(player);
    }

    @Override
    @NotNull
    public class_2561 getNicknameDisplay(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return NicknameManager.INSTANCE.getNickname(player);
    }

    @Override
    public boolean setNickname(@NotNull class_3222 player, @Nullable String nicknameRaw) {
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CharSequence charSequence = nicknameRaw;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            NicknameManager.INSTANCE.resetNickname(player);
            $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShadowChatListener it = (ShadowChatListener)element$iv;
                boolean bl = false;
                it.onNicknameChanged(player, null);
            }
            return true;
        }
        NicknameManager.INSTANCE.setNickname(player, nicknameRaw);
        $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            it.onNicknameChanged(player, nicknameRaw);
        }
        return true;
    }

    @Override
    public void refreshTabFor(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TabListManager.INSTANCE.sendHeaderFooter(player);
        TabListManager.INSTANCE.pushDisplayNameUpdate(player);
        WeightManager.INSTANCE.applyTeam(player);
    }

    @Override
    public void refreshTabAll() {
        TabListManager.INSTANCE.refreshAll(this.getServer());
    }

    @Override
    public void setNametagPrefix(@NotNull class_3222 player, @Nullable class_2561 prefix) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NameTagManager.INSTANCE.setOverridePrefix(player, prefix);
        WeightManager.INSTANCE.applyTeam(player);
    }

    @Override
    public void setNametagSuffix(@NotNull class_3222 player, @Nullable class_2561 suffix) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NameTagManager.INSTANCE.setOverrideSuffix(player, suffix);
        WeightManager.INSTANCE.applyTeam(player);
    }

    @Override
    public boolean isSpamming(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return SpamManager.INSTANCE.shouldBlock(player);
    }

    @Override
    public void warnSpam(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        SpamManager.INSTANCE.warn(player);
    }

    @Override
    public void broadcastSystem(@NotNull class_2561 text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.getServer().method_3760().method_43514(text, false);
    }

    @Override
    public void sendStyledTo(@NotNull class_3222 player, @NotNull class_2561 text) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        player.method_7353(text, false);
    }

    @Override
    public void sendRawTo(@NotNull class_3222 player, @NotNull String raw, @Nullable class_2168 ctx) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        class_2168 class_21682 = ctx;
        if (class_21682 == null) {
            class_21682 = player.method_5671();
        }
        class_2168 src = class_21682;
        Intrinsics.checkNotNull((Object)src);
        this.sendStyledTo(player, this.parseWithPlaceholders(src, raw));
    }

    @Override
    public void sendRawToAll(@NotNull String raw, @Nullable class_2168 ctx) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        class_2168 class_21682 = ctx;
        if (class_21682 == null) {
            class_21682 = this.getServer().method_3739();
        }
        class_2168 source = class_21682;
        Intrinsics.checkNotNull((Object)source);
        class_2561 parsed = this.parseWithPlaceholders(source, raw);
        this.broadcastSystem(parsed);
    }

    @Override
    public boolean sendChatFrom(@NotNull class_3222 player, @NotNull String raw, boolean bypassFilters) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        ChatPreEvent pre = this.fireChatPre(new ChatPreEvent(player, raw, false, null, bypassFilters, 12, null));
        if (pre.getCancel()) {
            return false;
        }
        class_2561 class_25612 = pre.getOverrideFormatted();
        if (class_25612 == null) {
            String string;
            if (pre.getBypassFilters()) {
                string = pre.getMessage();
            } else {
                String string2 = (String)BadWordManager.INSTANCE.filterMessage(pre.getMessage()).getFirst();
                class_2168 class_21682 = player.method_5671();
                Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"getCommandSource(...)");
                string = FormatPermissionFilter.INSTANCE.filter(string2, class_21682);
            }
            class_25612 = ChatFormatManager.INSTANCE.getChatMessage(player, string);
        }
        class_2561 formatted = class_25612;
        this.getServer().method_3760().method_43514(formatted, false);
        this.fireChatPost(player, formatted);
        LogManager.INSTANCE.logChat(player, pre.getMessage());
        return true;
    }

    @Override
    @NotNull
    public PlaceholderContext placeholderContextOf(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlaceholderContext placeholderContext = PlaceholderContext.of((class_3222)player);
        Intrinsics.checkNotNullExpressionValue((Object)placeholderContext, (String)"of(...)");
        return placeholderContext;
    }

    @Override
    public void addListener(@NotNull ShadowChatListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.listeners).add(listener);
    }

    @Override
    public void removeListener(@NotNull ShadowChatListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.listeners).remove(listener);
    }

    @Override
    @NotNull
    public ChatPreEvent fireChatPre(@NotNull ChatPreEvent ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onChatPre(ctx);
            }
            catch (Throwable throwable) {
            }
        }
        return ctx;
    }

    @Override
    public void fireChatPost(@NotNull class_3222 sender, @NotNull class_2561 formatted) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onChatPost(sender, formatted);
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void firePrivateMessage(@NotNull class_3222 sender, @NotNull List<? extends class_3222> targets, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onPrivateMessage(sender, targets, content);
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void fireBroadcast(@NotNull class_2168 source, @NotNull String content, @NotNull class_2561 formatted) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onBroadcast(source, content, formatted);
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void fireJoin(@NotNull class_3222 player, @NotNull class_2561 formatted) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onJoin(player, formatted);
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void fireLeave(@NotNull class_3222 player, @NotNull class_2561 formatted) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onLeave(player, formatted);
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void fireDeath(@NotNull class_3222 player, @NotNull class_2561 formatted) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShadowChatListener it = (ShadowChatListener)element$iv;
            boolean bl = false;
            try {
                it.onDeath(player, formatted);
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void registerChannel(@NotNull ChatChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Map map = this.channels;
        String string = channel.getId().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        map.put(string, channel);
    }

    @Override
    public void unregisterChannel(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = id.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.channels.remove(string);
    }

    @Override
    public boolean sendToChannel(@NotNull String id, @NotNull class_3222 sender, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = id.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        ChatChannel chatChannel = this.channels.get(string);
        if (chatChannel == null) {
            return false;
        }
        ChatChannel ch = chatChannel;
        String perm = ch.getPermission();
        if (perm != null) {
            PermissionsSystem permissionsSystem = new PermissionsSystem();
            class_2168 class_21682 = sender.method_5671();
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"getCommandSource(...)");
            if (!permissionsSystem.hasPermission(class_21682, perm)) {
                return false;
            }
        }
        class_2561 txt = ch.format(sender, content);
        for (class_3222 p : ch.audience(this.getServer(), sender)) {
            p.method_7353(txt, false);
        }
        return true;
    }
}

