/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.krripe.shadowchat.config.ChatConfig;
import org.krripe.shadowchat.config.RankFormat;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\u001c\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001c\u0010\f\u001a\n \b*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/krripe/shadowchat/config/ConfigManager;", "", "<init>", "()V", "", "load", "save", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "configFile", "Ljava/io/File;", "Lorg/krripe/shadowchat/config/ChatConfig;", "chatConfig", "Lorg/krripe/shadowchat/config/ChatConfig;", "getChatConfig", "()Lorg/krripe/shadowchat/config/ChatConfig;", "setChatConfig", "(Lorg/krripe/shadowchat/config/ChatConfig;)V", "ShadowChat"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final File configFile = FabricLoader.getInstance().getConfigDir().resolve("shadowchat").resolve("chat_config.json").toFile();
    @NotNull
    private static ChatConfig chatConfig;

    private ConfigManager() {
    }

    @NotNull
    public final ChatConfig getChatConfig() {
        return chatConfig;
    }

    public final void setChatConfig(@NotNull ChatConfig chatConfig) {
        Intrinsics.checkNotNullParameter((Object)chatConfig, (String)"<set-?>");
        ConfigManager.chatConfig = chatConfig;
    }

    public final void load() {
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            File file = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configFile");
            String string = gson.toJson((Object)chatConfig);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        } else {
            try {
                Type type2 = new TypeToken<ChatConfig>(){}.getType();
                File file = configFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configFile");
                Object object = gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), type2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                chatConfig = (ChatConfig)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void save() {
        try {
            File file = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configFile");
            String string = gson.toJson((Object)chatConfig);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Object[] objectArray = new RankFormat[]{new RankFormat("<#ff5555>[Admin] %player:name%</#>", "<#ff5555>[Admin]</#> ${display_name} <#aaaaaa>\u27a4</#> ${message}", "shadowchat.rank.admin"), new RankFormat("<#55ffff>[Helper] %player:name%</#>", "<#55ffff>[Helper]</#> ${display_name} <#aaaaaa>\u27a4</#> ${message}", "shadowchat.rank.helper")};
        chatConfig = new ChatConfig(null, null, null, null, null, null, null, null, null, CollectionsKt.listOf((Object[])objectArray), null, null, null, null, 15871, null);
    }
}

