/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0011\u001a\n \r*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/krripe/shadowchat/data/NicknameStorage;", "", "<init>", "()V", "", "", "data", "", "save", "(Ljava/util/Map;)V", "load", "()Ljava/util/Map;", "Ljava/io/File;", "kotlin.jvm.PlatformType", "file", "Ljava/io/File;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "ShadowChat"})
public final class NicknameStorage {
    @NotNull
    public static final NicknameStorage INSTANCE = new NicknameStorage();
    private static final File file = FabricLoader.getInstance().getConfigDir().resolve("shadowchat/data/nicknames.json").toFile();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private NicknameStorage() {
    }

    public final void save(@NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            file.getParentFile().mkdirs();
            File file = NicknameStorage.file;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            String string = gson.toJson(data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        catch (Exception e) {
            System.out.println((Object)("[ShadowChat] Failed to save nicknames: " + e.getMessage()));
        }
    }

    @NotNull
    public final Map<String, String> load() {
        Object object;
        if (!file.exists()) {
            return MapsKt.emptyMap();
        }
        try {
            Type type2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
            File file = NicknameStorage.file;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            object = gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), type2);
            Intrinsics.checkNotNull((Object)object);
            object = (Map)object;
        }
        catch (Exception e) {
            System.out.println((Object)("[ShadowChat] Failed to load nicknames: " + e.getMessage()));
            object = MapsKt.emptyMap();
        }
        return object;
    }
}

