/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.events;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.krripe.shadowchat.api.ChatPreEvent;
import org.krripe.shadowchat.api.ShadowChat;
import org.krripe.shadowchat.api.ShadowChatAPI;
import org.krripe.shadowchat.compat.TriviaCompat;
import org.krripe.shadowchat.config.ConfigManager;
import org.krripe.shadowchat.manager.BadWordManager;
import org.krripe.shadowchat.manager.ChatFormatManager;
import org.krripe.shadowchat.manager.LogManager;
import org.krripe.shadowchat.manager.MentionManager;
import org.krripe.shadowchat.manager.NicknameManager;
import org.krripe.shadowchat.manager.SpamManager;
import org.krripe.shadowchat.manager.TabListManager;
import org.krripe.shadowchat.manager.WeightManager;
import org.krripe.shadowchat.utils.FormatPermissionFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/krripe/shadowchat/events/ChatEventHandler;", "", "<init>", "()V", "", "registerEvents", "ShadowChat"})
public final class ChatEventHandler {
    @NotNull
    public static final ChatEventHandler INSTANCE = new ChatEventHandler();

    private ChatEventHandler() {
    }

    public final void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register(ChatEventHandler::registerEvents$lambda$2);
        ServerLifecycleEvents.SERVER_STARTED.register(ChatEventHandler::registerEvents$lambda$3);
        ServerPlayConnectionEvents.DISCONNECT.register(ChatEventHandler::registerEvents$lambda$4);
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register(ChatEventHandler::registerEvents$lambda$5);
    }

    private static final void registerEvents$lambda$2$lambda$0(class_3244 $handler, MinecraftServer $server) {
        class_3222 p = $handler.field_14140;
        Intrinsics.checkNotNull((Object)p);
        class_2561 joinMsg = ChatFormatManager.INSTANCE.getJoinMessage(p);
        $server.method_3760().method_43514(joinMsg, false);
        try {
            ShadowChat.INSTANCE.get().fireJoin(p, joinMsg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ConfigManager.INSTANCE.getChatConfig().getChatSystems().getTab()) {
            TabListManager.INSTANCE.sendHeaderFooter(p);
            TabListManager.INSTANCE.pushDisplayNameUpdate(p);
        }
        if (ConfigManager.INSTANCE.getChatConfig().getChatSystems().getWeights()) {
            WeightManager.INSTANCE.applyTeam(p);
        }
    }

    private static final void registerEvents$lambda$2(class_3244 handler, PacketSender packetSender, MinecraftServer server) {
        block0: {
            server.execute(() -> ChatEventHandler.registerEvents$lambda$2$lambda$0(handler, server));
            class_3222 class_32222 = handler.field_14140;
            Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
            String string = NicknameManager.INSTANCE.getRaw(class_32222);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            class_3222 class_32223 = handler.field_14140;
            Intrinsics.checkNotNullExpressionValue((Object)class_32223, (String)"player");
            NicknameManager.INSTANCE.setNickname(class_32223, it);
        }
    }

    private static final void registerEvents$lambda$3(MinecraftServer srv) {
        if (ConfigManager.INSTANCE.getChatConfig().getChatSystems().getWeights()) {
            Intrinsics.checkNotNull((Object)srv);
            WeightManager.INSTANCE.refreshAll(srv);
        }
    }

    private static final void registerEvents$lambda$4(class_3244 handler, MinecraftServer server) {
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
        class_2561 leaveMsg = ChatFormatManager.INSTANCE.getLeaveMessage(class_32222);
        server.method_3760().method_43514(leaveMsg, false);
        try {
            ShadowChatAPI shadowChatAPI = ShadowChat.INSTANCE.get();
            class_3222 class_32223 = handler.field_14140;
            Intrinsics.checkNotNullExpressionValue((Object)class_32223, (String)"player");
            shadowChatAPI.fireLeave(class_32223, leaveMsg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final boolean registerEvents$lambda$5(class_7471 message, class_3222 sender, class_2556.class_7602 class_76022) {
        ChatPreEvent chatPreEvent;
        String colorSafe;
        boolean bypass;
        ChatPreEvent pre;
        ChatPreEvent chatPreEvent2;
        ShadowChatAPI api;
        ShadowChatAPI shadowChatAPI;
        try {
            shadowChatAPI = ShadowChat.INSTANCE.get();
        }
        catch (Throwable throwable) {
            shadowChatAPI = null;
        }
        ShadowChatAPI shadowChatAPI2 = api = shadowChatAPI;
        if (shadowChatAPI2 != null) {
            Intrinsics.checkNotNull((Object)sender);
            String string = message.method_44862();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSignedContent(...)");
            chatPreEvent2 = shadowChatAPI2.fireChatPre(new ChatPreEvent(sender, string, false, null, false, 28, null));
        } else {
            chatPreEvent2 = null;
        }
        ChatPreEvent chatPreEvent3 = pre = chatPreEvent2;
        boolean bl = chatPreEvent3 != null ? chatPreEvent3.getCancel() : false;
        if (bl) {
            return false;
        }
        Object object = pre;
        if (object == null || (object = ((ChatPreEvent)object).getMessage()) == null) {
            object = message.method_44862();
        }
        Object effectiveRaw = object;
        ChatPreEvent chatPreEvent4 = pre;
        boolean bl2 = chatPreEvent4 != null ? chatPreEvent4.getBypassFilters() : (bypass = false);
        if (!bypass && ConfigManager.INSTANCE.getChatConfig().getChatSystems().getSpam()) {
            Intrinsics.checkNotNull((Object)sender);
            if (SpamManager.INSTANCE.shouldBlock(sender)) {
                SpamManager.INSTANCE.warn(sender);
                return false;
            }
        }
        Intrinsics.checkNotNull((Object)sender);
        Intrinsics.checkNotNull((Object)effectiveRaw);
        TriviaCompat.INSTANCE.tryAnswerTrivia(sender, (String)effectiveRaw);
        Triple triple = bypass ? new Triple(effectiveRaw, (Object)0, effectiveRaw) : BadWordManager.INSTANCE.filterMessage((String)effectiveRaw);
        String censored = (String)triple.component1();
        int offenseCount = ((Number)triple.component2()).intValue();
        String original = (String)triple.component3();
        if (!bypass) {
            BadWordManager.INSTANCE.handleBadWords(sender, offenseCount);
        }
        if (bypass) {
            v8 = censored;
        } else {
            class_2168 class_21682 = sender.method_5671();
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"getCommandSource(...)");
            v8 = colorSafe = FormatPermissionFilter.INSTANCE.filter(censored, class_21682);
        }
        if ((chatPreEvent = pre) == null || (chatPreEvent = chatPreEvent.getOverrideFormatted()) == null) {
            chatPreEvent = ChatFormatManager.INSTANCE.getChatMessage(sender, colorSafe);
        }
        ChatPreEvent formatted = chatPreEvent;
        MentionManager.INSTANCE.handleMentions(censored, sender);
        LogManager.INSTANCE.logChat(sender, original);
        sender.field_13995.method_3760().method_43514((class_2561)formatted, false);
        try {
            ShadowChatAPI shadowChatAPI3 = api;
            if (shadowChatAPI3 != null) {
                shadowChatAPI3.fireChatPost(sender, (class_2561)formatted);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

