/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.krripe.shadowchat.config.Announcement;
import org.krripe.shadowchat.config.AnnouncementsConfig;
import org.krripe.shadowchat.config.ChatSystems;
import org.krripe.shadowchat.config.ConfigManager;
import org.krripe.shadowchat.utils.CustomColorParser;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010!\u001a\n \u0014*\u0004\u0018\u00010 0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R$\u0010&\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lorg/krripe/shadowchat/manager/AnnouncementManager;", "", "<init>", "()V", "", "init", "load", "save", "Lnet/minecraft/server/MinecraftServer;", "server", "onConfigReload", "(Lnet/minecraft/server/MinecraftServer;)V", "scheduleAll", "Lorg/krripe/shadowchat/config/Announcement;", "ann", "schedule", "(Lnet/minecraft/server/MinecraftServer;Lorg/krripe/shadowchat/config/Announcement;)V", "cancelAll", "sendAnnouncement", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Ljava/nio/file/Path;", "file", "Ljava/nio/file/Path;", "Lorg/krripe/shadowchat/config/AnnouncementsConfig;", "value", "cfg", "Lorg/krripe/shadowchat/config/AnnouncementsConfig;", "getCfg", "()Lorg/krripe/shadowchat/config/AnnouncementsConfig;", "Ljava/util/concurrent/ScheduledExecutorService;", "exec", "Ljava/util/concurrent/ScheduledExecutorService;", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/ScheduledFuture;", "tasks", "Ljava/util/concurrent/ConcurrentHashMap;", "ShadowChat"})
@SourceDebugExtension(value={"SMAP\nAnnouncementManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnouncementManager.kt\norg/krripe/shadowchat/manager/AnnouncementManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n774#2:116\n865#2,2:117\n1869#2,2:119\n1869#2,2:121\n774#2:123\n865#2,2:124\n1#3:126\n*S KotlinDebug\n*F\n+ 1 AnnouncementManager.kt\norg/krripe/shadowchat/manager/AnnouncementManager\n*L\n84#1:116\n84#1:117,2\n85#1:119,2\n98#1:121,2\n103#1:123\n103#1:124,2\n*E\n"})
public final class AnnouncementManager {
    @NotNull
    public static final AnnouncementManager INSTANCE = new AnnouncementManager();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @NotNull
    private static final Path file;
    @NotNull
    private static volatile AnnouncementsConfig cfg;
    private static final ScheduledExecutorService exec;
    @NotNull
    private static final ConcurrentHashMap<String, ScheduledFuture<?>> tasks;

    private AnnouncementManager() {
    }

    @NotNull
    public final AnnouncementsConfig getCfg() {
        return cfg;
    }

    public final void init() {
        this.load();
        ServerLifecycleEvents.SERVER_STARTED.register(AnnouncementManager::init$lambda$2);
        ServerLifecycleEvents.SERVER_STOPPING.register(AnnouncementManager::init$lambda$3);
    }

    public final void load() {
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path = file.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                Path path2 = path;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                cfg = new AnnouncementsConfig(null, 1, null);
                this.save();
            } else {
                Type type2 = new TypeToken<AnnouncementsConfig>(){}.getType();
                AnnouncementsConfig announcementsConfig = (AnnouncementsConfig)gson.fromJson(Files.readString(file), type2);
                if (announcementsConfig == null) {
                    announcementsConfig = new AnnouncementsConfig(null, 1, null);
                }
                cfg = announcementsConfig;
            }
        }
        catch (Exception exception) {
            cfg = new AnnouncementsConfig(null, 1, null);
        }
    }

    public final void save() {
        try {
            Path path = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Object object = path;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            object = gson.toJson((Object)cfg);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toJson(...)");
            PathsKt.writeText$default((Path)file, (CharSequence)((CharSequence)object), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void onConfigReload(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ChatSystems systems = ConfigManager.INSTANCE.getChatConfig().getChatSystems();
        this.cancelAll();
        this.load();
        if (systems.getAnnouncements()) {
            this.scheduleAll(server);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void scheduleAll(@NotNull MinecraftServer server) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$filter$iv = cfg.getAnnouncements();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Announcement it = (Announcement)element$iv$iv;
            boolean bl = false;
            if (!(it.getEnabled() && !((Collection)it.getLines()).isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Announcement it = (Announcement)element$iv;
            boolean bl = false;
            INSTANCE.schedule(server, it);
        }
    }

    private final void schedule(MinecraftServer server, Announcement ann) {
        long period = Math.max(1L, (long)ann.getIntervalSeconds());
        ScheduledFuture<?> task = exec.scheduleAtFixedRate(() -> AnnouncementManager.schedule$lambda$7(server, ann), period, period, TimeUnit.SECONDS);
        ((Map)tasks).put(ann.getId(), task);
    }

    public final void cancelAll() {
        Collection<ScheduledFuture<?>> collection = tasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledFuture it = (ScheduledFuture)element$iv;
            boolean bl = false;
            it.cancel(false);
        }
        tasks.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void sendAnnouncement(MinecraftServer server, Announcement ann) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ann.getLines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        if (lines.isEmpty()) {
            return;
        }
        for (class_3222 p : server.method_3760().method_14571()) {
            PlaceholderContext ctx = PlaceholderContext.of((class_3222)p);
            for (String raw : lines) {
                class_2561 parsed;
                class_5250 colored = CustomColorParser.processAllFormats$default(CustomColorParser.INSTANCE, raw, null, 2, null);
                Intrinsics.checkNotNullExpressionValue((Object)Placeholders.parseText((class_2561)((class_2561)colored), (PlaceholderContext)ctx), (String)"parseText(...)");
                p.method_7353(parsed, false);
            }
        }
    }

    private static final Thread exec$lambda$1(Runnable r) {
        Thread thread;
        Thread $this$exec_u24lambda_u241_u24lambda_u240 = thread = new Thread(r, "ShadowChat-Announcements");
        boolean bl = false;
        $this$exec_u24lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final void init$lambda$2(MinecraftServer server) {
        INSTANCE.cancelAll();
        if (ConfigManager.INSTANCE.getChatConfig().getChatSystems().getAnnouncements()) {
            Intrinsics.checkNotNull((Object)server);
            INSTANCE.scheduleAll(server);
        }
    }

    private static final void init$lambda$3(MinecraftServer it) {
        INSTANCE.cancelAll();
    }

    private static final void schedule$lambda$7$lambda$6(MinecraftServer $server, Announcement $ann) {
        INSTANCE.sendAnnouncement($server, $ann);
    }

    private static final void schedule$lambda$7(MinecraftServer $server, Announcement $ann) {
        $server.execute(() -> AnnouncementManager.schedule$lambda$7$lambda$6($server, $ann));
    }

    static {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("shadowchat").resolve("announcements.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        file = path;
        cfg = new AnnouncementsConfig(null, 1, null);
        exec = Executors.newSingleThreadScheduledExecutor(AnnouncementManager::exec$lambda$1);
        tasks = new ConcurrentHashMap();
    }
}

