/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.krripe.shadowchat.config.BadWordsConfig;
import org.krripe.shadowchat.utils.CustomColorParser;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J'\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0016\u001a\n \u0012*\u0004\u0018\u00010\u00150\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\t0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/krripe/shadowchat/manager/BadWordManager;", "", "<init>", "()V", "", "loadConfig", "", "message", "Lkotlin/Triple;", "", "filterMessage", "(Ljava/lang/String;)Lkotlin/Triple;", "Lnet/minecraft/class_3222;", "player", "offenseCount", "handleBadWords", "(Lnet/minecraft/class_3222;I)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "configFile", "Ljava/io/File;", "", "Ljava/util/UUID;", "playerOffenses", "Ljava/util/Map;", "Lorg/krripe/shadowchat/config/BadWordsConfig;", "config", "Lorg/krripe/shadowchat/config/BadWordsConfig;", "ShadowChat"})
public final class BadWordManager {
    @NotNull
    public static final BadWordManager INSTANCE = new BadWordManager();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final File configFile = FabricLoader.getInstance().getConfigDir().resolve("shadowchat").resolve("badwords.json").toFile();
    @NotNull
    private static final Map<UUID, Integer> playerOffenses = new LinkedHashMap();
    @NotNull
    private static BadWordsConfig config = new BadWordsConfig(false, null, null, null, null, 31, null);

    private BadWordManager() {
    }

    public final void loadConfig() {
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            File file = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configFile");
            String string = gson.toJson((Object)config);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        } else {
            try {
                File file = configFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"configFile");
                Object object = gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), BadWordsConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                config = (BadWordsConfig)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public final Triple<String, Integer, String> filterMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!config.getEnabled()) {
            return new Triple((Object)message, (Object)0, (Object)message);
        }
        String filtered = message;
        int found = 0;
        for (String word : config.getBadWords()) {
            Regex regex = new Regex("\\b" + Regex.Companion.escape(word) + "\\b", RegexOption.IGNORE_CASE);
            int matches = SequencesKt.count((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)filtered, (int)0, (int)2, null));
            if (matches <= 0) continue;
            CharSequence charSequence = filtered;
            String string = config.getCensorWord();
            filtered = regex.replace(charSequence, string);
            found += matches;
        }
        return new Triple((Object)filtered, (Object)found, (Object)message);
    }

    public final void handleBadWords(@NotNull class_3222 player, int offenseCount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (offenseCount <= 0) {
            return;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        int previousOffenses = ((Number)playerOffenses.getOrDefault(uUID, 0)).intValue();
        int newOffenseTotal = previousOffenses + offenseCount;
        Integer n = newOffenseTotal;
        playerOffenses.put(player.method_5667(), n);
        int offensesPerWarning = config.getWarnings().getOffensesPerWarning();
        int maxWarnings = config.getWarnings().getMaxWarnings();
        int currentWarningLevel = previousOffenses / offensesPerWarning;
        int newWarningLevel = newOffenseTotal / offensesPerWarning;
        if (newWarningLevel > currentWarningLevel && newWarningLevel <= maxWarnings) {
            String string = config.getMessages().getWarningMessage();
            String string2 = player.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String warnMsg = StringsKt.replace$default((String)string, (String)"%player%", (String)string2, (boolean)false, (int)4, null);
            class_5250 parsed = CustomColorParser.processAllFormats$default(CustomColorParser.INSTANCE, warnMsg, null, 2, null);
            player.method_7353((class_2561)parsed, false);
        }
        if (newWarningLevel > maxWarnings) {
            String string = config.getWarnings().getPunishmentCommand();
            String string3 = player.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            String cmd = StringsKt.replace$default((String)string, (String)"%player%", (String)string3, (boolean)false, (int)4, null);
            player.field_13995.method_3734().method_44252(player.field_13995.method_3739(), cmd);
            String string4 = config.getMessages().getPunishmentBroadcast();
            String string5 = player.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            String broadcastMsg = StringsKt.replace$default((String)string4, (String)"%player%", (String)string5, (boolean)false, (int)4, null);
            class_5250 parsed = CustomColorParser.processAllFormats$default(CustomColorParser.INSTANCE, broadcastMsg, null, 2, null);
            player.field_13995.method_3760().method_43514((class_2561)parsed, false);
            playerOffenses.put(player.method_5667(), 0);
        }
    }
}

