/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.manager;

import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.krripe.shadowchat.config.ConfigManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lorg/krripe/shadowchat/manager/LogManager;", "", "<init>", "()V", "Ljava/io/File;", "getLogFile", "()Ljava/io/File;", "Lnet/minecraft/class_3222;", "player", "", "message", "", "logChat", "(Lnet/minecraft/class_3222;Ljava/lang/String;)V", "sender", "target", "logPrivate", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "text", "writeLine", "(Ljava/lang/String;)V", "logDir", "Ljava/io/File;", "Ljava/time/format/DateTimeFormatter;", "timeFormat", "Ljava/time/format/DateTimeFormatter;", "dateFormat", "ShadowChat"})
public final class LogManager {
    @NotNull
    public static final LogManager INSTANCE = new LogManager();
    @NotNull
    private static final File logDir;
    @NotNull
    private static final DateTimeFormatter timeFormat;
    @NotNull
    private static final DateTimeFormatter dateFormat;

    private LogManager() {
    }

    private final File getLogFile() {
        String date = LocalDate.now().format(dateFormat);
        return FilesKt.resolve((File)logDir, (String)("chat-" + date + ".txt"));
    }

    public final void logChat(@NotNull class_3222 player, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!ConfigManager.INSTANCE.getChatConfig().getChatSystems().getLogMessages()) {
            return;
        }
        String time = LocalTime.now().format(timeFormat);
        String line = "[" + time + "] [" + player.method_5477().getString() + "] " + message;
        this.writeLine(line);
    }

    public final void logPrivate(@NotNull String sender, @NotNull String target, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!ConfigManager.INSTANCE.getChatConfig().getChatSystems().getLogMessages()) {
            return;
        }
        String time = LocalTime.now().format(timeFormat);
        String line = "[" + time + "] [msg -> " + sender + " -> " + target + "] " + message;
        this.writeLine(line);
    }

    private final void writeLine(String text) {
        try {
            FilesKt.appendText$default((File)this.getLogFile(), (String)(text + "\n"), null, (int)2, null);
        }
        catch (Exception e) {
            System.out.println((Object)("[ShadowChat] Failed to write chat log: " + e.getMessage()));
        }
    }

    static {
        File file = FabricLoader.getInstance().getConfigDir().resolve("shadowchat/chat_logs").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        logDir = file;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        timeFormat = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"ofPattern(...)");
        dateFormat = dateTimeFormatter2;
        logDir.mkdirs();
    }
}

