/*
 * Decompiled with CFR 0.152.
 */
package org.krripe.shadowchat.manager;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.krripe.shadowchat.data.NicknameStorage;
import org.krripe.shadowchat.manager.TabListManager;
import org.krripe.shadowchat.manager.WeightManager;
import org.krripe.shadowchat.utils.CustomColorParser;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u0015\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0011R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/krripe/shadowchat/manager/NicknameManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_2561;", "getNickname", "(Lnet/minecraft/class_3222;)Lnet/minecraft/class_2561;", "", "nickname", "", "setNickname", "(Lnet/minecraft/class_3222;Ljava/lang/String;)V", "resetNickname", "(Lnet/minecraft/class_3222;)V", "getRaw", "(Lnet/minecraft/class_3222;)Ljava/lang/String;", "load", "getDisplayName", "", "nicknames", "Ljava/util/Map;", "ShadowChat"})
public final class NicknameManager {
    @NotNull
    public static final NicknameManager INSTANCE = new NicknameManager();
    @NotNull
    private static final Map<String, String> nicknames = new LinkedHashMap();

    private NicknameManager() {
    }

    @NotNull
    public final class_2561 getNickname(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = nicknames.get(player.method_5845());
        if (string == null) {
            string = player.method_5477().getString();
        }
        String raw = string;
        Intrinsics.checkNotNull((Object)raw);
        return (class_2561)CustomColorParser.processAllFormats$default(CustomColorParser.INSTANCE, raw, null, 2, null);
    }

    public final void setNickname(@NotNull class_3222 player, @NotNull String nickname) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)nickname, (String)"nickname");
        nicknames.put(player.method_5845(), nickname);
        NicknameStorage.INSTANCE.save(nicknames);
        WeightManager.INSTANCE.applyTeam(player);
        TabListManager.INSTANCE.pushDisplayNameUpdate(player);
    }

    public final void resetNickname(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        nicknames.remove(player.method_5845());
        NicknameStorage.INSTANCE.save(nicknames);
        TabListManager.INSTANCE.pushDisplayNameUpdate(player);
    }

    @Nullable
    public final String getRaw(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return nicknames.get(player.method_5845());
    }

    public final void load() {
        nicknames.putAll(NicknameStorage.INSTANCE.load());
    }

    @NotNull
    public final String getDisplayName(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = this.getRaw(player);
        if (string == null) {
            String string2 = player.method_5477().getString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        }
        return string;
    }
}

