/*
 * Decompiled with CFR 0.152.
 */
package com.example.graphcommands;

import com.example.graphcommands.ClientCommandHandler;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.joml.Matrix3x2fStack;

public class PointManagerScreen
extends class_437 {
    private class_5321<class_1937> selectedDimension;
    private List<ClientCommandHandler.Point> points;
    private int selectedPointIndex = -1;
    private class_342 nameField;
    private class_342 xField;
    private class_342 yField;
    private class_342 zField;
    private class_357 transparencySlider;
    private float transparencyValue;
    private class_4185 colorButton;
    private class_4185 iconButton;
    private int currentColorIndex = 0;
    private int currentIconIndex = 0;
    private boolean isCreatingNewPoint = false;
    private boolean isSettingsMenu = false;
    private boolean isCompassSettingsMenu = false;
    private boolean isPointSettingsMenu = false;
    private int currentPage = 0;
    private int pointsPerPage;
    private List<class_339> settingsWidgets = new ArrayList<class_339>();
    private List<class_339> editWidgets = new ArrayList<class_339>();
    private class_4185 shareCoordsButton;
    private long shareButtonResetTime = -1L;

    public PointManagerScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.graphcommands.point_manager.title"));
        this.field_22793 = class_310.method_1551().field_1772;
        ClientCommandHandler.ensureConfigDirectoryExists();
        ClientCommandHandler.loadSettings();
        this.selectedDimension = null;
    }

    private void updatePointsList() {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            this.points = new ArrayList<ClientCommandHandler.Point>();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.client_or_world_unavailable"), false);
            }
            return;
        }
        String currentServerId = ClientCommandHandler.getServerId(this.field_22787);
        ClientCommandHandler.loadPointsFromFile(this.selectedDimension, currentServerId);
        List<ClientCommandHandler.Point> allPoints = ClientCommandHandler.getPointsForDimension(this.selectedDimension);
        this.points = allPoints.stream().filter(point -> point.serverId() != null && point.serverId().equals(currentServerId)).toList();
        if (this.selectedPointIndex >= this.points.size()) {
            this.selectedPointIndex = -1;
        }
    }

    private void resetState() {
        this.isSettingsMenu = false;
        this.isCompassSettingsMenu = false;
        this.isPointSettingsMenu = false;
        this.isCreatingNewPoint = false;
        this.selectedPointIndex = -1;
        for (class_339 widget : new ArrayList<class_339>(this.settingsWidgets)) {
            this.method_25396().remove(widget);
        }
        this.settingsWidgets.clear();
        for (class_339 widget : new ArrayList<class_339>(this.editWidgets)) {
            this.method_25396().remove(widget);
        }
        this.editWidgets.clear();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.resetState();
        if (this.selectedDimension == null) {
            this.selectedDimension = this.field_22787 != null && this.field_22787.field_1687 != null ? this.field_22787.field_1687.method_27983() : class_1937.field_25179;
            this.updatePointsList();
        }
        int screenHeight = this.field_22787.method_22683().method_4502();
        int availableHeight = screenHeight - 110 - 40;
        int buttonHeightWithSpacing = 25;
        this.pointsPerPage = Math.max(1, availableHeight / buttonHeightWithSpacing);
        int y = 30;
        int buttonWidth = 100;
        int buttonHeight = 20;
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.dimension.overworld"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$1(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((PointManagerScreen)this)).method_46434((int)(this.field_22789 / 2 - 150), (int)y, (int)buttonWidth, (int)buttonHeight).method_46431())).field_22763 = this.selectedDimension != class_1937.field_25179;
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.dimension.nether"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$2(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((PointManagerScreen)this)).method_46434((int)(this.field_22789 / 2 - 50), (int)y, (int)buttonWidth, (int)buttonHeight).method_46431())).field_22763 = this.selectedDimension != class_1937.field_25180;
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.dimension.end"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$3(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((PointManagerScreen)this)).method_46434((int)(this.field_22789 / 2 + 50), (int)y, (int)buttonWidth, (int)buttonHeight).method_46431())).field_22763 = this.selectedDimension != class_1937.field_25181;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.create_point"), button -> {
            this.resetState();
            this.method_25426();
            this.setupCreateForm();
        }).method_46434(20, y += 30, 100, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.settings"), button -> {
            this.resetState();
            this.method_25426();
            this.setupSettingsMenu();
        }).method_46434(130, y, 100, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.delete_all"), button -> {
            this.resetState();
            List<ClientCommandHandler.Point> pointsInDimension = ClientCommandHandler.getPointsForDimension(this.selectedDimension);
            pointsInDimension.clear();
            ClientCommandHandler.setPointsForDimension(this.selectedDimension, pointsInDimension);
            ClientCommandHandler.savePointsToFile(this.selectedDimension, this.field_22787 != null ? ClientCommandHandler.getServerId(this.field_22787) : "unknown");
            this.updatePointsList();
            this.method_25426();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.all_points_deleted"), false);
            }
        }).method_46434(240, y, 100, buttonHeight).method_46431());
        y += 30;
        int startIndex = this.currentPage * this.pointsPerPage;
        int endIndex = Math.min(startIndex + this.pointsPerPage, this.points.size());
        int totalWidth = 320;
        int buttonSpacing = 10;
        int deleteButtonWidth = 60;
        int pointButtonWidth = totalWidth - deleteButtonWidth - buttonSpacing;
        for (int i = startIndex; i < endIndex; ++i) {
            ClientCommandHandler.Point point = this.points.get(i);
            int index = i;
            String iconToRender = point.icon().equals("default") ? "\u2666" : point.icon();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(iconToRender + " " + point.name() + " (" + point.x() + ", " + point.y() + ", " + point.z() + ")")).method_27694(style -> style.method_36139(point.color())), button -> {
                this.resetState();
                this.method_25426();
                this.setupEditForm(point, index);
            }).method_46434(20, y, pointButtonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.delete"), button -> {
                this.resetState();
                List<ClientCommandHandler.Point> pointsInDimension = ClientCommandHandler.getPointsForDimension(this.selectedDimension);
                if (index >= 0 && index < pointsInDimension.size()) {
                    pointsInDimension.remove(index);
                    ClientCommandHandler.setPointsForDimension(this.selectedDimension, pointsInDimension);
                    ClientCommandHandler.savePointsToFile(this.selectedDimension, this.field_22787 != null ? ClientCommandHandler.getServerId(this.field_22787) : "unknown");
                    this.updatePointsList();
                    this.method_25426();
                }
            }).method_46434(20 + pointButtonWidth + buttonSpacing, y, deleteButtonWidth, buttonHeight).method_46431());
            y += 25;
        }
        int totalPages = (int)Math.ceil((double)this.points.size() / (double)this.pointsPerPage);
        int paginationY = this.field_22790 - 30;
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.previous"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$10(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((PointManagerScreen)this)).method_46434((int)20, (int)paginationY, (int)100, (int)buttonHeight).method_46431())).field_22763 = this.currentPage > 0;
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.next"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$11(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((PointManagerScreen)this)).method_46434((int)170, (int)paginationY, (int)100, (int)buttonHeight).method_46431())).field_22763 = this.currentPage < totalPages - 1;
        int shareButtonWidth = 150;
        int shareButtonX = this.field_22789 - shareButtonWidth - 20;
        int shareButtonY = paginationY;
        this.shareCoordsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.share_coords"), button -> {
            if (this.field_22787 == null || this.field_22787.field_1724 == null) {
                if (this.field_22787 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.only_for_players"), false);
                }
                return;
            }
            class_2338 pos = this.field_22787.field_1724.method_24515();
            int share_x = pos.method_10263();
            int share_y = pos.method_10264();
            int share_z = pos.method_10260();
            String coords = share_x + " " + share_y + " " + share_z;
            try {
                class_310.method_1551().field_1774.method_1455(coords);
                button.method_25355((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.coords_copied"));
                this.shareButtonResetTime = System.currentTimeMillis() + 3000L;
            }
            catch (Exception e) {
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.clipboard_error"), false);
                }
                return;
            }
        }).method_46434(shareButtonX, shareButtonY, shareButtonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.shareCoordsButton);
    }

    private void setupSettingsMenu() {
        this.resetState();
        this.method_25426();
        this.settingsWidgets.clear();
        this.editWidgets.clear();
        int y = 85;
        int fieldWidth = 150;
        int fieldX = this.field_22789 - 170;
        int labelX = this.field_22789 - 300;
        class_4185 visibilityButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)("screen.graphcommands.button.visibility." + (ClientCommandHandler.pointsEnabled ? "off" : "on"))), button -> {
            ClientCommandHandler.setPointsEnabled(!ClientCommandHandler.pointsEnabled);
            button.method_25355((class_2561)class_2561.method_43471((String)("screen.graphcommands.button.visibility." + (ClientCommandHandler.pointsEnabled ? "off" : "on"))));
        }).method_46434(fieldX, y, fieldWidth, 20).method_46431();
        this.method_37063((class_364)visibilityButton);
        this.settingsWidgets.add((class_339)visibilityButton);
        class_4185 textOutlineButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)("screen.graphcommands.button.text_outline." + (ClientCommandHandler.isTextOutlineEnabled() ? "on" : "off"))), button -> {
            ClientCommandHandler.setTextOutlineEnabled(!ClientCommandHandler.isTextOutlineEnabled());
            button.method_25355((class_2561)class_2561.method_43471((String)("screen.graphcommands.button.text_outline." + (ClientCommandHandler.isTextOutlineEnabled() ? "on" : "off"))));
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)textOutlineButton);
        this.settingsWidgets.add((class_339)textOutlineButton);
        class_4185 compassModeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)("screen.graphcommands.button.compass_mode." + (ClientCommandHandler.isCompassModeEnabled() ? "on" : "off"))), button -> {
            ClientCommandHandler.setCompassModeEnabled(!ClientCommandHandler.isCompassModeEnabled());
            button.method_25355((class_2561)class_2561.method_43471((String)("screen.graphcommands.button.compass_mode." + (ClientCommandHandler.isCompassModeEnabled() ? "on" : "off"))));
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.compass_mode.tooltip"))).method_46431();
        this.method_37063((class_364)compassModeButton);
        this.settingsWidgets.add((class_339)compassModeButton);
        class_4185 compassSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.compass_settings"), button -> {
            this.resetState();
            this.method_25426();
            this.setupCompassSettingsMenu();
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)compassSettingsButton);
        this.settingsWidgets.add((class_339)compassSettingsButton);
        class_4185 pointSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.point_settings"), button -> {
            this.resetState();
            this.method_25426();
            this.setupPointSettingsMenu();
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)pointSettingsButton);
        this.settingsWidgets.add((class_339)pointSettingsButton);
        this.isSettingsMenu = true;
    }

    private void setupPointSettingsMenu() {
        this.resetState();
        this.method_25426();
        this.settingsWidgets.clear();
        this.editWidgets.clear();
        int y = 85;
        int fieldWidth = 150;
        int fieldX = this.field_22789 - 170;
        int labelX = this.field_22789 - 300;
        class_357 transparencySlider = new class_357(this, fieldX, y, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(ClientCommandHandler.getGlobalTransparency() * 100.0f) + "%")), ClientCommandHandler.getGlobalTransparency()){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(this.field_22753 * 100.0) + "%")));
            }

            protected void method_25344() {
                ClientCommandHandler.setGlobalTransparency((float)this.field_22753);
            }
        };
        this.method_37063((class_364)transparencySlider);
        this.settingsWidgets.add((class_339)transparencySlider);
        float textScale = ClientCommandHandler.getTextScale();
        float textSliderValue = (textScale - 0.5f) / 0.5f;
        class_357 textScaleSlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(textScale * 100.0f) + "%")), textSliderValue){

            protected void method_25346() {
                float scale = (float)(this.field_22753 * 0.5 + 0.5);
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(scale * 100.0f) + "%")));
            }

            protected void method_25344() {
                float newScale = (float)(this.field_22753 * 0.5 + 0.5);
                ClientCommandHandler.setTextScale(newScale);
            }
        };
        this.method_37063((class_364)textScaleSlider);
        this.settingsWidgets.add((class_339)textScaleSlider);
        float iconScale = ClientCommandHandler.getIconScale();
        float iconSliderValue = (iconScale - 0.5f) / 0.5f;
        class_357 iconScaleSlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(iconScale * 100.0f) + "%")), iconSliderValue){

            protected void method_25346() {
                float scale = (float)(this.field_22753 * 0.5 + 0.5);
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(scale * 100.0f) + "%")));
            }

            protected void method_25344() {
                float newScale = (float)(this.field_22753 * 0.5 + 0.5);
                ClientCommandHandler.setIconScale(newScale);
            }
        };
        this.method_37063((class_364)iconScaleSlider);
        this.settingsWidgets.add((class_339)iconScaleSlider);
        float farFadeDistance = ClientCommandHandler.getFarFadeDistance();
        float farFadeSliderValue = farFadeDistance / 1000.0f;
        class_357 farFadeSlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)(farFadeDistance == 0.0f ? "Disabled" : (int)farFadeDistance + " blocks")), farFadeSliderValue){

            protected void method_25346() {
                int distance = (int)(this.field_22753 * 1000.0);
                if (distance < 50) {
                    distance = 0;
                }
                this.method_25355((class_2561)class_2561.method_43470((String)(distance == 0 ? "Disabled" : distance + " blocks")));
            }

            protected void method_25344() {
                int distance = (int)(this.field_22753 * 1000.0);
                if (distance < 50) {
                    distance = 0;
                }
                ClientCommandHandler.setFarFadeDistance(distance);
            }
        };
        this.method_37063((class_364)farFadeSlider);
        this.settingsWidgets.add((class_339)farFadeSlider);
        float nearFadeDistance = ClientCommandHandler.getNearFadeDistance();
        float nearFadeSliderValue = (nearFadeDistance - 3.0f) / 12.0f;
        class_357 nearFadeSlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)nearFadeDistance + " blocks")), nearFadeSliderValue){

            protected void method_25346() {
                int distance = 3 + (int)(this.field_22753 * 12.0);
                this.method_25355((class_2561)class_2561.method_43470((String)(distance + " blocks")));
            }

            protected void method_25344() {
                int distance = 3 + (int)(this.field_22753 * 12.0);
                ClientCommandHandler.setNearFadeDistance(distance);
            }
        };
        this.method_37063((class_364)nearFadeSlider);
        this.settingsWidgets.add((class_339)nearFadeSlider);
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.back"), button -> {
            this.resetState();
            this.method_25426();
            this.setupSettingsMenu();
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)backButton);
        this.settingsWidgets.add((class_339)backButton);
        this.isPointSettingsMenu = true;
    }

    private void setupCompassSettingsMenu() {
        this.resetState();
        this.method_25426();
        this.settingsWidgets.clear();
        this.editWidgets.clear();
        int y = 85;
        int fieldWidth = 150;
        int fieldX = this.field_22789 - 170;
        int labelX = this.field_22789 - 300;
        float animationDuration = ClientCommandHandler.getCompassAnimationDuration();
        float durationSliderValue = (animationDuration - 50.0f) / 450.0f;
        class_357 durationSlider = new class_357(this, fieldX, y, fieldWidth, 20, (class_2561)class_2561.method_43470((String)("" + (int)animationDuration)), durationSliderValue){

            protected void method_25346() {
                int duration = 50 + (int)(this.field_22753 * 450.0);
                duration = duration / 50 * 50;
                this.method_25355((class_2561)class_2561.method_43470((String)("" + duration)));
            }

            protected void method_25344() {
                int duration = 50 + (int)(this.field_22753 * 450.0);
                duration = duration / 50 * 50;
                ClientCommandHandler.setCompassAnimationDuration(duration);
            }
        };
        this.method_37063((class_364)durationSlider);
        this.settingsWidgets.add((class_339)durationSlider);
        float barTransparency = ClientCommandHandler.getCompassBarTransparency();
        float barTransparencySliderValue = (barTransparency - 0.5f) / 0.5f;
        class_357 barTransparencySlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(barTransparency * 100.0f) + "%")), barTransparencySliderValue){

            protected void method_25346() {
                float transparency = (float)(this.field_22753 * 0.5 + 0.5);
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(transparency * 100.0f) + "%")));
            }

            protected void method_25344() {
                float transparency = (float)(this.field_22753 * 0.5 + 0.5);
                ClientCommandHandler.setCompassBarTransparency(transparency);
            }
        };
        this.method_37063((class_364)barTransparencySlider);
        this.settingsWidgets.add((class_339)barTransparencySlider);
        float pointsTransparency = ClientCommandHandler.getCompassPointsTransparency();
        float pointsTransparencySliderValue = (pointsTransparency - 0.5f) / 0.5f;
        class_357 pointsTransparencySlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(pointsTransparency * 100.0f) + "%")), pointsTransparencySliderValue){

            protected void method_25346() {
                float transparency = (float)(this.field_22753 * 0.5 + 0.5);
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(transparency * 100.0f) + "%")));
            }

            protected void method_25344() {
                float transparency = (float)(this.field_22753 * 0.5 + 0.5);
                ClientCommandHandler.setCompassPointsTransparency(transparency);
            }
        };
        this.method_37063((class_364)pointsTransparencySlider);
        this.settingsWidgets.add((class_339)pointsTransparencySlider);
        float barHeight = ClientCommandHandler.getCompassBarHeight();
        float barHeightSliderValue = (barHeight - 2.0f) / 3.0f;
        class_357 barHeightSlider = new class_357(this, fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)("" + (int)barHeight)), barHeightSliderValue){

            protected void method_25346() {
                int height = 2 + (int)(this.field_22753 * 3.0);
                this.method_25355((class_2561)class_2561.method_43470((String)("" + height)));
            }

            protected void method_25344() {
                float height = 2.0f + (float)(this.field_22753 * 3.0);
                ClientCommandHandler.setCompassBarHeight(height);
            }
        };
        this.method_37063((class_364)barHeightSlider);
        this.settingsWidgets.add((class_339)barHeightSlider);
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.back"), button -> {
            this.resetState();
            this.method_25426();
            this.setupSettingsMenu();
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)backButton);
        this.settingsWidgets.add((class_339)backButton);
        this.isCompassSettingsMenu = true;
    }

    private void setupEditForm(final ClientCommandHandler.Point point, int index) {
        this.resetState();
        this.method_25426();
        this.settingsWidgets.clear();
        this.editWidgets.clear();
        int y = 85;
        int fieldWidth = 150;
        int fieldX = this.field_22789 - 170;
        class_342 nameFieldWidget = new class_342(this.field_22793, fieldX, y, fieldWidth, 20, class_2561.method_30163((String)point.name())){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(point.name());
                PointManagerScreen.this.nameField = this;
            }
        };
        this.method_37063((class_364)nameFieldWidget);
        this.editWidgets.add((class_339)nameFieldWidget);
        class_342 xFieldWidget = new class_342(this.field_22793, fieldX, y += 25, fieldWidth, 20, class_2561.method_30163((String)String.valueOf(point.x()))){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(String.valueOf(point.x()));
                PointManagerScreen.this.xField = this;
            }
        };
        this.method_37063((class_364)xFieldWidget);
        this.editWidgets.add((class_339)xFieldWidget);
        class_342 yFieldWidget = new class_342(this.field_22793, fieldX, y += 25, fieldWidth, 20, class_2561.method_30163((String)String.valueOf(point.y()))){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(String.valueOf(point.y()));
                PointManagerScreen.this.yField = this;
            }
        };
        this.method_37063((class_364)yFieldWidget);
        this.editWidgets.add((class_339)yFieldWidget);
        class_342 zFieldWidget = new class_342(this.field_22793, fieldX, y += 25, fieldWidth, 20, class_2561.method_30163((String)String.valueOf(point.z()))){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(String.valueOf(point.z()));
                PointManagerScreen.this.zField = this;
            }
        };
        this.method_37063((class_364)zFieldWidget);
        this.editWidgets.add((class_339)zFieldWidget);
        this.transparencyValue = point.transparency();
        this.transparencySlider = new class_357(fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(this.transparencyValue * 100.0f) + "%")), this.transparencyValue){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(this.field_22753 * 100.0) + "%")));
            }

            protected void method_25344() {
                PointManagerScreen.this.transparencyValue = (float)this.field_22753;
            }
        };
        this.method_37063((class_364)this.transparencySlider);
        this.editWidgets.add((class_339)this.transparencySlider);
        this.currentColorIndex = this.getColorIndex(point.color());
        this.colorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)ClientCommandHandler.COLORS[this.currentColorIndex]).method_27694(style -> style.method_36139(point.color())), button -> {
            this.currentColorIndex = (this.currentColorIndex + 1) % ClientCommandHandler.COLORS.length;
            String newColorName = ClientCommandHandler.COLORS[this.currentColorIndex];
            int newColor = ClientCommandHandler.Point.fromName(newColorName);
            button.method_25355((class_2561)class_2561.method_43470((String)newColorName).method_27694(style -> style.method_36139(newColor)));
        }).method_46434(fieldX, y += 25, fieldWidth - 50, 20).method_46431();
        this.method_37063((class_364)this.colorButton);
        this.editWidgets.add((class_339)this.colorButton);
        this.currentIconIndex = this.getIconIndex(point.icon());
        this.iconButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)(point.icon().equals("default") ? "\u2666" : point.icon())), button -> {
            this.currentIconIndex = (this.currentIconIndex + 1) % ClientCommandHandler.ICONS.length;
            String newIcon = ClientCommandHandler.ICONS[this.currentIconIndex];
            button.method_25355(class_2561.method_30163((String)(newIcon.equals("default") ? "\u2666" : newIcon)));
        }).method_46434(fieldX + fieldWidth - 40, y, 40, 20).method_46431();
        this.method_37063((class_364)this.iconButton);
        this.editWidgets.add((class_339)this.iconButton);
        class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.save_changes"), button -> {
            block3: {
                try {
                    String newName = this.nameField.method_1882();
                    int newX = Integer.parseInt(this.xField.method_1882());
                    int newY = Integer.parseInt(this.yField.method_1882());
                    int newZ = Integer.parseInt(this.zField.method_1882());
                    float newTransparency = this.transparencyValue;
                    String colorName = ClientCommandHandler.COLORS[this.currentColorIndex];
                    int newColor = ClientCommandHandler.Point.fromName(colorName);
                    String newIcon = ClientCommandHandler.ICONS[this.currentIconIndex];
                    String serverId = this.field_22787 != null ? ClientCommandHandler.getServerId(this.field_22787) : "unknown";
                    List<ClientCommandHandler.Point> pointsInDimension = ClientCommandHandler.getPointsForDimension(this.selectedDimension);
                    if (this.selectedPointIndex >= 0 && this.selectedPointIndex < pointsInDimension.size()) {
                        pointsInDimension.set(this.selectedPointIndex, new ClientCommandHandler.Point(newX, newY, newZ, newColor, newName, newTransparency, serverId, point.visible(), newIcon));
                        ClientCommandHandler.setPointsForDimension(this.selectedDimension, pointsInDimension);
                        ClientCommandHandler.savePointsToFile(this.selectedDimension, serverId);
                        this.resetState();
                        this.updatePointsList();
                        this.method_25426();
                    }
                }
                catch (NumberFormatException e) {
                    if (this.field_22787 == null || this.field_22787.field_1724 == null) break block3;
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.invalid_input"), false);
                }
            }
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)saveButton);
        this.editWidgets.add((class_339)saveButton);
        this.selectedPointIndex = index;
    }

    private void setupCreateForm() {
        String defaultZ;
        String defaultY;
        String defaultX;
        this.resetState();
        this.method_25426();
        this.settingsWidgets.clear();
        this.editWidgets.clear();
        int y = 85;
        int fieldWidth = 150;
        int fieldX = this.field_22789 - 170;
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            defaultX = String.valueOf((int)Math.floor(this.field_22787.field_1724.method_23317()));
            defaultY = String.valueOf((int)Math.floor(this.field_22787.field_1724.method_23318()));
            defaultZ = String.valueOf((int)Math.floor(this.field_22787.field_1724.method_23321()));
        } else {
            defaultX = "0";
            defaultY = "0";
            defaultZ = "0";
        }
        this.nameField = new class_342(this.field_22787.field_1772, fieldX, y, fieldWidth, 20, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.name"));
        this.nameField.method_1880(32);
        this.nameField.method_1852(class_2561.method_43471((String)"screen.graphcommands.default_point_name").getString());
        this.method_37063((class_364)this.nameField);
        this.editWidgets.add((class_339)this.nameField);
        class_342 xFieldWidget = new class_342(this.field_22793, fieldX, y += 25, fieldWidth, 20, class_2561.method_30163((String)defaultX)){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(defaultX);
                PointManagerScreen.this.xField = this;
            }
        };
        this.method_37063((class_364)xFieldWidget);
        this.editWidgets.add((class_339)xFieldWidget);
        class_342 yFieldWidget = new class_342(this.field_22793, fieldX, y += 25, fieldWidth, 20, class_2561.method_30163((String)defaultY)){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(defaultY);
                PointManagerScreen.this.yField = this;
            }
        };
        this.method_37063((class_364)yFieldWidget);
        this.editWidgets.add((class_339)yFieldWidget);
        class_342 zFieldWidget = new class_342(this.field_22793, fieldX, y += 25, fieldWidth, 20, class_2561.method_30163((String)defaultZ)){
            {
                super(textRenderer, i, j, k, l, text);
                this.method_1852(defaultZ);
                PointManagerScreen.this.zField = this;
            }
        };
        this.method_37063((class_364)zFieldWidget);
        this.editWidgets.add((class_339)zFieldWidget);
        this.transparencyValue = 1.0f;
        this.transparencySlider = new class_357(fieldX, y += 25, fieldWidth, 20, (class_2561)class_2561.method_43470((String)((int)(this.transparencyValue * 100.0f) + "%")), this.transparencyValue){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(this.field_22753 * 100.0) + "%")));
            }

            protected void method_25344() {
                PointManagerScreen.this.transparencyValue = (float)this.field_22753;
            }
        };
        this.method_37063((class_364)this.transparencySlider);
        this.editWidgets.add((class_339)this.transparencySlider);
        this.currentColorIndex = 0;
        this.colorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)ClientCommandHandler.COLORS[this.currentColorIndex]).method_27694(style -> style.method_36139(ClientCommandHandler.Point.fromName(ClientCommandHandler.COLORS[this.currentColorIndex]))), button -> {
            this.currentColorIndex = (this.currentColorIndex + 1) % ClientCommandHandler.COLORS.length;
            String newColorName = ClientCommandHandler.COLORS[this.currentColorIndex];
            int newColor = ClientCommandHandler.Point.fromName(newColorName);
            button.method_25355((class_2561)class_2561.method_43470((String)newColorName).method_27694(style -> style.method_36139(newColor)));
        }).method_46434(fieldX, y += 25, fieldWidth - 50, 20).method_46431();
        this.method_37063((class_364)this.colorButton);
        this.editWidgets.add((class_339)this.colorButton);
        this.currentIconIndex = 0;
        this.iconButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)(ClientCommandHandler.ICONS[this.currentIconIndex].equals("default") ? "\u2666" : ClientCommandHandler.ICONS[this.currentIconIndex])), button -> {
            this.currentIconIndex = (this.currentIconIndex + 1) % ClientCommandHandler.ICONS.length;
            String newIcon = ClientCommandHandler.ICONS[this.currentIconIndex];
            button.method_25355(class_2561.method_30163((String)(newIcon.equals("default") ? "\u2666" : newIcon)));
        }).method_46434(fieldX + fieldWidth - 40, y, 40, 20).method_46431();
        this.method_37063((class_364)this.iconButton);
        this.editWidgets.add((class_339)this.iconButton);
        class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.create_point_action"), button -> {
            block2: {
                try {
                    String newName = this.nameField.method_1882();
                    int newX = Integer.parseInt(this.xField.method_1882());
                    int newY = Integer.parseInt(this.yField.method_1882());
                    int newZ = Integer.parseInt(this.zField.method_1882());
                    float newTransparency = this.transparencyValue;
                    String colorName = ClientCommandHandler.COLORS[this.currentColorIndex];
                    int newColor = ClientCommandHandler.Point.fromName(colorName);
                    String newIcon = ClientCommandHandler.ICONS[this.currentIconIndex];
                    String serverId = this.field_22787 != null ? ClientCommandHandler.getServerId(this.field_22787) : "unknown";
                    List<ClientCommandHandler.Point> pointsInDimension = ClientCommandHandler.getPointsForDimension(this.selectedDimension);
                    pointsInDimension.add(new ClientCommandHandler.Point(newX, newY, newZ, newColor, newName, newTransparency, serverId, true, newIcon));
                    ClientCommandHandler.setPointsForDimension(this.selectedDimension, pointsInDimension);
                    ClientCommandHandler.savePointsToFile(this.selectedDimension, serverId);
                    this.resetState();
                    this.updatePointsList();
                    this.method_25426();
                }
                catch (NumberFormatException e) {
                    if (this.field_22787 == null || this.field_22787.field_1724 == null) break block2;
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screen.graphcommands.message.invalid_input"), false);
                }
            }
        }).method_46434(fieldX, y += 25, fieldWidth, 20).method_46431();
        this.method_37063((class_364)saveButton);
        this.editWidgets.add((class_339)saveButton);
        this.isCreatingNewPoint = true;
    }

    private int getColorIndex(int color) {
        for (int i = 0; i < ClientCommandHandler.COLORS.length; ++i) {
            if (ClientCommandHandler.Point.fromName(ClientCommandHandler.COLORS[i]) != color) continue;
            return i;
        }
        return 0;
    }

    private int getIconIndex(String icon) {
        for (int i = 0; i < ClientCommandHandler.ICONS.length; ++i) {
            if (!ClientCommandHandler.ICONS[i].equals(icon)) continue;
            return i;
        }
        return 0;
    }

    private void drawTextWithOutline(class_332 context, class_2561 text, int x, int y) {
        if (this.field_22793 == null) {
            if (this.field_22787 != null) {
                this.field_22793 = this.field_22787.field_1772;
            } else {
                return;
            }
        }
        try {
            int outlineColor = -16769993;
            context.method_51439(this.field_22793, text, x - 1, y, outlineColor, false);
            context.method_51439(this.field_22793, text, x + 1, y, outlineColor, false);
            context.method_51439(this.field_22793, text, x, y - 1, outlineColor, false);
            context.method_51439(this.field_22793, text, x, y + 1, outlineColor, false);
            context.method_51439(this.field_22793, text, x - 1, y - 1, outlineColor, false);
            context.method_51439(this.field_22793, text, x + 1, y - 1, outlineColor, false);
            context.method_51439(this.field_22793, text, x - 1, y + 1, outlineColor, false);
            context.method_51439(this.field_22793, text, x + 1, y + 1, outlineColor, false);
            context.method_51439(this.field_22793, text, x, y, -1, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22793 == null) {
            this.field_22793 = this.field_22787 != null ? this.field_22787.field_1772 : class_310.method_1551().field_1772;
        }
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        if (this.shareButtonResetTime != -1L && System.currentTimeMillis() >= this.shareButtonResetTime) {
            this.shareCoordsButton.method_25355((class_2561)class_2561.method_43471((String)"screen.graphcommands.button.share_coords"));
            this.shareButtonResetTime = -1L;
        }
        if (this.isSettingsMenu || this.isCompassSettingsMenu || this.isPointSettingsMenu || this.isCreatingNewPoint || this.selectedPointIndex >= 0) {
            int backgroundX = this.field_22789 - 310;
            int backgroundY = 80;
            int backgroundWidth = 297;
            int backgroundHeight = this.isSettingsMenu ? 135 : (this.isCompassSettingsMenu ? 135 : (this.isPointSettingsMenu ? 160 : 180));
            int panelColor = 0x50000000;
            context.method_25294(backgroundX - 10, backgroundY - 5, backgroundX + backgroundWidth + 10, backgroundY + backgroundHeight + 5, panelColor);
            class_5250 categoryTitle = null;
            if (this.isSettingsMenu) {
                categoryTitle = class_2561.method_43471((String)"screen.graphcommands.category.settings");
            } else if (this.isCompassSettingsMenu) {
                categoryTitle = class_2561.method_43471((String)"screen.graphcommands.category.compass_settings");
            } else if (this.isPointSettingsMenu) {
                categoryTitle = class_2561.method_43471((String)"screen.graphcommands.category.point_settings");
            } else if (this.isCreatingNewPoint) {
                categoryTitle = class_2561.method_43471((String)"screen.graphcommands.category.create_point");
            } else if (this.selectedPointIndex >= 0) {
                categoryTitle = class_2561.method_43471((String)"screen.graphcommands.category.edit_point");
            }
            if (categoryTitle != null) {
                Matrix3x2fStack matrices = context.method_51448();
                matrices.pushMatrix();
                matrices.translate((float)(this.field_22789 - 310), 65.0f);
                matrices.scale(1.4f, 1.4f);
                int outlineColor = -16769993;
                context.method_51439(this.field_22793, (class_2561)categoryTitle, -1, -1, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, 1, -1, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, -1, 1, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, 1, 1, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, 0, -1, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, 0, 1, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, -1, 0, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, 1, 0, outlineColor, false);
                context.method_51439(this.field_22793, (class_2561)categoryTitle, 0, 0, -1, false);
                matrices.popMatrix();
            }
        }
        int labelX = this.field_22789 - 300;
        int y = 90;
        if (this.isSettingsMenu) {
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.hide_points"), labelX, y);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.text_outline"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.compass_mode"), labelX, y += 25);
        } else if (this.isCompassSettingsMenu) {
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.compass_animation_duration"), labelX, y);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.compass_bar_transparency"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.compass_points_transparency"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.compass_bar_height"), labelX, y += 25);
        } else if (this.isPointSettingsMenu) {
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.point_transparency"), labelX, y);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.text_size"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.icon_size"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.far_fade_distance"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.near_fade_distance"), labelX, y += 25);
        } else if (this.isCreatingNewPoint || this.selectedPointIndex >= 0) {
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.name"), labelX, y);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.x"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.y"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.z"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.point_transparency"), labelX, y += 25);
            this.drawTextWithOutline(context, (class_2561)class_2561.method_43471((String)"screen.graphcommands.label.color_and_icon"), labelX, y += 25);
        }
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)(this.field_22789 / 2), 10.0f);
        matrices.scale(1.5f, 1.5f);
        int outlineColor = -16769993;
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2, 1, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2, -1, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2 + 1, 0, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2 - 1, 0, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2 + 1, 1, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2 + 1, -1, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2 - 1, -1, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2 - 1, 1, outlineColor, false);
        context.method_51439(this.field_22793, this.field_22785, -titleWidth / 2, 0, -1, false);
        matrices.popMatrix();
        int totalPages = (int)Math.ceil((double)this.points.size() / (double)this.pointsPerPage);
        String pageText = String.format(" %d/%d", this.currentPage + 1, Math.max(1, totalPages));
        this.drawTextWithOutline(context, (class_2561)class_2561.method_43470((String)pageText), 130, this.field_22790 - 25);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private /* synthetic */ void lambda$init$11(class_4185 button) {
        this.resetState();
        ++this.currentPage;
        this.method_25426();
    }

    private /* synthetic */ void lambda$init$10(class_4185 button) {
        this.resetState();
        --this.currentPage;
        this.method_25426();
    }

    private /* synthetic */ void lambda$init$3(class_4185 button) {
        this.resetState();
        this.selectedDimension = class_1937.field_25181;
        this.currentPage = 0;
        this.updatePointsList();
        this.method_25426();
    }

    private /* synthetic */ void lambda$init$2(class_4185 button) {
        this.resetState();
        this.selectedDimension = class_1937.field_25180;
        this.currentPage = 0;
        this.updatePointsList();
        this.method_25426();
    }

    private /* synthetic */ void lambda$init$1(class_4185 button) {
        this.resetState();
        this.selectedDimension = class_1937.field_25179;
        this.currentPage = 0;
        this.updatePointsList();
        this.method_25426();
    }
}

