/*
 * Decompiled with CFR 0.152.
 */
package com.example.graphcommands;

import com.example.graphcommands.mixin.BossBarHudAccessor;
import com.example.graphcommands.mixin.GameRendererAccessor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_642;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ClientCommandHandler {
    private static final Map<class_5321<class_1937>, List<Point>> pointsByDimension = new HashMap<class_5321<class_1937>, List<Point>>();
    public static boolean pointsEnabled = true;
    public static boolean compassModeEnabled = false;
    private static float globalTransparency = 1.0f;
    private static float textScale = 0.8f;
    private static float iconScale = 0.66f;
    private static float offsetX = 0.0f;
    private static float offsetY = 0.0f;
    private static float scaleX = 1.0f;
    private static float scaleY = 1.0f;
    private static boolean textOutlineEnabled = true;
    private static float compassAnimationDuration = 150.0f;
    private static float compassBarTransparency = 0.5f;
    private static float compassPointsTransparency = 0.9f;
    private static float compassBarHeight = 3.0f;
    private static float farFadeDistance = 0.0f;
    private static float nearFadeDistance = 10.0f;
    private static final int CURRENT_SETTINGS_VERSION = 5;
    private static final Map<Point, PointRenderCache> renderCache = new HashMap<Point, PointRenderCache>();
    private static final long TEXT_UPDATE_INTERVAL = 500L;
    private static final List<CompassPointData> compassPoints = new ArrayList<CompassPointData>();
    private static final float FOV_THRESHOLD = (float)Math.toRadians(45.0);
    private static float barAlpha = 0.0f;
    private static long barAnimationStartTime = System.currentTimeMillis();
    private static float barStartAlpha = 0.0f;
    private static float lastTargetBarAlpha = 0.0f;
    public static final String[] COLORS = new String[]{"white", "yellow", "gold", "aqua", "light_purple", "red", "green", "blue", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gray", "dark_gray", "black"};
    public static final String[] ICONS = new String[]{"default", "\ud83e\ude93", "\u26cf", "\ud83d\udde1", "\ud83c\udff9", "\u2b50", "\ud83d\udd25", "\u26a1", "\ud83c\udf0c", "\u25c6", "\u23fa", "\u2764", "\u23f3", "\u2302", "\u2604"};

    private ClientCommandHandler() {
        throw new AssertionError((Object)"Utility class - cannot be instantiated");
    }

    public static void renderPoints(class_332 drawContext) {
        if (!pointsEnabled || compassModeEnabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || client.field_1773 == null || client.field_1773.method_19418() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        client.field_1773.method_19418().method_19321((class_1922)client.field_1687, (class_1297)client.field_1724, !client.field_1690.method_31044().method_31034(), client.field_1690.method_31044().method_31035(), client.method_61966().method_60637(false));
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        Quaternionf cameraRotation = client.field_1773.method_19418().method_23767();
        class_5321 dimension = client.field_1687.method_27983();
        List points = pointsByDimension.getOrDefault(dimension, new ArrayList());
        String currentServerId = ClientCommandHandler.getServerId(client);
        class_4587 matrixStack = drawContext.method_51448();
        long currentTime = System.currentTimeMillis();
        for (Point point : points) {
            class_2561 displayText;
            float alphaFactor;
            class_243 screenPos;
            double dz;
            double dy;
            double dx;
            double distance;
            if (!point.visible() || point.serverId() != null && !point.serverId().equals(currentServerId) || (distance = Math.sqrt((dx = (double)point.x() + 0.5 - cameraPos.field_1352) * dx + (dy = (double)point.y() + 0.5 - cameraPos.field_1351) * dy + (dz = (double)point.z() + 0.5 - cameraPos.field_1350) * dz)) < 1.0) continue;
            float farFadeMultiplier = 1.0f;
            if (farFadeDistance > 0.0f) {
                if (distance > (double)(farFadeDistance + 10.0f)) {
                    farFadeMultiplier = 0.0f;
                } else if (distance > (double)farFadeDistance) {
                    farFadeMultiplier = (farFadeDistance + 10.0f - (float)distance) / 10.0f;
                }
            }
            float nearFadeMultiplier = 1.0f;
            if (distance < (double)nearFadeDistance) {
                nearFadeMultiplier = 0.3f + 0.7f * ((float)distance / nearFadeDistance);
                float minTransparency = point.transparency() * globalTransparency * farFadeMultiplier * 0.3f;
                nearFadeMultiplier = Math.max(nearFadeMultiplier, minTransparency);
            }
            if (farFadeMultiplier * nearFadeMultiplier < 0.01f) continue;
            PointRenderCache cache = renderCache.get(point);
            boolean shouldUpdateText = cache == null || currentTime - cache.lastTextUpdateTime >= 500L;
            boolean shouldUpdateProjection = true;
            if (shouldUpdateProjection) {
                screenPos = ClientCommandHandler.projectToScreen(dx, dy, dz, client, cameraPos);
                if (screenPos == null) {
                    renderCache.remove(point);
                    continue;
                }
                alphaFactor = (float)screenPos.field_1350;
            } else {
                screenPos = cache.screenPos;
                alphaFactor = cache.alphaFactor;
            }
            if ((alphaFactor *= farFadeMultiplier * nearFadeMultiplier) <= 0.01f) continue;
            float screenX = (float)screenPos.field_1352;
            float screenY = (float)screenPos.field_1351;
            screenX = screenX * scaleX + offsetX;
            screenY = screenY * scaleY + offsetY;
            if (screenX < 0.0f || screenX > (float)screenWidth || screenY < 0.0f || screenY > (float)screenHeight) continue;
            if (shouldUpdateText) {
                int roundedDistance = (int)Math.floor(distance);
                String blocksTranslation = class_2561.method_43471((String)"screen.graphcommands.blocks").getString();
                String distanceString = "(" + roundedDistance + " " + blocksTranslation + ")";
                class_5250 distanceText = class_2561.method_43470((String)distanceString);
                displayText = class_2561.method_43470((String)point.name()).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)distanceText);
            } else {
                displayText = cache.displayText;
            }
            renderCache.put(point, new PointRenderCache(displayText, shouldUpdateText ? currentTime : cache.lastTextUpdateTime, screenPos, alphaFactor, cameraPos, cameraRotation));
            int color = point.color();
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int alpha = (int)(alphaFactor * globalTransparency * point.transparency() * 255.0f);
            alpha = Math.max(10, alpha);
            int argbColor = alpha << 24 | red << 16 | green << 8 | blue;
            String iconToRender = point.icon().equals("default") ? "\u2666" : point.icon();
            float iconScaleAdjusted = iconScale * 1.5f;
            float rawIconWidth = client.field_1772.method_1727(iconToRender);
            float scaledWidth = rawIconWidth * iconScaleAdjusted;
            float iconHeight = 8.0f;
            float scaledHeight = iconHeight * iconScaleAdjusted;
            float iconX = screenX - scaledWidth / 2.0f;
            float iconY = screenY - scaledHeight / 2.0f;
            matrixStack.method_22903();
            matrixStack.method_46416(iconX, iconY, 0.0f);
            matrixStack.method_22905(iconScaleAdjusted, iconScaleAdjusted, 1.0f);
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)iconToRender), 0, 0, argbColor, false);
            matrixStack.method_22909();
            matrixStack.method_22903();
            matrixStack.method_46416(screenX, screenY, 0.0f);
            String[] lines = displayText.getString().split("\n");
            float textY = scaledHeight / 2.0f + 2.0f;
            for (String line : lines) {
                int textWidth = client.field_1772.method_1727(line);
                float textX = -((float)textWidth) / 2.0f;
                if (textOutlineEnabled) {
                    int outlineAlpha = (int)(alphaFactor * globalTransparency * point.transparency() * 0.7f * 255.0f);
                    outlineAlpha = Math.max(10, outlineAlpha);
                    int outlineColor = outlineAlpha << 24 | 0;
                    float baseOutlineOffset = 0.8f;
                    float outlineOffset = baseOutlineOffset * textScale;
                    matrixStack.method_22903();
                    matrixStack.method_46416(textX * textScale - outlineOffset, textY, 0.0f);
                    matrixStack.method_22905(textScale, textScale, 1.0f);
                    drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)line), 0, 0, outlineColor, false);
                    matrixStack.method_22909();
                    matrixStack.method_22903();
                    matrixStack.method_46416(textX * textScale + outlineOffset, textY, 0.0f);
                    matrixStack.method_22905(textScale, textScale, 1.0f);
                    drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)line), 0, 0, outlineColor, false);
                    matrixStack.method_22909();
                    matrixStack.method_22903();
                    matrixStack.method_46416(textX * textScale, textY - outlineOffset, 0.0f);
                    matrixStack.method_22905(textScale, textScale, 1.0f);
                    drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)line), 0, 0, outlineColor, false);
                    matrixStack.method_22909();
                    matrixStack.method_22903();
                    matrixStack.method_46416(textX * textScale, textY + outlineOffset, 0.0f);
                    matrixStack.method_22905(textScale, textScale, 1.0f);
                    drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)line), 0, 0, outlineColor, false);
                    matrixStack.method_22909();
                }
                matrixStack.method_22903();
                matrixStack.method_46416(textX * textScale, textY, 0.0f);
                matrixStack.method_22905(textScale, textScale, 1.0f);
                drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)line), 0, 0, argbColor, false);
                matrixStack.method_22909();
                textY += 10.0f * textScale;
            }
            matrixStack.method_22909();
        }
    }

    public static void renderCompassBar(class_332 drawContext, float tickDelta) {
        float targetBarAlpha;
        if (!compassModeEnabled || !pointsEnabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || client.field_1773 == null || client.field_1773.method_19418() == null) {
            return;
        }
        class_337 bossBarHud = client.field_1705.method_1740();
        boolean isBossBarVisible = bossBarHud != null && !((BossBarHudAccessor)bossBarHud).getBossBars().isEmpty();
        class_5321 dimension = client.field_1687.method_27983();
        List points = pointsByDimension.getOrDefault(dimension, new ArrayList());
        String currentServerId = ClientCommandHandler.getServerId(client);
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        Quaternionf cameraRotation = client.field_1773.method_19418().method_23767();
        Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)cameraRotation);
        class_243 forwardVec = new class_243((double)forward.x(), 0.0, (double)forward.z()).method_1029();
        ArrayList<CompassPointData> newCompassPoints = new ArrayList<CompassPointData>();
        boolean hasVisiblePoints = false;
        long currentTime = System.currentTimeMillis();
        for (Point point : points) {
            float lastTargetAlpha;
            if (!point.visible() || point.serverId() != null && !point.serverId().equals(currentServerId)) continue;
            double dx = (double)point.x() + 0.5 - cameraPos.field_1352;
            double dy = (double)point.y() + 0.5 - cameraPos.field_1351;
            double dz = (double)point.z() + 0.5 - cameraPos.field_1350;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            class_243 directionToPoint = new class_243((double)point.x() + 0.5 - cameraPos.field_1352, 0.0, (double)point.z() + 0.5 - cameraPos.field_1350).method_1029();
            double dot = directionToPoint.method_1026(forwardVec);
            double angle = Math.acos(class_3532.method_15350((double)dot, (double)-1.0, (double)1.0));
            class_243 cross = forwardVec.method_1036(directionToPoint);
            if (cross.field_1351 < 0.0) {
                angle = -angle;
            }
            boolean isInFov = Math.abs(angle) <= (double)FOV_THRESHOLD;
            float targetAlpha = isInFov ? 1.0f : 0.0f;
            CompassPointData existingData = compassPoints.stream().filter(data -> data.point.equals(point)).findFirst().orElse(null);
            float alpha = existingData != null ? existingData.alpha : 0.0f;
            long animationStartTime = existingData != null ? existingData.animationStartTime : currentTime;
            float startAlpha = existingData != null ? existingData.startAlpha : alpha;
            float f = lastTargetAlpha = existingData != null ? existingData.lastTargetAlpha : targetAlpha;
            if (targetAlpha != lastTargetAlpha) {
                animationStartTime = currentTime;
                startAlpha = alpha;
            }
            float elapsedTime = currentTime - animationStartTime;
            float progress = class_3532.method_15363((float)(elapsedTime / compassAnimationDuration), (float)0.0f, (float)1.0f);
            alpha = startAlpha + (targetAlpha - startAlpha) * progress;
            if (!isInFov && !(alpha > 0.01f)) continue;
            newCompassPoints.add(new CompassPointData(point, angle, alpha, animationStartTime, startAlpha, targetAlpha));
            if (!isInFov) continue;
            hasVisiblePoints = true;
        }
        compassPoints.clear();
        compassPoints.addAll(newCompassPoints);
        float f = targetBarAlpha = hasVisiblePoints && !isBossBarVisible ? 1.0f : 0.0f;
        if (targetBarAlpha != lastTargetBarAlpha) {
            barAnimationStartTime = currentTime;
            barStartAlpha = barAlpha;
        }
        lastTargetBarAlpha = targetBarAlpha;
        float elapsedTime = currentTime - barAnimationStartTime;
        float progress = class_3532.method_15363((float)(elapsedTime / compassAnimationDuration), (float)0.0f, (float)1.0f);
        barAlpha = barStartAlpha + (targetBarAlpha - barStartAlpha) * progress;
        if (barAlpha < 0.01f) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int barWidth = 230;
        int barHeight = (int)compassBarHeight;
        int barX = (screenWidth - barWidth) / 2;
        int barY = 10;
        int barColor = 0x808080;
        int barAlphaInt = (int)(barAlpha * compassBarTransparency * 255.0f);
        barColor = barAlphaInt << 24 | barColor & 0xFFFFFF;
        drawContext.method_25294(barX, barY, barX + barWidth, barY + barHeight, barColor);
        CompassPointData closestPoint = null;
        double minAngle = Double.MAX_VALUE;
        for (CompassPointData compassPointData : compassPoints) {
            if (!(Math.abs(compassPointData.angle) < minAngle)) continue;
            minAngle = Math.abs(compassPointData.angle);
            closestPoint = compassPointData;
        }
        class_4587 matrixStack = drawContext.method_51448();
        for (CompassPointData data3 : compassPoints) {
            if (data3 == closestPoint) continue;
            Point point = data3.point;
            double angle = data3.angle;
            float alpha = data3.alpha;
            if (alpha < 0.01f) continue;
            float position = (float)(((double)FOV_THRESHOLD - angle) / (double)(2.0f * FOV_THRESHOLD)) * (float)barWidth;
            position = class_3532.method_15363((float)position, (float)0.0f, (float)barWidth);
            String iconToRender = point.icon().equals("default") ? "\u2666" : point.icon();
            float iconScaleAdjusted = 1.5f;
            float rawIconWidth = client.field_1772.method_1727(iconToRender);
            float scaledWidth = rawIconWidth * iconScaleAdjusted;
            int iconX = barX + (int)position - (int)(scaledWidth / 2.0f);
            iconX = class_3532.method_15340((int)iconX, (int)barX, (int)(barX + barWidth - (int)scaledWidth));
            int color = point.color();
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int alphaInt = (int)(alpha * barAlpha * compassPointsTransparency * 255.0f);
            int argbColor = alphaInt << 24 | red << 16 | green << 8 | blue;
            int iconY = barY + (barHeight - (int)(6.0f * iconScaleAdjusted)) / 2 - 1;
            if (alphaInt <= 5) continue;
            matrixStack.method_22903();
            float iconHeight = 8.0f;
            float scaledHeight = iconHeight * iconScaleAdjusted;
            int adjustedIconX = iconX;
            int adjustedIconY = iconY;
            matrixStack.method_46416((float)adjustedIconX, (float)adjustedIconY, 0.0f);
            matrixStack.method_22905(iconScaleAdjusted, iconScaleAdjusted, 1.0f);
            drawContext.method_51433(client.field_1772, iconToRender, 0, 0, argbColor, false);
            matrixStack.method_22909();
        }
        if (closestPoint != null) {
            Point point = closestPoint.point;
            double angle = closestPoint.angle;
            float alpha = closestPoint.alpha;
            if (alpha >= 0.01f) {
                float position = (float)(((double)FOV_THRESHOLD - angle) / (double)(2.0f * FOV_THRESHOLD)) * (float)barWidth;
                position = class_3532.method_15363((float)position, (float)0.0f, (float)barWidth);
                String iconToRender = point.icon().equals("default") ? "\u2666" : point.icon();
                float iconScaleAdjusted = 2.0f;
                float rawIconWidth = client.field_1772.method_1727(iconToRender);
                float scaledWidth = rawIconWidth * iconScaleAdjusted;
                int iconX = barX + (int)position - (int)(scaledWidth / 2.0f);
                iconX = class_3532.method_15340((int)iconX, (int)barX, (int)(barX + barWidth - (int)scaledWidth));
                int color = point.color();
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int alphaInt = (int)(alpha * barAlpha * compassPointsTransparency * 255.0f);
                int argbColor = alphaInt << 24 | red << 16 | green << 8 | blue;
                int iconY = barY + (barHeight - (int)(6.0f * iconScaleAdjusted)) / 2 - 1;
                int adjustedIconX = 0;
                if (alphaInt > 5) {
                    matrixStack.method_22903();
                    float iconHeight = 8.0f;
                    float scaledHeight = iconHeight * iconScaleAdjusted;
                    adjustedIconX = iconX;
                    int adjustedIconY = iconY;
                    matrixStack.method_46416((float)adjustedIconX, (float)adjustedIconY, 0.0f);
                    matrixStack.method_22905(iconScaleAdjusted, iconScaleAdjusted, 1.0f);
                    drawContext.method_51433(client.field_1772, iconToRender, 0, 0, argbColor, false);
                    matrixStack.method_22909();
                }
                if (alphaInt > 5) {
                    String distanceString;
                    String pointName = point.name();
                    int textWidth = client.field_1772.method_1727(pointName);
                    int iconCenterX = adjustedIconX + (int)(scaledWidth / 2.0f);
                    int textX = iconCenterX - textWidth / 2;
                    int textY = barY + barHeight + 4;
                    double dx = (double)point.x() + 0.5 - cameraPos.field_1352;
                    double dy = (double)point.y() + 0.5 - cameraPos.field_1351;
                    double dz = (double)point.z() + 0.5 - cameraPos.field_1350;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
                    int roundedDistance = (int)Math.floor(distance);
                    String blocksTranslation = class_2561.method_43471((String)"screen.graphcommands.blocks").getString();
                    if (horizontalDistance <= 5.0 && Math.abs(dy) > 4.0) {
                        int heightDifference = (int)Math.floor(Math.abs(dy));
                        String arrow = dy > 0.0 ? "\u2191" : "\u2193";
                        distanceString = "(" + arrow + heightDifference + " " + blocksTranslation.charAt(0) + ")";
                    } else {
                        distanceString = "(" + roundedDistance + " " + blocksTranslation + ")";
                    }
                    if (textOutlineEnabled) {
                        int outlineAlpha = (int)(alpha * barAlpha * compassPointsTransparency * 0.7f * 255.0f);
                        outlineAlpha = Math.max(10, outlineAlpha);
                        int outlineColor = outlineAlpha << 24 | 0;
                        drawContext.method_51433(client.field_1772, pointName, textX - 1, textY, outlineColor, false);
                        drawContext.method_51433(client.field_1772, pointName, textX + 1, textY, outlineColor, false);
                        drawContext.method_51433(client.field_1772, pointName, textX, textY - 1, outlineColor, false);
                        drawContext.method_51433(client.field_1772, pointName, textX, textY + 1, outlineColor, false);
                    }
                    drawContext.method_51433(client.field_1772, pointName, textX, textY, argbColor, false);
                    float distanceScale = 0.75f;
                    int distanceWidth = client.field_1772.method_1727(distanceString);
                    int scaledDistanceWidth = (int)((float)distanceWidth * distanceScale);
                    int distanceX = iconCenterX - scaledDistanceWidth / 2;
                    int distanceY = textY + 10;
                    matrixStack.method_22903();
                    matrixStack.method_46416((float)distanceX, (float)distanceY, 0.0f);
                    matrixStack.method_22905(distanceScale, distanceScale, 1.0f);
                    if (textOutlineEnabled) {
                        int outlineColor = alphaInt << 24 | 0;
                        drawContext.method_51433(client.field_1772, distanceString, -1, 0, outlineColor, false);
                        drawContext.method_51433(client.field_1772, distanceString, 1, 0, outlineColor, false);
                        drawContext.method_51433(client.field_1772, distanceString, 0, -1, outlineColor, false);
                        drawContext.method_51433(client.field_1772, distanceString, 0, 1, outlineColor, false);
                    }
                    drawContext.method_51433(client.field_1772, distanceString, 0, 0, argbColor, false);
                    matrixStack.method_22909();
                }
            }
        }
    }

    private static class_243 projectToScreen(double dx, double dy, double dz, class_310 client, class_243 cameraPos) {
        float dynamicFov = ((GameRendererAccessor)client.field_1773).invokeGetFov(client.field_1773.method_19418(), client.method_61966().method_60637(false), true);
        Matrix4f projectionMatrix = client.field_1773.method_22973(dynamicFov);
        Matrix4f modelViewMatrix = new Matrix4f().identity();
        Quaternionf rotation = client.field_1773.method_19418().method_23767();
        Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)rotation);
        Vector3f eye = new Vector3f((float)cameraPos.field_1352, (float)cameraPos.field_1351, (float)cameraPos.field_1350);
        Vector3f target = new Vector3f((Vector3fc)eye).add((Vector3fc)forward);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)rotation);
        modelViewMatrix.lookAt((Vector3fc)eye, (Vector3fc)target, (Vector3fc)up);
        Vector4f vec = new Vector4f((float)(dx + cameraPos.field_1352), (float)(dy + cameraPos.field_1351), (float)(dz + cameraPos.field_1350), 1.0f);
        modelViewMatrix.transform(vec);
        projectionMatrix.transform(vec);
        float x = vec.x();
        float y = vec.y();
        float z = vec.z();
        float w = vec.w();
        if (w <= 0.0f) {
            return null;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        double screenX = ((double)(x /= w) + 1.0) * (double)screenWidth / 2.0;
        double screenY = (1.0 - (double)(y /= w)) * (double)screenHeight / 2.0;
        double alphaFactor = class_3532.method_15350((double)(1.0 - ((double)(z /= w) - 0.5) / 10.0), (double)0.1, (double)1.0);
        return new class_243(screenX, screenY, alphaFactor);
    }

    public static void onWorldChange(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        class_5321 dimension = client.field_1687.method_27983();
        String serverId = ClientCommandHandler.getServerId(client);
        ClientCommandHandler.loadSettings();
        ClientCommandHandler.loadPointsFromFile((class_5321<class_1937>)dimension, serverId);
        renderCache.clear();
        compassPoints.clear();
    }

    public static String getServerId(class_310 client) {
        class_634 networkHandler = client.method_1562();
        if (networkHandler == null) {
            if (client.method_1496() && client.method_1576() != null) {
                return client.method_1576().method_27728().method_150();
            }
            return "singleplayer";
        }
        class_642 serverInfo = networkHandler.method_45734();
        if (serverInfo == null) {
            if (client.method_1496() && client.method_1576() != null) {
                return client.method_1576().method_27728().method_150();
            }
            return "singleplayer";
        }
        return serverInfo.field_3761 != null ? serverInfo.field_3761.replace(":", "_") : "singleplayer";
    }

    public static void loadPointsFromFile(class_5321<class_1937> dimension, String serverId) {
        try {
            Path configDir = Paths.get("config", "graph_waypoints");
            String dimensionName = dimension.method_29177().method_12832();
            String fileName = serverId + "_" + dimensionName + ".json";
            Path filePath = configDir.resolve(fileName);
            if (!Files.exists(filePath, new LinkOption[0])) {
                return;
            }
            Gson gson = new GsonBuilder().create();
            try (FileReader reader = new FileReader(filePath.toFile());){
                List loadedPoints = (List)gson.fromJson((Reader)reader, new TypeToken<List<TempPoint>>(){}.getType());
                if (loadedPoints != null && !loadedPoints.isEmpty()) {
                    ArrayList<Point> convertedPoints = new ArrayList<Point>();
                    record TempPoint(double x, double y, double z, int color, String name, float transparency, String serverId, boolean visible, String icon) {
                    }
                    for (TempPoint tempPoint : loadedPoints) {
                        if (tempPoint.serverId() == null || !tempPoint.serverId().equals(serverId)) continue;
                        int x = (int)Math.floor(tempPoint.x());
                        int y = (int)Math.floor(tempPoint.y());
                        int z = (int)Math.floor(tempPoint.z());
                        convertedPoints.add(new Point(x, y, z, tempPoint.color(), tempPoint.name(), tempPoint.transparency(), tempPoint.serverId(), tempPoint.visible(), tempPoint.icon()));
                    }
                    pointsByDimension.put(dimension, convertedPoints);
                }
            }
        }
        catch (JsonSyntaxException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 JSON: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u0435\u0442\u043e\u043a: " + e.getMessage());
        }
    }

    public static void savePointsToFile(class_5321<class_1937> dimension, String serverId) {
        try {
            Path configDir = Paths.get("config", "graph_waypoints");
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            String dimensionName = dimension.method_29177().method_12832();
            String fileName = serverId + "_" + dimensionName + ".json";
            Path filePath = configDir.resolve(fileName);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            List points = pointsByDimension.getOrDefault(dimension, new ArrayList());
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                gson.toJson((Object)points, (Appendable)writer);
            }
            renderCache.keySet().removeIf(point -> !points.contains(point));
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043c\u0435\u0442\u043e\u043a: " + e.getMessage());
        }
    }

    private static void initializeSettings() {
        ClientCommandHandler.initializeDefaults();
        ClientCommandHandler.saveSettings();
    }

    public static void loadSettings() {
        try {
            Map settingsMap;
            Path configDir = Paths.get("config", "graph_waypoints");
            Path filePath = configDir.resolve("settings.json");
            if (!Files.exists(filePath, new LinkOption[0])) {
                ClientCommandHandler.initializeSettings();
                return;
            }
            Gson gson = new GsonBuilder().create();
            try (FileReader reader = new FileReader(filePath.toFile());){
                settingsMap = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                if (settingsMap == null) {
                    ClientCommandHandler.initializeSettings();
                    return;
                }
            }
            int settingsVersion = 0;
            if (settingsMap.containsKey("settings_ver")) {
                try {
                    settingsVersion = ((Number)settingsMap.get("settings_ver")).intValue();
                }
                catch (Exception e) {
                    System.err.println("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 settings_ver: " + e.getMessage());
                }
            }
            ClientCommandHandler.initializeDefaults();
            if (settingsVersion < 5) {
                ClientCommandHandler.loadExistingSettings(settingsMap);
                ClientCommandHandler.saveSettings();
            } else {
                ClientCommandHandler.loadAllSettings(settingsMap);
            }
            renderCache.clear();
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a: " + e.getMessage());
            ClientCommandHandler.initializeSettings();
        }
    }

    private static void initializeDefaults() {
        globalTransparency = 1.0f;
        textScale = 0.8f;
        iconScale = 0.66f;
        pointsEnabled = true;
        compassModeEnabled = false;
        textOutlineEnabled = true;
        compassAnimationDuration = 150.0f;
        compassBarTransparency = 0.5f;
        compassPointsTransparency = 0.9f;
        compassBarHeight = 3.0f;
        farFadeDistance = 0.0f;
        nearFadeDistance = 10.0f;
    }

    private static void loadExistingSettings(Map<String, Object> settingsMap) {
        if (settingsMap.containsKey("globalTransparency")) {
            globalTransparency = ((Number)settingsMap.get("globalTransparency")).floatValue();
        }
        if (settingsMap.containsKey("textScale")) {
            textScale = ((Number)settingsMap.get("textScale")).floatValue();
        }
        if (settingsMap.containsKey("iconScale")) {
            iconScale = ((Number)settingsMap.get("iconScale")).floatValue();
        }
        if (settingsMap.containsKey("pointsEnabled")) {
            pointsEnabled = (Boolean)settingsMap.get("pointsEnabled");
        }
        if (settingsMap.containsKey("compassModeEnabled")) {
            compassModeEnabled = (Boolean)settingsMap.get("compassModeEnabled");
        }
        if (settingsMap.containsKey("textOutlineEnabled")) {
            textOutlineEnabled = (Boolean)settingsMap.get("textOutlineEnabled");
        }
        if (settingsMap.containsKey("compassAnimationDuration")) {
            compassAnimationDuration = ((Number)settingsMap.get("compassAnimationDuration")).floatValue();
        }
        if (settingsMap.containsKey("compassBarTransparency")) {
            compassBarTransparency = ((Number)settingsMap.get("compassBarTransparency")).floatValue();
        }
        if (settingsMap.containsKey("compassPointsTransparency")) {
            compassPointsTransparency = ((Number)settingsMap.get("compassPointsTransparency")).floatValue();
        }
        if (settingsMap.containsKey("compassBarHeight")) {
            compassBarHeight = ((Number)settingsMap.get("compassBarHeight")).floatValue();
        }
        if (settingsMap.containsKey("farFadeDistance")) {
            farFadeDistance = ((Number)settingsMap.get("farFadeDistance")).floatValue();
        }
        if (settingsMap.containsKey("nearFadeDistance")) {
            nearFadeDistance = ((Number)settingsMap.get("nearFadeDistance")).floatValue();
        }
    }

    private static void loadAllSettings(Map<String, Object> settingsMap) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            record Settings(int settings_ver, float globalTransparency, float textScale, float iconScale, boolean pointsEnabled, boolean compassModeEnabled, boolean textOutlineEnabled, float compassAnimationDuration, float compassBarTransparency, float compassPointsTransparency, float compassBarHeight, float farFadeDistance, float nearFadeDistance) {
            }
            Settings settings = (Settings)gson.fromJson(gson.toJson(settingsMap), Settings.class);
            if (settings != null) {
                globalTransparency = settings.globalTransparency();
                textScale = class_3532.method_15363((float)settings.textScale(), (float)0.5f, (float)1.0f);
                iconScale = class_3532.method_15363((float)settings.iconScale(), (float)0.5f, (float)1.0f);
                pointsEnabled = settings.pointsEnabled();
                compassModeEnabled = settings.compassModeEnabled();
                textOutlineEnabled = settings.textOutlineEnabled();
                compassAnimationDuration = class_3532.method_15363((float)settings.compassAnimationDuration(), (float)50.0f, (float)500.0f);
                compassBarTransparency = class_3532.method_15363((float)settings.compassBarTransparency(), (float)0.5f, (float)1.0f);
                compassPointsTransparency = class_3532.method_15363((float)settings.compassPointsTransparency(), (float)0.5f, (float)1.0f);
                compassBarHeight = class_3532.method_15363((float)settings.compassBarHeight(), (float)2.0f, (float)5.0f);
                farFadeDistance = class_3532.method_15363((float)settings.farFadeDistance(), (float)0.0f, (float)1000.0f);
                nearFadeDistance = class_3532.method_15363((float)settings.nearFadeDistance(), (float)1.0f, (float)50.0f);
            }
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a: " + e.getMessage());
            ClientCommandHandler.initializeDefaults();
        }
    }

    public static void saveSettings() {
        try {
            Path configDir = Paths.get("config", "graph_waypoints");
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            Path filePath = configDir.resolve("settings.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            LinkedHashMap<String, Serializable> settingsMap = new LinkedHashMap<String, Serializable>();
            settingsMap.put("settings_ver", Integer.valueOf(5));
            settingsMap.put("globalTransparency", Float.valueOf(globalTransparency));
            settingsMap.put("textScale", Float.valueOf(textScale));
            settingsMap.put("iconScale", Float.valueOf(iconScale));
            settingsMap.put("pointsEnabled", Boolean.valueOf(pointsEnabled));
            settingsMap.put("compassModeEnabled", Boolean.valueOf(compassModeEnabled));
            settingsMap.put("textOutlineEnabled", Boolean.valueOf(textOutlineEnabled));
            settingsMap.put("compassAnimationDuration", Float.valueOf(compassAnimationDuration));
            settingsMap.put("compassBarTransparency", Float.valueOf(compassBarTransparency));
            settingsMap.put("compassPointsTransparency", Float.valueOf(compassPointsTransparency));
            settingsMap.put("compassBarHeight", Float.valueOf(compassBarHeight));
            settingsMap.put("farFadeDistance", Float.valueOf(farFadeDistance));
            settingsMap.put("nearFadeDistance", Float.valueOf(nearFadeDistance));
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                gson.toJson(settingsMap, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a: " + e.getMessage());
        }
    }

    public static List<Point> getPointsForDimension(class_5321<class_1937> dimension) {
        return pointsByDimension.getOrDefault(dimension, new ArrayList());
    }

    public static void setPointsForDimension(class_5321<class_1937> dimension, List<Point> points) {
        pointsByDimension.put(dimension, points);
    }

    public static void ensureConfigDirectoryExists() {
        try {
            Path configDir = Paths.get("config", "graph_waypoints");
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043f\u0430\u043f\u043a\u0438 config/graph_waypoints: " + e.getMessage());
        }
    }

    public static float getGlobalTransparency() {
        return globalTransparency;
    }

    public static void setGlobalTransparency(float transparency) {
        globalTransparency = transparency;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getTextScale() {
        return textScale;
    }

    public static void setTextScale(float scale) {
        textScale = scale;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getIconScale() {
        return iconScale;
    }

    public static void setIconScale(float scale) {
        iconScale = scale;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static void setPointsEnabled(boolean enabled) {
        pointsEnabled = enabled;
        ClientCommandHandler.saveSettings();
    }

    public static void setCompassModeEnabled(boolean enabled) {
        compassModeEnabled = enabled;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static boolean isCompassModeEnabled() {
        return compassModeEnabled;
    }

    public static boolean isTextOutlineEnabled() {
        return textOutlineEnabled;
    }

    public static void setTextOutlineEnabled(boolean enabled) {
        textOutlineEnabled = enabled;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getCompassAnimationDuration() {
        return compassAnimationDuration;
    }

    public static void setCompassAnimationDuration(float duration) {
        compassAnimationDuration = duration;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getCompassBarTransparency() {
        return compassBarTransparency;
    }

    public static void setCompassBarTransparency(float transparency) {
        compassBarTransparency = transparency;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getCompassPointsTransparency() {
        return compassPointsTransparency;
    }

    public static void setCompassPointsTransparency(float transparency) {
        compassPointsTransparency = transparency;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getCompassBarHeight() {
        return compassBarHeight;
    }

    public static void setCompassBarHeight(float height) {
        compassBarHeight = height;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getFarFadeDistance() {
        return farFadeDistance;
    }

    public static void setFarFadeDistance(float distance) {
        farFadeDistance = distance;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static float getNearFadeDistance() {
        return nearFadeDistance;
    }

    public static void setNearFadeDistance(float distance) {
        nearFadeDistance = distance;
        ClientCommandHandler.saveSettings();
        renderCache.clear();
    }

    public static int getCurrentSettingsVersion() {
        return 5;
    }

    record Point(int x, int y, int z, int color, String name, float transparency, String serverId, boolean visible, String icon) {
        public Point {
            visible = true;
            icon = icon != null ? icon : "default";
        }

        static int fromName(String colorName) {
            return switch (colorName.toLowerCase()) {
                case "black" -> {
                    if (class_124.field_1074.method_532() != null) {
                        yield class_124.field_1074.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "dark_blue" -> {
                    if (class_124.field_1058.method_532() != null) {
                        yield class_124.field_1058.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "dark_green" -> {
                    if (class_124.field_1077.method_532() != null) {
                        yield class_124.field_1077.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "dark_aqua" -> {
                    if (class_124.field_1062.method_532() != null) {
                        yield class_124.field_1062.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "dark_red" -> {
                    if (class_124.field_1079.method_532() != null) {
                        yield class_124.field_1079.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "dark_purple" -> {
                    if (class_124.field_1064.method_532() != null) {
                        yield class_124.field_1064.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "gold" -> {
                    if (class_124.field_1065.method_532() != null) {
                        yield class_124.field_1065.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "gray" -> {
                    if (class_124.field_1080.method_532() != null) {
                        yield class_124.field_1080.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "dark_gray" -> {
                    if (class_124.field_1063.method_532() != null) {
                        yield class_124.field_1063.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "blue" -> {
                    if (class_124.field_1078.method_532() != null) {
                        yield class_124.field_1078.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "green" -> {
                    if (class_124.field_1060.method_532() != null) {
                        yield class_124.field_1060.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "aqua" -> {
                    if (class_124.field_1075.method_532() != null) {
                        yield class_124.field_1075.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "red" -> {
                    if (class_124.field_1061.method_532() != null) {
                        yield class_124.field_1061.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "light_purple" -> {
                    if (class_124.field_1076.method_532() != null) {
                        yield class_124.field_1076.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "yellow" -> {
                    if (class_124.field_1054.method_532() != null) {
                        yield class_124.field_1054.method_532();
                    }
                    yield 0xFFFFFF;
                }
                case "white" -> {
                    if (class_124.field_1068.method_532() != null) {
                        yield class_124.field_1068.method_532();
                    }
                    yield 0xFFFFFF;
                }
                default -> 0xFFFFFF;
            };
        }
    }

    private static class PointRenderCache {
        class_2561 displayText;
        long lastTextUpdateTime;
        class_243 screenPos;
        float alphaFactor;
        class_243 lastCameraPos;
        Quaternionf lastCameraRotation;

        PointRenderCache(class_2561 displayText, long lastTextUpdateTime, class_243 screenPos, float alphaFactor, class_243 lastCameraPos, Quaternionf lastCameraRotation) {
            this.displayText = displayText;
            this.lastTextUpdateTime = lastTextUpdateTime;
            this.screenPos = screenPos;
            this.alphaFactor = alphaFactor;
            this.lastCameraPos = lastCameraPos;
            this.lastCameraRotation = lastCameraRotation;
        }
    }

    private static class CompassPointData {
        Point point;
        double angle;
        float alpha;
        long animationStartTime;
        float startAlpha;
        float lastTargetAlpha;

        CompassPointData(Point point, double angle, float alpha, long animationStartTime, float startAlpha, float lastTargetAlpha) {
            this.point = point;
            this.angle = angle;
            this.alpha = alpha;
            this.animationStartTime = animationStartTime;
            this.startAlpha = startAlpha;
            this.lastTargetAlpha = lastTargetAlpha;
        }
    }
}

