/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.proxy_protocol_support.shared;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import pl.panszelescik.proxy_protocol_support.shared.ProxyProtocolHandler;
import pl.panszelescik.proxy_protocol_support.shared.ProxyProtocolSupport;
import pl.panszelescik.proxy_protocol_support.shared.config.CIDRMatcher;
import pl.panszelescik.proxy_protocol_support.shared.mixin.ChannelInitializerInvoker;

public class ProxyProtocolChannelInitializer
extends ChannelInitializer<Channel> {
    private final ChannelInitializerInvoker channelInitializer;

    public ProxyProtocolChannelInitializer(ChannelInitializerInvoker invoker) {
        this.channelInitializer = invoker;
    }

    protected void initChannel(Channel channel) throws Exception {
        this.channelInitializer.invokeInitChannel(channel);
        if (!ProxyProtocolSupport.enableProxyProtocol) {
            return;
        }
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        InetAddress remoteIp = remoteAddress.getAddress();
        for (CIDRMatcher matcher : ProxyProtocolSupport.proxyServerIPs) {
            if (!matcher.matches(remoteIp)) continue;
            ProxyProtocolSupport.debugLogger.accept("Accepted connection from trusted proxy: " + remoteIp + ". Applying PROXY protocol handlers.");
            channel.pipeline().addAfter("timeout", "haproxy-decoder", (ChannelHandler)new HAProxyMessageDecoder()).addAfter("haproxy-decoder", "haproxy-handler", (ChannelHandler)new ProxyProtocolHandler());
            return;
        }
        for (CIDRMatcher matcher : ProxyProtocolSupport.directAccessIPs) {
            if (!matcher.matches(remoteIp)) continue;
            ProxyProtocolSupport.debugLogger.accept("Accepted direct connection from whitelisted IP: " + remoteIp);
            return;
        }
        ProxyProtocolSupport.warnLogger.accept("REJECTED unauthorized direct connection from: " + remoteIp);
        channel.close();
    }
}

