/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.proxy_protocol_support.shared;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.panszelescik.proxy_protocol_support.shared.config.CIDRMatcher;
import pl.panszelescik.proxy_protocol_support.shared.config.Config;
import pl.panszelescik.proxy_protocol_support.shared.config.TCPShieldIntegration;

public class ProxyProtocolSupport {
    public static final String MODID = "proxy_protocol_support";
    public static Consumer<String> infoLogger;
    public static Consumer<String> warnLogger;
    public static Consumer<String> errorLogger;
    public static Consumer<String> debugLogger;
    public static boolean enableProxyProtocol;
    public static Collection<CIDRMatcher> proxyServerIPs;
    public static Collection<CIDRMatcher> directAccessIPs;

    public static void initialize(Config config) throws IOException {
        enableProxyProtocol = config.enableProxyProtocol;
        if (!enableProxyProtocol) {
            warnLogger.accept("Proxy Protocol Support is disabled in the config.");
            return;
        }
        infoLogger.accept("Proxy Protocol Support is enabled!");
        proxyServerIPs = config.proxyServerIPs.stream().map(CIDRMatcher::new).collect(Collectors.toSet());
        directAccessIPs = config.directAccessIPs.stream().map(CIDRMatcher::new).collect(Collectors.toSet());
        if (config.whitelistTCPShieldServers) {
            infoLogger.accept("TCPShield integration enabled! Fetching official IPs...");
            try {
                HashSet<CIDRMatcher> tcpShieldIPs = TCPShieldIntegration.getWhitelistedIPs();
                proxyServerIPs.addAll(tcpShieldIPs);
                infoLogger.accept("Successfully added " + tcpShieldIPs.size() + " TCPShield IPs to the trusted proxy list.");
            }
            catch (IOException e) {
                errorLogger.accept("Failed to fetch TCPShield IPs: " + e.getMessage());
            }
        }
        infoLogger.accept("Loaded " + proxyServerIPs.size() + " trusted proxy IPs: " + proxyServerIPs);
        infoLogger.accept("Loaded " + directAccessIPs.size() + " direct access rules: " + config.directAccessIPs);
    }

    static {
        enableProxyProtocol = false;
        proxyServerIPs = new HashSet<CIDRMatcher>();
        directAccessIPs = new HashSet<CIDRMatcher>();
        try {
            Logger slf4j = LoggerFactory.getLogger((String)MODID);
            infoLogger = arg_0 -> ((Logger)slf4j).info(arg_0);
            warnLogger = arg_0 -> ((Logger)slf4j).warn(arg_0);
            errorLogger = arg_0 -> ((Logger)slf4j).error(arg_0);
            debugLogger = arg_0 -> ((Logger)slf4j).debug(arg_0);
        }
        catch (Throwable ignored) {
            try {
                org.apache.logging.log4j.Logger log4j = LogManager.getLogger((String)MODID);
                infoLogger = arg_0 -> ((org.apache.logging.log4j.Logger)log4j).info(arg_0);
                warnLogger = arg_0 -> ((org.apache.logging.log4j.Logger)log4j).warn(arg_0);
                errorLogger = arg_0 -> ((org.apache.logging.log4j.Logger)log4j).error(arg_0);
                debugLogger = arg_0 -> ((org.apache.logging.log4j.Logger)log4j).debug(arg_0);
            }
            catch (Throwable ignored2) {
                infoLogger = System.out::println;
                warnLogger = System.out::println;
                errorLogger = System.out::println;
                debugLogger = msg -> {};
            }
        }
    }
}

