/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.proxy_protocol_support.shared.config;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class CIDRMatcher {
    private final int maskBits;
    private final int maskBytes;
    private final boolean simpleCIDR;
    private final InetAddress cidrAddress;

    public CIDRMatcher(String ipAddress) {
        String parsedIPAddress;
        String[] split = ipAddress.split("/", 2);
        if (split.length == 2) {
            parsedIPAddress = split[0];
            this.maskBits = Integer.parseInt(split[1]);
            this.simpleCIDR = this.maskBits == 32;
        } else {
            parsedIPAddress = ipAddress;
            this.maskBits = -1;
            this.simpleCIDR = true;
        }
        this.maskBytes = this.simpleCIDR ? -1 : this.maskBits / 8;
        try {
            this.cidrAddress = InetAddress.getByName(parsedIPAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean matches(InetAddress inetAddress) {
        if (this.cidrAddress.getClass() != inetAddress.getClass()) {
            return false;
        }
        if (this.simpleCIDR) {
            return inetAddress.equals(this.cidrAddress);
        }
        byte[] inetAddressBytes = inetAddress.getAddress();
        byte[] requiredAddressBytes = this.cidrAddress.getAddress();
        byte finalByte = (byte)(65280 >> (this.maskBits & 7));
        for (int i = 0; i < this.maskBytes; ++i) {
            if (inetAddressBytes[i] == requiredAddressBytes[i]) continue;
            return false;
        }
        if (finalByte != 0) {
            return (inetAddressBytes[this.maskBytes] & finalByte) == (requiredAddressBytes[this.maskBytes] & finalByte);
        }
        return true;
    }

    public String toString() {
        return this.simpleCIDR ? this.cidrAddress.toString().substring(1) : this.cidrAddress.toString().substring(1) + "/" + this.maskBits;
    }
}

