/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.proxy_protocol_support.shared.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import pl.panszelescik.proxy_protocol_support.shared.config.Config;

public class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Config loadConfig(File configDir) throws IOException {
        File file = new File(configDir, "proxy_protocol_support.json");
        if (file.exists()) {
            return Configuration.saveConfig(file, Configuration.loadConfigFile(file));
        }
        return Configuration.saveDefaultConfig(file);
    }

    private static Config loadConfigFile(File configFile) throws IOException {
        String string = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        return (Config)GSON.fromJson(string, Config.class);
    }

    private static Config saveDefaultConfig(File configFile) throws IOException {
        return Configuration.saveConfig(configFile, new Config());
    }

    private static Config saveConfig(File configFile, Config config) throws IOException {
        String string = GSON.toJson((Object)config);
        FileUtils.writeStringToFile((File)configFile, (String)string, (Charset)StandardCharsets.UTF_8);
        return config;
    }
}

