/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly;

import com.hm.antiworldfly.bukkit.Metrics;
import com.hm.antiworldfly.command.CommandsTab;
import com.hm.antiworldfly.command.HelpCommand;
import com.hm.antiworldfly.command.InfoCommand;
import com.hm.antiworldfly.file.CommentedYamlConfiguration;
import com.hm.antiworldfly.listener.CommandPreProcess;
import com.hm.antiworldfly.listener.PlayerJoin;
import com.hm.antiworldfly.listener.ToggleFly;
import com.hm.antiworldfly.listener.ToggleGlide;
import com.hm.antiworldfly.listener.WorldJoin;
import com.hm.antiworldfly.update.UpdateChecker;
import com.hm.antiworldfly.worldguard.FlagRegistry;
import com.hm.antiworldfly.worldguard.listener.PlayerMove;
import com.hm.antiworldfly.worldguard.listener.RegionToggleGlide;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiWorldFly
extends JavaPlugin {
    private List<String> antiFlyWorlds;
    private boolean disabled = false;
    private boolean chatMessage;
    private boolean antiFlyCreative;
    private String chatHeader;
    private String icon;
    private String AntiFlyFlag;
    private String AntiElytraFlag;
    private boolean titleMessage;
    private boolean notifyNotFlying;
    private boolean toggleFlyingInNonBlockedWorlds;
    private boolean successfulLoad;
    private boolean elytraDisabled;
    private boolean bStatsEnabled;
    private CommentedYamlConfiguration config;
    private CommentedYamlConfiguration lang;
    private CommandPreProcess awfPreProcess;
    private WorldJoin awfWorldJoin;
    private PlayerJoin awfPlayerJoin;
    private ToggleFly awfPlayerToggleFly;
    private ToggleGlide awfToggleGlide;
    private PlayerMove awfPlayerMove;
    private RegionToggleGlide awfRegionToggleGlide;
    private UpdateChecker updateChecker;
    private HelpCommand helpCommand;
    private InfoCommand infoCommand;
    private List<String> otherBlockedCommands;

    public void onLoad() {
        this.extractParametersFromConfig(true);
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.getLogger().info("WorldGuard detected! Attempting to register region flags.");
            try {
                FlagRegistry flagRegistry = new FlagRegistry(this);
                flagRegistry.register(this.getAntiFlyFlag());
                flagRegistry.register(this.getAntiElytraFlag());
            }
            catch (NoClassDefFoundError ignored) {
                this.getLogger().info("There were issues with WorldGuard... Was there a major update recently?Please open an issue on the GitHub: https://github.com/PyvesB/AntiWorldFly/issues");
            }
        }
    }

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        this.getLogger().info("Registering listeners...");
        this.awfPreProcess = new CommandPreProcess(this);
        this.awfWorldJoin = new WorldJoin(this);
        this.awfPlayerJoin = new PlayerJoin(this);
        this.awfPlayerToggleFly = new ToggleFly(this);
        try {
            this.awfToggleGlide = new ToggleGlide(this);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().info("You are running and outdated version of Minecraft, enabling with a limited feature-set.");
        }
        try {
            this.awfPlayerMove = new PlayerMove(this);
            this.awfRegionToggleGlide = new RegionToggleGlide(this);
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.awfPreProcess, (Plugin)this);
        pm.registerEvents((Listener)this.awfWorldJoin, (Plugin)this);
        pm.registerEvents((Listener)this.awfPlayerJoin, (Plugin)this);
        pm.registerEvents((Listener)this.awfPlayerToggleFly, (Plugin)this);
        try {
            pm.registerEvents((Listener)this.awfToggleGlide, (Plugin)this);
            if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
                pm.registerEvents((Listener)this.awfPlayerMove, (Plugin)this);
                pm.registerEvents((Listener)this.awfRegionToggleGlide, (Plugin)this);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.config.getBoolean("checkForUpdate", true)) {
            this.updateChecker = new UpdateChecker(this, "https://raw.githubusercontent.com/PyvesB/AntiWorldFly/master/pom.xml", "antiworldfly.use", this.chatHeader, "spigotmc.org/resources/anti-world-fly.5357");
            pm.registerEvents((Listener)this.updateChecker, (Plugin)this);
            this.updateChecker.launchUpdateCheckerTask();
        }
        this.helpCommand = new HelpCommand(this);
        this.infoCommand = new InfoCommand(this);
        this.getCommand("antiworldfly").setTabCompleter((TabCompleter)new CommandsTab(this));
        if (this.bStatsEnabled) {
            this.bStats();
        }
        if (this.successfulLoad) {
            this.getLogger().info("Plugin successfully enabled and ready to run! Took " + (System.currentTimeMillis() - startTime) + "ms.");
        } else {
            this.getLogger().severe("Error(s) while loading plugin. Please view previous logs for more information.");
        }
    }

    private void extractParametersFromConfig(boolean attemptUpdate) {
        this.successfulLoad = true;
        Logger logger = this.getLogger();
        logger.info("Backing up and loading configuration files...");
        try {
            this.config = new CommentedYamlConfiguration("config.yml", this);
            this.config.loadConfiguration();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while loading configuration file: ", e);
            this.successfulLoad = false;
        }
        catch (InvalidConfigurationException e) {
            logger.severe("Error while loading configuration file, disabling plugin.");
            logger.log(Level.SEVERE, "Verify your syntax by visiting yaml-online-parser.appspot.com and using the following logs: ", e);
            this.successfulLoad = false;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.lang = new CommentedYamlConfiguration(this.config.getString("languageFileName", "lang.yml"), this);
            this.lang.loadConfiguration();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while loading language file: ", e);
            this.successfulLoad = false;
        }
        catch (InvalidConfigurationException e) {
            logger.severe("Error while loading language file, disabling plugin.");
            logger.log(Level.SEVERE, "Verify your syntax by visiting yaml-online-parser.appspot.com and using the following logs: ", e);
            this.successfulLoad = false;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.config.backupConfiguration();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while backing up configuration file: ", e);
            this.successfulLoad = false;
        }
        try {
            this.lang.backupConfiguration();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while backing up language file: ", e);
            this.successfulLoad = false;
        }
        if (attemptUpdate) {
            this.updateOldConfiguration();
            this.updateOldLanguage();
        }
        this.antiFlyWorlds = this.config.getList("antiFlyWorlds");
        this.chatMessage = this.config.getBoolean("chatMessage", true);
        this.titleMessage = this.config.getBoolean("titleMessage", true);
        this.antiFlyCreative = this.config.getBoolean("antiFlyCreative", true);
        this.notifyNotFlying = this.config.getBoolean("notifyNotFlying", true);
        this.toggleFlyingInNonBlockedWorlds = this.config.getBoolean("toggleFlyingInNonBlockedWorlds", false);
        this.elytraDisabled = this.config.getBoolean("elytraDisabled", false);
        this.bStatsEnabled = this.config.getBoolean("enable-bStats", true);
        this.otherBlockedCommands = this.config.getList("otherBlockedCommands");
        this.icon = StringEscapeUtils.unescapeJava((String)this.config.getString("icon", "\u06de"));
        this.AntiFlyFlag = StringEscapeUtils.unescapeJava((String)this.config.getString("antiFlyFlagName", "flight-enabled"));
        this.AntiElytraFlag = StringEscapeUtils.unescapeJava((String)this.config.getString("antiElytraFlagName", "elytra-enabled"));
        String string = this.chatHeader = this.icon.isEmpty() ? "" : ChatColor.GRAY + "[" + ChatColor.BLUE + this.icon + ChatColor.GRAY + "] " + ChatColor.WHITE;
        if (!this.config.getBoolean("checkForUpdate", true)) {
            PlayerJoinEvent.getHandlerList().unregister((Listener)this.updateChecker);
        }
    }

    private void updateOldConfiguration() {
        boolean updateDone = false;
        if (!this.config.getKeys(false).contains("languageFileName")) {
            this.config.set("languageFileName", (Object)"lang.yml", "Name of the language file.");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("checkForUpdate")) {
            this.config.set("checkForUpdate", (Object)true, "Check for update on plugin launch and notify when an OP joins the game.");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("notifyNotFlying")) {
            this.config.set("notifyNotFlying", (Object)true, "Notify player when entering a world in which flying is blocked even if he is not flying.");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("toggleFlyingInNonBlockedWorlds")) {
            this.config.set("toggleFlyingInNonBlockedWorlds", (Object)false, "A player entering a world not listed in antiFlyWorlds will have flying enabled and automatically start flying if not on the ground.", "Player must have either antiworldfly.fly or essentials.fly permissions for this feature to be effective.");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("icon")) {
            this.config.set("icon", (Object)"\u06de", "Set the icon of the plugin (default: '\u06de').");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("elytraDisabled")) {
            this.config.set("elytraDisabled", (Object)false, "Toggles whether the elytra should be disabled in blocked worlds.");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("antiFlyFlagName")) {
            this.config.set("antiFlyFlagName", (Object)"flight-enabled", " In the event that AntiWorldFly is conflicting with a different plugin, you can change the WorldGuard flag's name.", " WARNING: changing this will break pre-existing rules which utilize this flag!");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("antiElytraFlagName")) {
            this.config.set("antiElytraFlagName", "elytra-enabled");
            updateDone = true;
        }
        if (!this.config.getKeys(false).contains("enable-bStats")) {
            this.config.set("enable-bStats", (Object)true, " Whether bStats should be enabled.");
            updateDone = true;
        }
        if (updateDone) {
            try {
                this.config.saveConfiguration();
                this.config.loadConfiguration();
                this.getLogger().log(Level.INFO, "Config file updated successfully!");
            }
            catch (IOException | InvalidConfigurationException e) {
                this.getLogger().log(Level.SEVERE, "Error while saving changes to the configuration file: ", e);
                this.successfulLoad = false;
            }
        }
    }

    private void updateOldLanguage() {
        boolean updateDone = false;
        if (!this.lang.getKeys(false).contains("awf-command-add-hover")) {
            this.lang.set("awf-command-add-hover", "Make sure you specify the correct name!");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-remove-hover")) {
            this.lang.set("awf-command-remove-hover", "World must be listed in /awf list.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-list-hover")) {
            this.lang.set("awf-command-list-hover", "Flying and some specific commands are disabled in these worlds.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-disable-hover")) {
            this.lang.set("awf-command-disable-hover", "The plugin will not work until next reload or /awf enable.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-enable-hover")) {
            this.lang.set("awf-command-enable-hover", "Plugin enabled by default. Use this if you entered /awf disable before!");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-reload-hover")) {
            this.lang.set("awf-command-reload-hover", "Reload most settings in config.yml and lang.yml files.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-info-hover")) {
            this.lang.set("awf-command-info-hover", "Some extra info about the plugin and its awesome author!");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-tip")) {
            this.lang.set("awf-tip", "\u00a7lHINT\u00a7r \u00a77You can \u00a7f\u00a7n\u00a7ohover\u00a7r \u00a77or \u00a7f\u00a7n\u00a7oclick\u00a7r \u00a77on the commands!");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("command-error")) {
            this.lang.set("command-error", "An error occurred while executing the command.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("display-current-world")) {
            this.lang.set("display-current-world", "You are currently in 'WORLD'");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("awf-command-world")) {
            this.lang.set("awf-command-world", "Display the world you are standing in.");
            this.getLogger().log(Level.WARNING, "If you are updating from an old version to v2.4.0 and up, changes have been made to permissions!Even though backwards compatibility is being kept for now, I recommend you update your permissions.See: https://github.com/PyvesB/AntiWorldFly/wiki/Permissions");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("fly-disabled-region")) {
            this.lang.set("fly-disabled-region", "Flying is disabled in this region.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("elytra-disabled-region")) {
            this.lang.set("elytra-disabled-region", "Elytras are disabled in this region.");
            updateDone = true;
        }
        if (!this.lang.getKeys(false).contains("elytra-disabled-subtitle")) {
            this.lang.set("elytra-disabled-subtitle", "Elytras are disabled in this world.");
            updateDone = true;
        }
        if (updateDone) {
            try {
                this.lang.saveConfiguration();
                this.lang.loadConfiguration();
                this.getLogger().log(Level.INFO, "Lang file updated successfully!");
            }
            catch (IOException | InvalidConfigurationException e) {
                this.getLogger().log(Level.SEVERE, "Error while saving changes to the language file: ", e);
                this.successfulLoad = false;
            }
        }
    }

    public void onDisable() {
        this.getLogger().info("AntiWorldFly has been disabled.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!"awf".equalsIgnoreCase(cmd.getName())) {
            return false;
        }
        if (args.length == 0 || args.length == 1 && "help".equalsIgnoreCase(args[0])) {
            this.helpCommand.getHelp(sender);
        } else if ("list".equalsIgnoreCase(args[0])) {
            sender.sendMessage(this.chatHeader + this.lang.getString("words-blocked", "Worlds in which flying is blocked:"));
            for (String world : this.antiFlyWorlds) {
                sender.sendMessage(" - " + world);
            }
        } else if ("info".equalsIgnoreCase(args[0])) {
            this.infoCommand.getInfo(sender);
        } else if (sender.hasPermission("antiworldfly.use")) {
            String action = args[0].toLowerCase();
            if ("reload".equals(action)) {
                this.reloadConfig();
                this.extractParametersFromConfig(false);
                if (this.successfulLoad) {
                    if (sender instanceof Player) {
                        sender.sendMessage(this.chatHeader + this.lang.getString("configuration-successfully-reloaded", "Configuration successfully reloaded."));
                    }
                    this.getLogger().info("Configuration successfully reloaded.");
                }
            } else if ("disable".equals(action)) {
                this.disabled = true;
                sender.sendMessage(this.chatHeader + this.lang.getString("awf-disabled", "AntiWorldFly disabled till next reload or /awf enable."));
            } else if ("enable".equals(action)) {
                this.disabled = false;
                sender.sendMessage(this.chatHeader + this.lang.getString("awf-enabled", "AntiWorldFly enabled."));
            } else if ("add".equals(action) && args.length == 2) {
                this.antiFlyWorlds.add(args[1]);
                this.config.set("antiFlyWorlds", this.antiFlyWorlds);
                try {
                    this.config.saveConfiguration();
                    this.config.loadConfiguration();
                }
                catch (IOException | InvalidConfigurationException e) {
                    this.getLogger().log(Level.SEVERE, "Error while adding world to the configuration file: ", e);
                    sender.sendMessage(this.chatHeader + this.lang.getString("command-error", "An error occurred while executing the command."));
                    return true;
                }
                sender.sendMessage(this.chatHeader + this.lang.getString("world-added", "New world successfully added: ") + args[1]);
            } else if ("remove".equals(action) && args.length == 2) {
                for (int i = 0; i < this.antiFlyWorlds.size(); ++i) {
                    if (!this.antiFlyWorlds.get(i).equals(args[1])) continue;
                    this.antiFlyWorlds.remove(i);
                }
                this.config.set("antiFlyWorlds", this.antiFlyWorlds);
                try {
                    this.config.saveConfiguration();
                    this.config.loadConfiguration();
                }
                catch (IOException | InvalidConfigurationException e) {
                    this.getLogger().log(Level.SEVERE, "Error while removing world from the configuration file: ", e);
                    sender.sendMessage(this.chatHeader + this.lang.getString("command-error", "An error occurred while executing the command."));
                    return true;
                }
                sender.sendMessage(this.chatHeader + this.lang.getString("world-removed", "World successfully removed: ") + args[1]);
            } else if ("world".equals(action)) {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    String world = p.getWorld().getName();
                    sender.sendMessage(this.chatHeader + this.lang.getString("display-current-world", "You are currently in 'WORLD'").replace("WORLD", world));
                } else {
                    sender.sendMessage(this.chatHeader + this.lang.getString("must-be-player", "You must be a player to run this command."));
                }
            } else {
                sender.sendMessage(this.chatHeader + this.lang.getString("misused-command", "Misused command. Please type /awf."));
            }
        } else {
            sender.sendMessage(this.chatHeader + this.lang.getString("no-permissions", "You do not have the permission to do this."));
        }
        return true;
    }

    public void bStats() {
        int pluginID = 13540;
        Metrics metrics = new Metrics(this, pluginID);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<String> getAntiFlyWorlds() {
        return this.antiFlyWorlds;
    }

    public boolean isChatMessage() {
        return this.chatMessage;
    }

    public boolean isTitleMessage() {
        return this.titleMessage;
    }

    public boolean isAntiFlyCreative() {
        return this.antiFlyCreative;
    }

    public boolean isNotifyNotFlying() {
        return this.notifyNotFlying;
    }

    public boolean isToggleFlyingInNonBlockedWorlds() {
        return this.toggleFlyingInNonBlockedWorlds;
    }

    public String getChatHeader() {
        return this.chatHeader;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getAntiFlyFlag() {
        return this.AntiFlyFlag;
    }

    public String getAntiElytraFlag() {
        return this.AntiElytraFlag;
    }

    public CommentedYamlConfiguration getPluginLang() {
        return this.lang;
    }

    public List<String> getOtherBlockedCommands() {
        return this.otherBlockedCommands;
    }

    public void setSuccessfulLoad(boolean successfulLoad) {
        this.successfulLoad = successfulLoad;
    }

    public boolean isElytraDisabled() {
        return this.elytraDisabled;
    }
}

