/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.particle.FancyMessageSender;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class AntiWorldFlyRunnable
implements Runnable {
    private final Player player;
    private final AntiWorldFly plugin;

    public AntiWorldFlyRunnable(Player player, AntiWorldFly awf) {
        this.player = player;
        this.plugin = awf;
    }

    @Override
    public void run() {
        if (this.plugin.isDisabled() || this.player.hasPermission("antiworldfly.fly") || this.player.hasPermission("antiworldfly.fly." + this.player.getWorld().getName())) {
            return;
        }
        if (!this.plugin.isAntiFlyCreative() && this.player.getGameMode() == GameMode.CREATIVE || "SPECTATOR".equals(this.player.getGameMode().toString())) {
            return;
        }
        if (this.plugin.isChatMessage() && (this.plugin.isNotifyNotFlying() || !this.plugin.isNotifyNotFlying() && this.player.isFlying())) {
            this.player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("fly-disabled-chat", "Flying is disabled in this world."));
        }
        if (this.plugin.isTitleMessage() && (this.plugin.isNotifyNotFlying() || !this.plugin.isNotifyNotFlying() && this.player.isFlying())) {
            try {
                String title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getPluginLang().getString("fly-disabled-title", "&9AntiWorldFly"));
                String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getPluginLang().getString("fly-disabled-subtitle", "Flying is disabled in this world."));
                FancyMessageSender.sendTitle(this.player, title, subtitle);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Errors while trying to display flying disabled title: ", e);
            }
        }
        this.player.setAllowFlight(false);
        this.player.setFlying(false);
    }
}

