/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.command;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.particle.FancyMessageSender;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HelpCommand {
    private AntiWorldFly plugin;

    public HelpCommand(AntiWorldFly plugin) {
        this.plugin = plugin;
    }

    public void getHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.BLUE + "------------------ " + ChatColor.WHITE + ChatColor.BLUE + this.plugin.getIcon() + ChatColor.translateAlternateColorCodes((char)'&', (String)" &7AntiWorldFly ") + ChatColor.BLUE + this.plugin.getIcon() + ChatColor.WHITE + ChatColor.BLUE + " ------------------");
        this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf list" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-list", "List worlds in which AWF operates."), "/awf list", this.plugin.getPluginLang().getString("awf-command-list-hover", "Flying and some specific commands are disabled in these worlds."));
        this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf info" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-info", "Display various information about the plugin."), "/awf info", this.plugin.getPluginLang().getString("awf-command-info-hover", "Some extra info about the plugin and its awesome author!"));
        if (sender.hasPermission("antiworldfly.use")) {
            this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf reload" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-reload", "Reload the plugin's configuration."), "/awf reload", this.plugin.getPluginLang().getString("awf-command-reload-hover", "Reload most settings in config.yml and lang.yml files."));
        }
        if (sender.hasPermission("antiworldfly.use")) {
            this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf enable" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-enable", "Enable plugin."), "/awf enable", this.plugin.getPluginLang().getString("awf-command-enable-hover", "Plugin enabled by default. Use this if you entered /awf disable before!"));
        }
        if (sender.hasPermission("antiworldfly.use")) {
            this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf disable" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-disable", "Disable plugin."), "/awf disable", this.plugin.getPluginLang().getString("awf-command-disable-hover", "The plugin will not work until next reload or /awf enable."));
        }
        if (sender.hasPermission("antiworldfly.use")) {
            this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf add <world>" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-add", "Add WORLD to blocked worlds.").replace("WORLD", "world"), "/awf add world", this.plugin.getPluginLang().getString("awf-command-add-hover", "Make sure you specify the correct name!"));
        }
        if (sender.hasPermission("antiworldfly.use")) {
            this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf remove <world>" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-remove", "Remove WORLD from blocked worlds.").replace("WORLD", "world"), "/awf remove world", this.plugin.getPluginLang().getString("awf-command-remove-hover", "World must be listed in /awf list."));
        }
        if (sender.hasPermission("antiworldfly.use")) {
            this.sendJsonClickableHoverableMessage(sender, ChatColor.BLUE + "/awf world" + ChatColor.WHITE + " > " + this.plugin.getPluginLang().getString("awf-command-world", "Display the world you are standing in.").replace("WORLD", "world"), "/awf world", this.plugin.getPluginLang().getString("awf-command-remove-hover", "World must be listed in /awf list."));
        }
        if (sender instanceof Player) {
            sender.sendMessage(ChatColor.BLUE + " ");
            sender.sendMessage(ChatColor.WHITE + ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(this.plugin.getPluginLang().getString("awf-tip", "&lHINT&r &8You can &7&n&ohover&r &8or &7&n&oclick&r &8on the commands!"))));
        }
    }

    public void sendJsonClickableHoverableMessage(CommandSender sender, String message, String command, String hover) {
        if (sender instanceof Player) {
            try {
                FancyMessageSender.sendHoverableCommandMessage((Player)sender, message, command, hover);
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Errors while trying to display clickable and hoverable message in /awf help command. Displaying standard message instead.");
                sender.sendMessage(message);
            }
        } else {
            sender.sendMessage(message);
        }
    }
}

