/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.file;

import com.hm.antiworldfly.file.FileManager;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class CommentedYamlConfiguration
extends YamlConfiguration {
    private final FileManager manager;
    private final JavaPlugin plugin;
    private int numOfComments;

    public CommentedYamlConfiguration(String fileName, JavaPlugin plugin) {
        this(fileName, fileName, plugin);
    }

    public CommentedYamlConfiguration(String fileName, String pluginResourceName, JavaPlugin plugin) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("Invalid file name.");
        }
        this.plugin = plugin;
        this.manager = new FileManager(fileName, pluginResourceName, plugin);
    }

    public Set<String> getShallowKeys(String path) {
        return this.getConfigurationSection(path).getKeys(false);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        ConfigurationSection configurationSection = super.getConfigurationSection(path);
        return configurationSection == null ? this.createSection(path) : configurationSection;
    }

    public List<String> getList(String path) {
        List list = super.getList(path);
        if (list != null) {
            return list;
        }
        return new ArrayList<String>();
    }

    public void set(String path, Object value, String comment) {
        if (comment != null) {
            this.set(this.plugin.getDescription().getName() + "_COMMENT_" + this.numOfComments, comment.replace(":", "_COLON_").replace("|", "_VERT_").replace("-", "_HYPHEN_").replace(" ", "_SPACE_"));
            ++this.numOfComments;
        }
        this.set(path, value);
    }

    public void set(String path, Object value, String ... comments) {
        for (String comment : comments) {
            this.set(this.plugin.getDescription().getName() + "_COMMENT_" + this.numOfComments, comment.replace(":", "_COLON_").replace("|", "_VERT_").replace("-", "_HYPHEN_").replace(" ", "_SPACE_"));
            ++this.numOfComments;
        }
        this.set(path, value);
    }

    public void loadConfiguration() throws IOException, InvalidConfigurationException {
        this.manager.createConfigurationFileIfNotExists();
        this.map.clear();
        this.load(new StringReader(this.manager.getConfigurationWithReworkedComments()));
        this.numOfComments = this.manager.getNumberOfComments();
    }

    public void saveConfiguration() throws IOException {
        String configString = this.saveToString();
        this.manager.saveConfiguration(configString);
    }

    public void backupConfiguration() throws IOException {
        this.manager.backupFile();
    }
}

