/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.AntiWorldFlyRunnable;
import org.bukkit.GameMode;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class CommandPreProcess
implements Listener {
    private AntiWorldFly plugin;

    public CommandPreProcess(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        if (this.plugin.isDisabled() || event.getPlayer().hasPermission("antiworldfly.fly." + event.getPlayer().getWorld().getName())) {
            return;
        }
        if (!this.plugin.isAntiFlyCreative() && event.getPlayer().getGameMode() == GameMode.CREATIVE || "SPECTATOR".equals(event.getPlayer().getGameMode().toString())) {
            return;
        }
        String command = event.getMessage().toLowerCase();
        if (command.startsWith("/fly") || command.startsWith("/essentials:fly") || command.startsWith("/efly")) {
            this.blockCommand(event);
        } else if (command.startsWith("/gm 1") || command.startsWith("/gamemode c") || command.startsWith("/gm c")) {
            if (!this.plugin.isAntiFlyCreative()) {
                return;
            }
            for (String world : this.plugin.getAntiFlyWorlds()) {
                if (!event.getPlayer().getWorld().getName().equalsIgnoreCase(world)) continue;
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new AntiWorldFlyRunnable(event.getPlayer(), this.plugin), 20L);
                break;
            }
        } else {
            boolean otherBlockedCommand = false;
            if (!this.plugin.getOtherBlockedCommands().isEmpty()) {
                for (String blockedCommand : this.plugin.getOtherBlockedCommands()) {
                    if (!blockedCommand.equalsIgnoreCase(command)) continue;
                    otherBlockedCommand = true;
                }
            }
            if (otherBlockedCommand) {
                this.blockCommand(event);
            }
        }
    }

    private void blockCommand(PlayerCommandPreprocessEvent event) {
        if (!this.plugin.isAntiFlyCreative() && event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        for (String world : this.plugin.getAntiFlyWorlds()) {
            if (!event.getPlayer().getWorld().getName().equalsIgnoreCase(world)) continue;
            event.getPlayer().sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("command-disabled-chat", "Command is disabled in this world."));
            event.setCancelled(true);
            break;
        }
    }
}

