/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.AntiWorldFlyRunnable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoin
implements Listener {
    private final AntiWorldFly plugin;

    public PlayerJoin(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (String world : this.plugin.getAntiFlyWorlds()) {
            if (!player.getWorld().getName().equalsIgnoreCase(world)) continue;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new AntiWorldFlyRunnable(player, this.plugin), 20L);
            return;
        }
        if (this.plugin.isToggleFlyingInNonBlockedWorlds() && !player.getAllowFlight() && (player.hasPermission("antiworldfly.fly." + player.getWorld().getName()) || player.hasPermission("essentials.fly"))) {
            player.setAllowFlight(true);
            if (!player.isOnGround()) {
                player.setFlying(true);
            }
        }
    }
}

