/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.particle.FancyMessageSender;
import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;

public class ToggleFly
implements Listener {
    private AntiWorldFly plugin;

    public ToggleFly(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocessEvent(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isDisabled() || player.hasPermission("antiworldfly.fly." + player.getWorld().getName())) {
            return;
        }
        if (!this.plugin.isAntiFlyCreative() && event.getPlayer().getGameMode() == GameMode.CREATIVE || "SPECTATOR".equals(event.getPlayer().getGameMode().toString())) {
            return;
        }
        for (String world : this.plugin.getAntiFlyWorlds()) {
            if (!event.getPlayer().getWorld().getName().equalsIgnoreCase(world)) continue;
            player.setAllowFlight(false);
            player.getPlayer().setFlying(false);
            event.setCancelled(true);
            if (this.plugin.isChatMessage()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("fly-disabled-chat", "Flying is disabled in this world."));
            }
            if (!this.plugin.isTitleMessage()) break;
            try {
                FancyMessageSender.sendTitle(player, this.plugin.getPluginLang().getString("fly-disabled-title", "&9AntiWorldFly"), this.plugin.getPluginLang().getString("fly-disabled-subtitle", "Flying is disabled in this world."));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Errors while trying to display flying disabled title: ", e);
            }
            break;
        }
    }
}

