/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.particle.FancyMessageSender;
import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;

public class ToggleGlide
implements Listener {
    private final AntiWorldFly plugin;

    public ToggleGlide(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityToggleGlideEvent(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (!entity.getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Player player = (Player)entity;
        if (this.plugin.isDisabled() || !this.plugin.isElytraDisabled() || player.hasPermission("antiworldfly.elytra." + player.getWorld().getName()) || !this.plugin.isAntiFlyCreative() && player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        for (String world : this.plugin.getAntiFlyWorlds()) {
            if (!player.getWorld().getName().equalsIgnoreCase(world)) continue;
            event.setCancelled(true);
            if (this.plugin.isChatMessage()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("elytra-disabled-subtitle", "Elytras are disabled in this world."));
            }
            if (this.plugin.isTitleMessage()) {
                try {
                    FancyMessageSender.sendTitle(player, this.plugin.getPluginLang().getString("fly-disabled-title", "&9AntiWorldFly"), this.plugin.getPluginLang().getString("elytra-disabled-subtitle", "Elytras are disabled in this world."));
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Errors while trying to display flying disabled title: ", e);
                }
            }
            return;
        }
    }
}

