/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.AntiWorldFlyRunnable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class WorldJoin
implements Listener {
    private final AntiWorldFly plugin;

    public WorldJoin(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void worldJoin(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isDisabled() || player.hasPermission("antiworldfly.fly." + player.getWorld().getName())) {
            return;
        }
        if (!this.plugin.isAntiFlyCreative() && player.getGameMode() == GameMode.CREATIVE || "SPECTATOR".equals(player.getGameMode().toString())) {
            return;
        }
        for (String world : this.plugin.getAntiFlyWorlds()) {
            if (!player.getWorld().getName().equalsIgnoreCase(world)) continue;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(Bukkit.getPluginManager().getPlugin("AntiWorldFly"), (Runnable)new AntiWorldFlyRunnable(player, this.plugin), 20L);
            return;
        }
        if (this.plugin.isToggleFlyingInNonBlockedWorlds() && !player.getAllowFlight() && (player.hasPermission("antiworldfly.fly") || player.hasPermission("essentials.fly"))) {
            player.setAllowFlight(true);
            if (!player.isOnGround()) {
                player.setFlying(true);
            }
        }
    }
}

