/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.particle;

import java.lang.reflect.Method;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class FancyMessageSender {
    private static final int MAJOR_VERSION_NUMBER = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].split("\\.")[1]);

    private FancyMessageSender() {
    }

    public static void sendHoverableMessage(Player player, String message, String hover) throws Exception {
        TextComponent tc = new TextComponent();
        tc.setText(message);
        if (MAJOR_VERSION_NUMBER >= 16) {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hover)}));
        } else {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
        }
        player.spigot().sendMessage((BaseComponent)tc);
    }

    public static void sendHoverableCommandMessage(Player player, String message, String command, String hover) throws Exception {
        TextComponent tc = new TextComponent();
        tc.setText(message);
        tc.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        if (MAJOR_VERSION_NUMBER >= 16) {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hover)}));
        } else {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
        }
        player.spigot().sendMessage((BaseComponent)tc);
    }

    public static void sendActionBarMessage(Player player, String message) throws Exception {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        block7: {
            title = title != null ? title : "";
            subtitle = subtitle != null ? subtitle : "";
            try {
                if (MAJOR_VERSION_NUMBER >= 11) {
                    player.sendTitle(title, subtitle, 10, 70, 20);
                } else if (MAJOR_VERSION_NUMBER >= 8) {
                    player.sendTitle(title, subtitle);
                }
            }
            catch (NoSuchMethodError e) {
                try {
                    Class.forName("net.kyori.adventure.title.Title");
                    Method showTitleMethod = player.getClass().getMethod("showTitle", Class.forName("net.kyori.adventure.title.Title"));
                    Object titleComponent = Class.forName("net.kyori.adventure.text.Component").getMethod("text", String.class).invoke(null, title);
                    Object subtitleComponent = Class.forName("net.kyori.adventure.text.Component").getMethod("text", String.class).invoke(null, subtitle);
                    Object titleObject = Class.forName("net.kyori.adventure.title.Title").getMethod("title", Class.forName("net.kyori.adventure.text.Component"), Class.forName("net.kyori.adventure.text.Component")).invoke(null, titleComponent, subtitleComponent);
                    showTitleMethod.invoke((Object)player, titleObject);
                }
                catch (Exception ignored) {
                    player.sendMessage(title);
                    if (subtitle.isEmpty()) break block7;
                    player.sendMessage(subtitle);
                }
            }
        }
    }
}

