/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final String pomLink;
    private final String downloadLink;
    private final String notificationPermission;
    private final String chatHeader;
    private volatile String version;
    private Boolean updateNeeded = null;
    private FutureTask<Boolean> updateCheckerFutureTask;

    public UpdateChecker(JavaPlugin plugin, String pomLink, String notificationPermission, String chatHeader, String downloadLink) {
        this.plugin = plugin;
        this.pomLink = pomLink;
        this.notificationPermission = notificationPermission;
        this.chatHeader = chatHeader;
        this.downloadLink = downloadLink;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.isUpdateNeeded() && event.getPlayer().hasPermission(this.notificationPermission)) {
            event.getPlayer().sendMessage(this.chatHeader + this.plugin.getDescription().getName() + " update available: v" + this.version + ". Download at " + this.downloadLink);
        }
    }

    public void launchUpdateCheckerTask() {
        this.updateCheckerFutureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return UpdateChecker.this.checkForUpdate();
            }
        });
        new Thread(this.updateCheckerFutureTask).start();
    }

    public boolean isUpdateNeeded() {
        if (this.updateNeeded == null) {
            if (this.updateCheckerFutureTask.isDone()) {
                try {
                    this.updateNeeded = this.updateCheckerFutureTask.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.updateNeeded = false;
                    this.plugin.getLogger().severe("Error while checking for " + this.plugin.getDescription().getName() + " update.");
                }
            } else {
                return false;
            }
        }
        return this.updateNeeded;
    }

    public String getVersion() {
        return this.version;
    }

    private boolean checkForUpdate() throws SAXException, IOException, ParserConfigurationException {
        this.plugin.getLogger().info("Checking for plugin update...");
        Document document = null;
        URL filesFeed = new URL(this.pomLink);
        try (InputStream pomInput = filesFeed.openConnection().getInputStream();){
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pomInput);
        }
        this.version = document.getElementsByTagName("version").item(0).getTextContent();
        if (this.version.equals(this.plugin.getDescription().getVersion())) {
            return false;
        }
        String[] pluginVersion = this.plugin.getDescription().getVersion().split("\\.");
        String[] onlineVersion = this.version.split("\\.");
        for (int i = 0; i < Math.min(pluginVersion.length, onlineVersion.length); ++i) {
            if (Integer.parseInt(pluginVersion[i]) > Integer.parseInt(onlineVersion[i])) {
                return false;
            }
            if (Integer.parseInt(pluginVersion[i]) >= Integer.parseInt(onlineVersion[i])) continue;
            this.logUpdate();
            return true;
        }
        if (pluginVersion.length < onlineVersion.length) {
            this.logUpdate();
            return true;
        }
        return false;
    }

    private void logUpdate() {
        this.plugin.getLogger().warning("Update available: v" + this.version + "! Download at " + this.downloadLink);
    }
}

