/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.worldguard.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.particle.FancyMessageSender;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMove
implements Listener {
    private AntiWorldFly plugin;

    public PlayerMove(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocessEvent(PlayerMoveEvent event) {
        LocalPlayer localPlayer;
        Location toBlock;
        Location fromBlock;
        if (event.getTo() != null && (fromBlock = event.getFrom().getBlock().getLocation()).equals((Object)(toBlock = event.getTo().getBlock().getLocation()))) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isDisabled() || player.hasPermission("antiworldfly.fly." + player.getWorld().getName()) || !player.getPlayer().isFlying()) {
            return;
        }
        if (!this.plugin.isAntiFlyCreative() && event.getPlayer().getGameMode() == GameMode.CREATIVE || "SPECTATOR".equals(event.getPlayer().getGameMode().toString())) {
            return;
        }
        StateFlag flag = (StateFlag)WorldGuard.getInstance().getFlagRegistry().get(this.plugin.getAntiFlyFlag());
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)player.getLocation()));
        if (!set.testState((RegionAssociable)(localPlayer = WorldGuardPlugin.inst().wrapPlayer(player)), new StateFlag[]{flag})) {
            player.setAllowFlight(false);
            player.getPlayer().setFlying(false);
            event.setCancelled(true);
            if (this.plugin.isChatMessage()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("fly-disabled-region", "Flying is disabled in this region."));
            }
            if (this.plugin.isTitleMessage()) {
                try {
                    FancyMessageSender.sendTitle(player, this.plugin.getPluginLang().getString("fly-disabled-title", "&9AntiWorldFly"), this.plugin.getPluginLang().getString("fly-disabled-region", "Flying is disabled in this region."));
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Errors while trying to display flying disabled title: ", e);
                }
            }
        }
    }
}

