/*
 * Decompiled with CFR 0.152.
 */
package com.hm.antiworldfly.worldguard.listener;

import com.hm.antiworldfly.AntiWorldFly;
import com.hm.antiworldfly.particle.FancyMessageSender;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;

public class RegionToggleGlide
implements Listener {
    private final AntiWorldFly plugin;

    public RegionToggleGlide(AntiWorldFly awf) {
        this.plugin = awf;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityToggleGlideEvent(EntityToggleGlideEvent event) {
        LocalPlayer localPlayer;
        Entity entity = event.getEntity();
        if (!entity.getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Player player = (Player)entity;
        if (this.plugin.isDisabled() || entity.hasPermission("antiworldfly.elytra." + entity.getWorld().getName()) || !this.plugin.isAntiFlyCreative() && player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        StateFlag flag = (StateFlag)WorldGuard.getInstance().getFlagRegistry().get(this.plugin.getAntiElytraFlag());
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)player.getLocation()));
        if (!set.testState((RegionAssociable)(localPlayer = WorldGuardPlugin.inst().wrapPlayer(player)), new StateFlag[]{flag})) {
            event.setCancelled(true);
            if (this.plugin.isChatMessage()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("elytra-disabled-region", "Elytras are disabled in this region."));
            }
            if (this.plugin.isTitleMessage()) {
                try {
                    FancyMessageSender.sendTitle(player, this.plugin.getPluginLang().getString("fly-disabled-title", "&9AntiWorldFly"), this.plugin.getPluginLang().getString("elytra-disabled-region", "Elytras are disabled in this region."));
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Errors while trying to display flying disabled title: ", e);
                }
            }
        }
    }
}

