/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix;

import com.google.common.collect.Collections2;
import com.loohp.lotterysix.Commands;
import com.loohp.lotterysix.config.Config;
import com.loohp.lotterysix.debug.Debug;
import com.loohp.lotterysix.discordsrv.DiscordSRVHook;
import com.loohp.lotterysix.events.LotterySixEvent;
import com.loohp.lotterysix.events.PlayerBetEvent;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.gui.LotteryPluginGUI;
import com.loohp.lotterysix.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.lotterysix.metrics.Charts;
import com.loohp.lotterysix.metrics.Metrics;
import com.loohp.lotterysix.placeholderapi.LotteryPlaceholders;
import com.loohp.lotterysix.pluginmessaging.PluginMessageHandler;
import com.loohp.lotterysix.updater.Updater;
import com.loohp.lotterysix.utils.ChatColorUtils;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.MCVersion;
import com.loohp.lotterysix.utils.StringUtils;
import com.loohp.lotterysix.utils.TitleUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class LotterySixPlugin
extends JavaPlugin
implements Listener {
    public static final int BSTATS_PLUGIN_ID = 17516;
    public static final String CONFIG_ID = "config";
    public static LotterySixPlugin plugin;
    public static String exactMinecraftVersion;
    public static MCVersion version;
    public static DiscordSRVHook discordSRVHook;
    public static boolean hasFloodgate;
    private static PluginMessageHandler pluginMessageHandler;
    private static LotterySix instance;
    private static LotteryPluginGUI guiProvider;
    private static Economy econ;
    private static Permission perms;
    public static BossBar activeBossBar;

    public void onEnable() {
        plugin = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        Metrics metrics = new Metrics(this, 17516);
        exactMinecraftVersion = Bukkit.getVersion().substring(Bukkit.getVersion().indexOf("(") + 5, Bukkit.getVersion().indexOf(")"));
        version = MCVersion.resolve();
        if (!version.isSupported()) {
            this.getServer().getConsoleSender().sendMessage(org.bukkit.ChatColor.RED + "[LotterySix] This version of minecraft is unsupported! (" + version.toString() + ")");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new Debug(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        try {
            Config.loadConfig(CONFIG_ID, new File(this.getDataFolder(), "config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        econ = (Economy)this.getServer().getServicesManager().getRegistration(Economy.class).getProvider();
        perms = (Permission)this.getServer().getServicesManager().getRegistration(Permission.class).getProvider();
        this.getCommand("lotterysix").setExecutor((CommandExecutor)new Commands());
        instance = new LotterySix(true, this.getDataFolder(), CONFIG_ID, (p, a) -> LotterySixPlugin.takeMoneyOnline(p, a), (p, a) -> LotterySixPlugin.giveMoneyNow(p, a), p -> LotterySixPlugin.notifyOfflineBalanceChange(p), (uuid, permission) -> {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.isOnline()) {
                return player.getPlayer().hasPermission(permission);
            }
            return perms.playerHas(((World)Bukkit.getWorlds().get(0)).getName(), Bukkit.getOfflinePlayer((UUID)uuid), permission);
        }, lock -> {
            if (lock.booleanValue()) {
                LotterySixPlugin.forceCloseAllGui();
            }
        }, () -> Collections2.transform((Collection)Bukkit.getOnlinePlayers(), p -> p.getUniqueId()), (uuid, message, hover, game) -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                if (game instanceof PlayableLotterySixGame) {
                    message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, instance, (PlayableLotterySixGame)game);
                    if (!hover.isEmpty()) {
                        hover = LotteryUtils.formatPlaceholders((OfflinePlayer)player, hover, instance, (PlayableLotterySixGame)game);
                    }
                } else if (game instanceof CompletedLotterySixGame) {
                    message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, instance, (CompletedLotterySixGame)game);
                    if (!hover.isEmpty()) {
                        hover = LotteryUtils.formatPlaceholders((OfflinePlayer)player, hover, instance, (CompletedLotterySixGame)game);
                    }
                }
                TextComponent textComponent = new TextComponent(ChatColorUtils.translateAlternateColorCodes('&', message));
                if (!hover.isEmpty()) {
                    textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColorUtils.translateAlternateColorCodes('&', hover))}));
                }
                player.spigot().sendMessage((BaseComponent)textComponent);
            }
        }, (uuid, message, hover, game) -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                if (game instanceof PlayableLotterySixGame) {
                    message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, instance, (PlayableLotterySixGame)game);
                } else if (game instanceof CompletedLotterySixGame) {
                    message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, instance, (CompletedLotterySixGame)game);
                }
                TitleUtils.sendTitle(player, ChatColorUtils.translateAlternateColorCodes('&', PlaceholderAPI.setPlaceholders((Player)player, (String)message)), "", 10, 100, 20);
            }
        }, (uuid, result, price, bets) -> {
            for (PlayerBets bet : bets) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerBetEvent(instance.getLotteryPlayerManager().getLotteryPlayer(uuid), bet.getChosenNumbers(), price, result));
            }
        }, playerBets -> {}, action -> {
            Bukkit.getPluginManager().callEvent((Event)new LotterySixEvent(instance, (LotterySixAction)((Object)action)));
            LotterySixPlugin.forceCloseAllGui();
        }, lotteryPlayer -> {}, message -> Bukkit.getConsoleSender().sendMessage(message), (bossBarInfo, game) -> {
            if (activeBossBar == null) {
                return;
            }
            String message = bossBarInfo.getMessage();
            if (message == null) {
                activeBossBar.setVisible(false);
                return;
            }
            activeBossBar.setVisible(true);
            activeBossBar.setProgress(bossBarInfo.getProgress());
            activeBossBar.setColor(BarColor.valueOf((String)bossBarInfo.getColor()));
            activeBossBar.setStyle(BarStyle.valueOf((String)bossBarInfo.getStyle()));
            if (game instanceof PlayableLotterySixGame) {
                message = LotteryUtils.formatPlaceholders(null, message, instance, (PlayableLotterySixGame)game);
            } else if (game instanceof CompletedLotterySixGame) {
                message = LotteryUtils.formatPlaceholders(null, message, instance, (CompletedLotterySixGame)game);
            }
            activeBossBar.setTitle(message);
        });
        instance.reloadConfig();
        if (LotterySixPlugin.instance.backendBungeecordMode) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[LotterySix] Registering Plugin Messaging Channels for Bungeecord...");
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "lotterysix:main");
            pluginMessageHandler = new PluginMessageHandler(instance);
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "lotterysix:main", (PluginMessageListener)pluginMessageHandler);
        }
        guiProvider = new LotteryPluginGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)guiProvider, (Plugin)this);
        Charts.setup(metrics);
        new LotteryPlaceholders().register();
        if (this.getServer().getPluginManager().isPluginEnabled("DiscordSRV")) {
            discordSRVHook = new DiscordSRVHook();
            this.getServer().getPluginManager().registerEvents((Listener)discordSRVHook, (Plugin)this);
            this.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[LotterySix] LotterySix has hooked into DiscordSRV!");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("floodgate")) {
            hasFloodgate = true;
            this.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[LotterySix] LotterySix has hooked into Floodgate!");
        }
        if (LotterySixPlugin.instance.updaterEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new Updater(), (Plugin)this);
        }
        if (activeBossBar != null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (activeBossBar.getPlayers().contains(player)) continue;
                activeBossBar.addPlayer(player);
            }
        }
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[LotterySix] LotterySix has been Enabled!");
    }

    public void onDisable() {
        instance.close();
        if (discordSRVHook != null) {
            discordSRVHook.expireAllHooks(true);
        }
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[LotterySix] LotterySix has been Disabled!");
    }

    public static LotterySix getInstance() {
        return instance;
    }

    public static LotteryPluginGUI getGuiProvider() {
        return guiProvider;
    }

    public static PluginMessageHandler getPluginMessageHandler() {
        return pluginMessageHandler;
    }

    public static Economy getEcon() {
        return econ;
    }

    public static Permission getPerms() {
        return perms;
    }

    public static boolean giveMoneyNow(UUID uuid, long amount) {
        return econ.depositPlayer(Bukkit.getOfflinePlayer((UUID)uuid), (double)amount).transactionSuccess();
    }

    public static boolean takeMoneyOnline(UUID uuid, long amount) {
        double currentBalance;
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return false;
        }
        if (!LotterySixPlugin.instance.allowLoans && (currentBalance = econ.getBalance((OfflinePlayer)player)) - (double)amount < 0.0) {
            return false;
        }
        return econ.withdrawPlayer((OfflinePlayer)player, (double)amount).transactionSuccess();
    }

    public static void forceCloseAllGui() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Scheduler.executeOrScheduleSync((Plugin)plugin, () -> guiProvider.forceClose(player), (Entity)player);
        }
    }

    public static void notifyOfflineBalanceChange(UUID uuid) {
        LotterySixPlugin.notifyOfflineBalanceChange(instance.getLotteryPlayerManager().getLotteryPlayer(uuid));
    }

    public static void notifyOfflineBalanceChange(LotteryPlayer lotteryPlayer) {
        Player player = Bukkit.getPlayer((UUID)lotteryPlayer.getPlayer());
        if (player != null) {
            Long money = lotteryPlayer.getStats(PlayerStatsKey.PENDING_TRANSACTION, Long.TYPE);
            boolean notifyAnyway = false;
            if (money != null && money > 0L) {
                lotteryPlayer.setStats(PlayerStatsKey.PENDING_TRANSACTION, 0L);
                lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + money);
                notifyAnyway = true;
            }
            long changed = lotteryPlayer.getStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE);
            if (notifyAnyway || changed != 0L) {
                lotteryPlayer.setStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, 0L);
                player.sendMessage(LotterySixPlugin.instance.messageNotifyBalanceChange.replace("{Amount}", StringUtils.formatComma(changed)));
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (activeBossBar != null) {
            activeBossBar.addPlayer(event.getPlayer());
        }
        Scheduler.runTaskAsynchronously((Plugin)this, () -> {
            LotteryPlayer lotteryPlayer = instance.getLotteryPlayerManager().loadLotteryPlayer(event.getPlayer().getUniqueId(), true);
            if (!LotterySixPlugin.instance.backendBungeecordMode) {
                Scheduler.runTaskLaterAsynchronously((Plugin)this, () -> LotterySixPlugin.notifyOfflineBalanceChange(lotteryPlayer), 20L);
            }
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        if (activeBossBar != null) {
            activeBossBar.removePlayer(event.getPlayer());
        }
        Scheduler.runTaskAsynchronously((Plugin)this, () -> instance.getLotteryPlayerManager().unloadLotteryPlayer(event.getPlayer().getUniqueId(), true));
    }

    static {
        discordSRVHook = null;
        hasFloodgate = false;
        econ = null;
        perms = null;
        try {
            activeBossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        }
        catch (Throwable e) {
            activeBossBar = null;
        }
    }
}

