/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.discordsrv;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.discordsrv.DiscordInteraction;
import com.loohp.lotterysix.discordsrv.menus.BettingAccountInteraction;
import com.loohp.lotterysix.discordsrv.menus.NumberStatisticsInteraction;
import com.loohp.lotterysix.discordsrv.menus.PastDrawInteraction;
import com.loohp.lotterysix.discordsrv.menus.PlaceBetInteraction;
import com.loohp.lotterysix.discordsrv.menus.ViewBetsInteraction;
import com.loohp.lotterysix.events.LotterySixEvent;
import com.loohp.lotterysix.events.PlayerBetEvent;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.StringUtils;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.commands.PluginSlashCommand;
import github.scarsz.discordsrv.api.commands.SlashCommand;
import github.scarsz.discordsrv.api.commands.SlashCommandProvider;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emoji;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.SlashCommandEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.InteractionHook;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.CommandData;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Button;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.WebhookMessageUpdateAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.AttachmentOption;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DiscordSRVHook
extends ListenerAdapter
implements Listener,
SlashCommandProvider {
    public static final String SLASH_COMMAND_LABEL = "lottery";
    public static final String INTERACTION_LABEL_PREFIX = "ls_";
    public static final String MAIN_MENU_LABEL = "ls_main_menu";
    public static final String NEW_MAIN_MENU_LABEL = "ls_new_main_menu";
    private final Map<UUID, InteractionHook> bungeecordPendingAddBet = new ConcurrentHashMap<UUID, InteractionHook>();
    private final Map<String, DiscordInteraction> interactionMap = new LinkedHashMap<String, DiscordInteraction>();
    private final Map<String, InteractionHookData> activeInteractionHooks;
    private byte[] advertisementImage;
    private boolean init;

    public static List<ActionRow> buildActionRows(Collection<DiscordInteraction> interactions, String discordUserId) {
        UUID uuid = discordUserId == null ? null : DiscordSRV.getPlugin().getAccountLinkManager().getUuid(discordUserId);
        ArrayList<ActionRow> actionRows = new ArrayList<ActionRow>(5);
        ArrayList<Component> currentRow = new ArrayList<Component>(5);
        for (DiscordInteraction interaction : interactions) {
            if (uuid == null && interaction.requireAccountLinked()) continue;
            if (interaction.doOccupyEntireRow(uuid)) {
                if (!currentRow.isEmpty()) {
                    actionRows.add(ActionRow.of(currentRow));
                    currentRow = new ArrayList(5);
                }
                actionRows.addAll(interaction.getActionRows(uuid));
                continue;
            }
            for (ActionRow row : interaction.getActionRows(uuid)) {
                for (Component component : row) {
                    if (currentRow.size() >= component.getType().getMaxPerRow()) {
                        actionRows.add(ActionRow.of(currentRow));
                        currentRow = new ArrayList(5);
                    }
                    currentRow.add(component);
                }
            }
        }
        if (!currentRow.isEmpty()) {
            actionRows.add(ActionRow.of(currentRow));
        }
        return actionRows.subList(0, Math.min(5, actionRows.size()));
    }

    public DiscordSRVHook() {
        Cache activeInteractionHooks = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.activeInteractionHooks = activeInteractionHooks.asMap();
        this.advertisementImage = null;
        this.registerInteraction(new BettingAccountInteraction());
        this.registerInteraction(new PastDrawInteraction());
        this.registerInteraction(new ViewBetsInteraction());
        this.registerInteraction(new PlaceBetInteraction());
        this.registerInteraction(new NumberStatisticsInteraction());
        DiscordSRV.api.subscribe((Object)this);
        if (DiscordSRV.isReady) {
            this.init = true;
            DiscordSRV.api.addSlashCommandProvider((SlashCommandProvider)this);
            DiscordSRV.getPlugin().getJda().addEventListener(new Object[]{new JDAEvents()});
            this.reload();
        } else {
            this.init = false;
        }
    }

    public void addBungeecordPendingBets(UUID uuid, InteractionHook hook) {
        this.bungeecordPendingAddBet.put(uuid, hook);
    }

    private void registerInteraction(DiscordInteraction interaction) {
        this.interactionMap.put(interaction.getInteractionLabelStartWith(), interaction);
    }

    public void reload() {
        DiscordSRV.api.updateSlashCommands();
    }

    public byte[] getAdvertisementImage() {
        return this.advertisementImage;
    }

    public void setAdvertisementImage(byte[] advertisementImage) {
        this.advertisementImage = advertisementImage;
    }

    public Button getMainMenuButton() {
        return Button.secondary((String)MAIN_MENU_LABEL, (String)LotterySixPlugin.getInstance().discordSRVSlashCommandsGlobalComponentsBack).withEmoji(Emoji.fromUnicode((String)"\u23ee\ufe0f"));
    }

    public MessageEmbed getGenericEmbed(String message, Color color) {
        return new EmbedBuilder().setAuthor(message).setColor(color).build();
    }

    @Subscribe
    public void onDiscordReady(DiscordReadyEvent event) {
        if (!this.init) {
            DiscordSRV.api.addSlashCommandProvider((SlashCommandProvider)this);
            DiscordSRV.getPlugin().getJda().addEventListener(new Object[]{new JDAEvents()});
            this.reload();
            this.init = true;
        }
    }

    public void expireAllHooks(boolean immediately) {
        ArrayList<RestAction> actions = new ArrayList<RestAction>();
        for (InteractionHookData data : this.activeInteractionHooks.values()) {
            InteractionHook interactionHook = data.getInteractionHook();
            if (!interactionHook.isExpired()) {
                actions.add(interactionHook.editOriginalEmbeds(new MessageEmbed[]{this.getGenericEmbed(LotterySixPlugin.getInstance().discordSRVSlashCommandsGlobalMessagesTimeOut, Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).setCheck(() -> !interactionHook.isExpired()));
            }
            this.activeInteractionHooks.remove(data.getMessageId());
        }
        if (!actions.isEmpty()) {
            if (immediately) {
                RestAction.allOf(actions).complete();
            } else {
                RestAction.allOf(actions).queue();
            }
        }
    }

    @EventHandler
    public void onLotteryAction(LotterySixEvent event) {
        if (event.getAction().equals((Object)LotterySixAction.RUN_LOTTERY_FINISH)) {
            LotterySix lotterySix = event.getLotterySix();
            CompletedLotterySixGame game = lotterySix.getCompletedGames().get(0);
            TextChannel channel = DiscordSRV.getPlugin().getOptionalTextChannel(lotterySix.discordSRVDrawResultAnnouncementChannel);
            if (channel != null) {
                EmbedBuilder builder = new EmbedBuilder().setColor(Color.YELLOW).setTitle(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(null, lotterySix.discordSRVDrawResultAnnouncementTitle, lotterySix, game))).setDescription((CharSequence)ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(null, lotterySix.discordSRVDrawResultAnnouncementDescription, lotterySix, game))).setThumbnail(lotterySix.discordSRVDrawResultAnnouncementThumbnailURL);
                if (this.advertisementImage != null) {
                    builder.setImage("attachment://image.png");
                }
                MessageAction action = channel.sendMessageEmbeds(builder.build(), new MessageEmbed[0]);
                if (this.advertisementImage != null) {
                    action = action.addFile(this.advertisementImage, "image.png", new AttachmentOption[0]);
                }
                if (lotterySix.discordSRVSlashCommandsEnableLotteryCommand) {
                    Button button = Button.success((String)NEW_MAIN_MENU_LABEL, (String)lotterySix.discordSRVSlashCommandsGlobalTitle).withEmoji(Emoji.fromUnicode((String)"\u2139\ufe0f"));
                    action = action.setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{button})});
                }
                action.queue();
            }
        }
        this.expireAllHooks(false);
    }

    @EventHandler
    public void onPlaceBet(PlayerBetEvent event) {
        LotteryPlayer lotteryPlayer;
        UUID uuid;
        InteractionHook hook;
        LotterySix lotterySix = LotterySixPlugin.getInstance();
        if (lotterySix.backendBungeecordMode && (hook = this.bungeecordPendingAddBet.remove(uuid = (lotteryPlayer = event.getPlayer()).getPlayer())) != null) {
            PlayableLotterySixGame game = lotterySix.getCurrentGame();
            if (game == null) {
                hook.editOriginalEmbeds(new MessageEmbed[]{this.getGenericEmbed(lotterySix.discordSRVSlashCommandsPlaceBetNoGame, Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).queue();
                return;
            }
            String message = "";
            Color color = Color.DARK_GRAY;
            long price = event.getPrice();
            switch (event.getResult()) {
                case SUCCESS: {
                    message = lotterySix.messageBetPlaced.replace("{Price}", StringUtils.formatComma(price));
                    color = Color.GREEN;
                    break;
                }
                case GAME_LOCKED: {
                    message = lotterySix.messageGameLocked.replace("{Price}", StringUtils.formatComma(price));
                    color = Color.RED;
                    break;
                }
                case NOT_ENOUGH_MONEY: {
                    message = lotterySix.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(price));
                    color = Color.RED;
                    break;
                }
                case LIMIT_SELF: {
                    message = lotterySix.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(price));
                    color = Color.RED;
                    break;
                }
                case LIMIT_PERMISSION: {
                    message = lotterySix.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(price));
                    color = Color.RED;
                    break;
                }
                case LIMIT_CHANCE_PER_SELECTION: {
                    message = lotterySix.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(price));
                    color = Color.RED;
                    break;
                }
                case ACCOUNT_SUSPENDED: {
                    long time = lotteryPlayer.getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                    message = lotterySix.messageBettingAccountSuspended.replace("{Date}", lotterySix.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(price));
                    color = Color.RED;
                    break;
                }
            }
            hook.editOriginalEmbeds(new MessageEmbed[]{this.getGenericEmbed(ChatColor.stripColor((String)message), color)}).setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{this.getMainMenuButton()})}).retainFiles(Collections.emptyList()).queue();
        }
    }

    public Set<PluginSlashCommand> getSlashCommands() {
        if (!LotterySixPlugin.getInstance().discordSRVSlashCommandsEnableLotteryCommand) {
            return Collections.emptySet();
        }
        return Collections.singleton(new PluginSlashCommand((Plugin)LotterySixPlugin.plugin, new CommandData(SLASH_COMMAND_LABEL, LotterySixPlugin.getInstance().discordSRVSlashCommandsGlobalDescription), new String[]{DiscordSRV.getPlugin().getMainGuild().getId()}));
    }

    @SlashCommand(path="*")
    public void onSlashCommand(SlashCommandEvent event) {
        if (!LotterySixPlugin.getInstance().discordSRVSlashCommandsEnableLotteryCommand) {
            return;
        }
        Guild guild = DiscordSRV.getPlugin().getMainGuild();
        if (event.getGuild().getIdLong() != guild.getIdLong()) {
            return;
        }
        if (!(event.getChannel() instanceof TextChannel)) {
            return;
        }
        String label = event.getName();
        if (label.equals(SLASH_COMMAND_LABEL)) {
            event.deferReply(true).queue();
            if (LotterySixPlugin.getInstance().isGameLocked()) {
                event.getHook().editOriginalEmbeds(new MessageEmbed[]{this.getGenericEmbed(ChatColor.stripColor((String)LotterySixPlugin.getInstance().messageGameLocked), Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).queue();
            } else {
                this.handle((GenericInteractionCreateEvent)event, true);
            }
        }
    }

    private void handle(GenericInteractionCreateEvent event, boolean entryPoint) {
        LotterySix lotterySix = LotterySixPlugin.getInstance();
        String discordUserId = event.getUser().getId();
        PlayableLotterySixGame game = lotterySix.getCurrentGame();
        String description = game == null ? ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(null, lotterySix.discordSRVSlashCommandsGlobalSubTitleNoGame, lotterySix, lotterySix.getCurrentGame())) : ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(null, lotterySix.discordSRVSlashCommandsGlobalSubTitleActiveGame, lotterySix, lotterySix.getCurrentGame()));
        EmbedBuilder builder = new EmbedBuilder().setTitle(lotterySix.discordSRVSlashCommandsGlobalTitle).setDescription((CharSequence)description).setColor(Color.YELLOW).setThumbnail(lotterySix.discordSRVSlashCommandsGlobalThumbnailURL);
        if (this.advertisementImage != null && game != null) {
            builder.setImage("attachment://image.png");
        }
        WebhookMessageUpdateAction action = event.getHook().editOriginalEmbeds(new MessageEmbed[]{builder.build()}).setActionRows(DiscordSRVHook.buildActionRows(this.interactionMap.values(), discordUserId)).retainFiles(Collections.emptyList());
        if (this.advertisementImage != null && game != null) {
            action = action.addFile(this.advertisementImage, "image.png", new AttachmentOption[0]);
        }
        if (entryPoint) {
            action.queue(message -> this.activeInteractionHooks.put(message.getId(), new InteractionHookData(message.getId(), game, event.getHook())));
        } else {
            action.queue();
        }
    }

    public class JDAEvents
    extends ListenerAdapter {
        public void onGenericComponentInteractionCreate(GenericComponentInteractionCreateEvent event) {
            if (!LotterySixPlugin.getInstance().discordSRVSlashCommandsEnableLotteryCommand) {
                return;
            }
            Component component = event.getComponent();
            if (component == null) {
                return;
            }
            String id = component.getId();
            if (id == null || !id.startsWith(DiscordSRVHook.INTERACTION_LABEL_PREFIX)) {
                return;
            }
            if (id.equals(DiscordSRVHook.NEW_MAIN_MENU_LABEL)) {
                event.deferReply(true).queue();
                if (LotterySixPlugin.getInstance().isGameLocked()) {
                    event.getHook().editOriginalEmbeds(new MessageEmbed[]{DiscordSRVHook.this.getGenericEmbed(ChatColor.stripColor((String)LotterySixPlugin.getInstance().messageGameLocked), Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).queue();
                } else {
                    DiscordSRVHook.this.handle((GenericInteractionCreateEvent)event, true);
                }
                return;
            }
            event.deferEdit().queue();
            if (LotterySixPlugin.getInstance().isGameLocked()) {
                event.getHook().editOriginalEmbeds(new MessageEmbed[]{DiscordSRVHook.this.getGenericEmbed(ChatColor.stripColor((String)LotterySixPlugin.getInstance().messageGameLocked), Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).queue();
            } else {
                PlayableLotterySixGame game = LotterySixPlugin.getInstance().getCurrentGame();
                InteractionHookData data = (InteractionHookData)DiscordSRVHook.this.activeInteractionHooks.get(event.getMessageId());
                if (data == null || !data.compareCurrentGame(game)) {
                    event.getHook().editOriginalEmbeds(new MessageEmbed[]{DiscordSRVHook.this.getGenericEmbed(LotterySixPlugin.getInstance().discordSRVSlashCommandsGlobalMessagesTimeOut, Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).queue();
                    return;
                }
                data.setInteractionHook(event.getHook());
                try {
                    if (id.startsWith(DiscordSRVHook.MAIN_MENU_LABEL)) {
                        DiscordSRVHook.this.handle((GenericInteractionCreateEvent)event, false);
                        return;
                    }
                    for (DiscordInteraction interaction : DiscordSRVHook.this.interactionMap.values()) {
                        if (!id.startsWith(interaction.getInteractionLabelStartWith())) continue;
                        interaction.handle(event);
                        return;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                event.getHook().editOriginalEmbeds(new MessageEmbed[]{DiscordSRVHook.this.getGenericEmbed(LotterySixPlugin.getInstance().discordSRVSlashCommandsGlobalMessagesUnknownError, Color.RED)}).setActionRows(new ActionRow[0]).retainFiles(Collections.emptyList()).queue();
            }
        }
    }

    public static class InteractionHookData {
        private final String messageId;
        private final UUID currentGameId;
        private InteractionHook interactionHook;

        public InteractionHookData(String messageId, PlayableLotterySixGame currentGame, InteractionHook interactionHook) {
            this.messageId = messageId;
            this.currentGameId = currentGame == null ? null : currentGame.getGameId();
            this.interactionHook = interactionHook;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public UUID getCurrentGameId() {
            return this.currentGameId;
        }

        public boolean compareCurrentGame(PlayableLotterySixGame game) {
            return Objects.equals(game == null ? null : game.getGameId(), this.currentGameId);
        }

        public InteractionHook getInteractionHook() {
            return this.interactionHook;
        }

        public void setInteractionHook(InteractionHook interactionHook) {
            this.interactionHook = interactionHook;
        }
    }
}

