/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.discordsrv.menus;

import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.discordsrv.DiscordInteraction;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.StringUtils;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Emoji;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Button;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.WebhookMessageUpdateAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.AttachmentOption;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class ViewBetsInteraction
extends DiscordInteraction {
    public static final String INTERACTION_LABEL = "ls_view_bets";

    public ViewBetsInteraction() {
        super(INTERACTION_LABEL, false);
    }

    @Override
    public boolean doOccupyEntireRow(UUID uuid) {
        return false;
    }

    @Override
    public List<ActionRow> getActionRows(UUID uuid) {
        Button button = Button.success((String)INTERACTION_LABEL, (String)ViewBetsInteraction.instance.discordSRVSlashCommandsViewCurrentBetsTitle).withEmoji(Emoji.fromUnicode((String)"\ud83c\udfab"));
        if (instance.getCurrentGame() == null) {
            button = button.asDisabled();
        }
        return Collections.singletonList(ActionRow.of((Component[])new Component[]{button}));
    }

    @Override
    public void handle(GenericComponentInteractionCreateEvent event) {
        String discordUserId = event.getUser().getId();
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(discordUserId);
        PlayableLotterySixGame game = instance.getCurrentGame();
        if (game == null) {
            event.getHook().editOriginalEmbeds(new MessageEmbed[]{ViewBetsInteraction.getGenericEmbed(ViewBetsInteraction.instance.discordSRVSlashCommandsViewCurrentBetsNoGame, Color.RED)}).setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{ViewBetsInteraction.getMainMenuButton()})}).retainFiles(Collections.emptyList()).queue();
        } else {
            OfflinePlayer player = uuid == null ? null : Bukkit.getOfflinePlayer((UUID)uuid);
            StringBuilder sb = new StringBuilder();
            for (String string : ViewBetsInteraction.instance.discordSRVSlashCommandsViewCurrentBetsSubTitle) {
                sb.append(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(player, string, instance, game))).append("\n");
            }
            if (uuid != null) {
                List<PlayerBets> bets;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                if ((bets = game.getPlayerBets(uuid)).isEmpty()) {
                    sb.append(ViewBetsInteraction.instance.discordSRVSlashCommandsViewCurrentBetsNoBets);
                } else {
                    for (PlayerBets bet : bets) {
                        StringBuilder str = new StringBuilder();
                        if (bet.isMultipleDraw()) {
                            str.append("**").append(bet.getChosenNumbers().toString().replace("/ ", "/\n")).append("**\n").append(ChatColor.stripColor((String)ViewBetsInteraction.instance.ticketDescriptionMultipleDraw.replace("{Price}", StringUtils.formatComma(bet.getBet())).replace("{UnitPrice}", StringUtils.formatComma(ViewBetsInteraction.instance.pricePerBet / (long)bet.getType().getDivisor())).replace("{DrawsRemaining}", StringUtils.formatComma(bet.getDrawsRemaining())).replace("{MultipleDraw}", StringUtils.formatComma(bet.getMultipleDraw())))).append("\n\n");
                        } else {
                            str.append("**").append(bet.getChosenNumbers().toString().replace("/ ", "/\n")).append("**\n").append(ChatColor.stripColor((String)ViewBetsInteraction.instance.ticketDescription.replace("{Price}", StringUtils.formatComma(bet.getBet())).replace("{UnitPrice}", StringUtils.formatComma(ViewBetsInteraction.instance.pricePerBet / (long)bet.getType().getDivisor())))).append("\n\n");
                        }
                        if (str.length() + sb.length() < 4090) {
                            sb.append((CharSequence)str);
                            continue;
                        }
                        sb.append("...");
                        break;
                    }
                }
            }
            String description = sb.charAt(sb.length() - 1) == '\n' ? sb.substring(0, sb.length() - 1) : sb.toString();
            EmbedBuilder embedBuilder = new EmbedBuilder().setColor(Color.GREEN).setTitle(ChatColor.stripColor((String)LotteryUtils.formatPlaceholders(player, ViewBetsInteraction.instance.discordSRVSlashCommandsViewCurrentBetsTitle, instance, game))).setDescription((CharSequence)description).setThumbnail(ViewBetsInteraction.instance.discordSRVSlashCommandsViewCurrentBetsThumbnailURL);
            byte[] advertisementImage = LotterySixPlugin.discordSRVHook.getAdvertisementImage();
            if (advertisementImage != null) {
                embedBuilder.setImage("attachment://image.png");
            }
            WebhookMessageUpdateAction action = event.getHook().editOriginalEmbeds(new MessageEmbed[]{embedBuilder.build()}).setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{ViewBetsInteraction.getMainMenuButton()})}).retainFiles(Collections.emptyList());
            if (advertisementImage != null) {
                action = action.addFile(advertisementImage, "image.png", new AttachmentOption[0]);
            }
            action.queue();
        }
    }
}

