/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.floodgate;

import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XMaterial;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.floodgate.api.FloodgateApi;

public class FloodgateHook {
    private static final Material MATERIAL_WRITTEN_BOOK = XMaterial.WRITTEN_BOOK.parseMaterial();

    public static boolean isBedrockPlayer(UUID uuid) {
        if (!LotterySixPlugin.hasFloodgate) {
            return false;
        }
        return FloodgateApi.getInstance().isFloodgatePlayer(uuid);
    }

    public static void sendAlternateBook(UUID uuid, ItemStack book) {
        if (!FloodgateHook.isBedrockPlayer(uuid)) {
            throw new IllegalArgumentException("uuid is not a bedrock player");
        }
        if (book == null) {
            throw new IllegalArgumentException("Book cannot be null");
        }
        if (!book.getType().equals((Object)MATERIAL_WRITTEN_BOOK)) {
            throw new IllegalArgumentException("Book must be Material.WRITTEN_BOOK");
        }
        List pages = ((BookMeta)book.getItemMeta()).spigot().getPages();
        List strPages = pages.stream().map(each -> {
            BaseComponent component = Arrays.stream(each).reduce((BaseComponent)new TextComponent(), (a, b) -> {
                a.addExtra(b);
                return a;
            });
            FloodgateHook.appendHoverEvents(component, h -> h.getAction().equals((Object)HoverEvent.Action.SHOW_TEXT));
            return component.toLegacyText();
        }).collect(Collectors.toList());
        String result = String.join((CharSequence)("\n\n" + ChatColor.RESET + "---------------------\n\n"), strPages);
        FloodgateApi.getInstance().sendForm(uuid, (FormBuilder)((SimpleForm.Builder)SimpleForm.builder().title("")).content(result));
    }

    private static void appendHoverEvents(BaseComponent component, Predicate<HoverEvent> predicate) {
        if (component.getHoverEvent() != null && predicate.test(component.getHoverEvent())) {
            boolean endsWithNewLine = component.toPlainText().endsWith("\n");
            component.addExtra((endsWithNewLine ? "" : "\n") + ChatColor.RESET + "(" + Arrays.stream(component.getHoverEvent().getValue()).reduce((BaseComponent)new TextComponent(), (a, b) -> {
                a.addExtra(b);
                return a;
            }).toLegacyText() + ChatColor.RESET + ")\n");
        }
        if (component.getExtra() != null) {
            for (BaseComponent extra : component.getExtra()) {
                FloodgateHook.appendHoverEvents(extra, predicate);
            }
        }
    }
}

